
/**
   Starter for plugins.
   The plugins are identified by their extension

   .wav ->WavPlayObject
   .mp3 ->MP3PlayObject
   .mpg ->MPGPlayObject
   .ogg ->OGGPlayObject
*/


#include "soundserver.h"
#include "kmedia2.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string>
#include <iostream>

using namespace std;
using namespace Arts;

#if defined(HAVE_GETOPT_H) 
#include <getopt.h>
#endif


string file1;
string file2;

Dispatcher* d=NULL;
SimpleSoundServer* server=NULL;



void usage() {
  cout << "mpeglibartsply command line tool for arts playobjects"<<endl;
  cout << "Usage : mpeglibartsply [url]"<<endl;
  cout << endl;
  cout << "-1 : create/destroy PlayObject test."<<endl;
  cout << "-2 : create/seek/play/destroy PlayObject test."<<endl;
  cout << "-h : help"<<endl;
  cout << endl;
  cout << "THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! " \
       << "USE AT YOUR OWN RISK!"<<endl;
  cout << endl;
  exit(0);
}


void initServer() {
  d=new Dispatcher();
  server= new SimpleSoundServer (Reference("global:Arts_SimpleSoundServer"));
  
  if(server->isNull()) {
    cerr << "Can't connect to sound server" << endl;
    exit(0);
  }

}


void destroyServer() {
  delete server;
  delete d;
}

/**
   create destroy playobjects without playing anything
*/
void doStress1() {
  int cnt=0;
  while (cnt < 10000) {
    PlayObject play=server->createPlayObject(file1);
    cout << "cnt:"<<cnt++<<endl;
  }
}

/**
   create playobjects playing some time, do seek play destroy
*/
void doStress2() {
  int cnt=0;
  while (cnt < 1000) {
    PlayObject play=server->createPlayObject(file1);
    play.play();
    sleep(3);
    poTime seekTime;
    seekTime.seconds=100;
    seekTime.ms=0;
    play.seek(seekTime);
    sleep(4);
    cout << "cnt:"<<cnt++<<endl;
  }
}


int main(int argc, char **argv) {
  int testNr=0;
  int c;
  initServer();

  while(1) { 
    c = getopt (argc, argv, "123456h");
    if (c == -1) break;
    switch(c) {
    case '1': {    
      testNr=1;
      break;
    }
    case '2': {
      testNr=2;
      break;
    }
    case '3': {
      testNr=3;
      break;
    }
    case '4': {
      testNr=4;
      break;
    }
    case '5': {
      testNr=5;
      break;
    }
    case '6': {
      testNr=5;
      break;
    }
    case 'h': {
      usage();
      break;
    }
    default:
      printf ("?? getopt returned character code 0%o ??\n", c);
      usage();
      exit(-1);
    }
  }
  if(testNr==0) {
    usage();
    exit(-1);
  }

  if (optind < argc ) {
    file1=argv[optind];
    optind++;
    file2=file1;
  }
  if (optind < argc ) {
    file2=argv[optind];
  }  


  switch(testNr) {
  case 1: {
    doStress1();
    break;
  }
  case 2: {
    doStress2();
    break;
  }  default:
    PlayObject play=server->createPlayObject(file1);
    play.play();
    while (play.state() != posIdle) {
      sleep(1);
    }
  }

  destroyServer();
}
