#ifndef NOATUN_EQUALIZER_H
#define NOATUN_EQUALIZER_H

#include <qlist.h>
#include <qobject.h>
#include <kurl.h>

namespace Arts { class StereoEffect; }
class Engine;
class Equalizer;

class Band
{
friend class Equalizer;
friend class QList<Band>;
private:
	Band();
	Band(int start, int end);
	virtual ~Band();
public:
	/**
	 * the intensity of the change.
	 * it's logarithmic.  0 is no change
	 * negative numbers are loss in intensity
	 * positive numbers are a gain
	 * And +-100 is the most you'd need to go
	 **/
	int level();
	void setLevel(int l);
	
	int start() const;
	int end() const;

	/**
	 * the middle between start and end
	 **/
	int center() const;

	QString formatStart(bool withHz=true) const;
	QString formatEnd(bool withHz=true) const;
	/**
	 * return the format for center()
	 **/
	QString format(bool withHz=true) const;
	
private:
	int mLevel;
	int mStart, mEnd;
};


class Equalizer : public QObject
{
friend class Band;
Q_OBJECT
public:
	Equalizer();
	~Equalizer();
	
	const QList<Band> &bands() const;
	Band *band(int num) const;
	int bandCount() const;

	int preamp() const;
	bool isEnabled() const;
	
	void init();
	
public slots:
	/**
	 * set the preamplification
	 * it's logarithmic.  0 is no change
	 * negative numbers are loss in intensity
	 * positive numbers are a gain
	 * And +-100 is the most you'd need to go
	 **/
	void setPreamp(int p);
	void enable();
	void disable();
	void setEnabled(bool e);

// saveing eq stuff
	/**
	 * save the current levels
	 * all noatun equalizer files have the "*.noatunequalizer"
	 * pattern.  Nevertheless, the file can be identified
	 * by magic, so it's not required
	 **/
	bool save(const KURL &file) const;

	/**
	 * restore the EQ settings from this file
	 **/
	bool load(const KURL &file);
	
signals:
	void changed(Band *band);
	void changed();
	void enabled();
	void disabled();
	void enabled(bool e);

	void preampChanged(int p);
	void preampChanged();
	
private:
	void add(Band*);
	void remove(Band*);
	// apply the data to artsd
	void enableUpdates(bool on=true);
	void update(bool full=false);
	
private:
	QList<Band> mBands;
	bool mUpdates;
	int mPreamp;
};



#endif

