/*
  a GUI for a spectrum analyser
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <guiSpectrumAnalyser.h>




GuiSpectrumAnalyser::GuiSpectrumAnalyser( QWidget *parent, 
		     const char *name):QWidget(parent,name) {
  // change this to test (eg : 50)
  spaHeight=15;
  spectrumImage= new SpectrumImage(spaHeight);

  setBackgroundColor (QColor(0,0,0));
  initBands();
}


GuiSpectrumAnalyser::~GuiSpectrumAnalyser() {
  delete spectrumImage;
}



void GuiSpectrumAnalyser::initBands() {

  bands=75;

  pixMap=new QPixmap(bands,spaHeight);
  QColor color(black);
  pixMap->fill(color);
  currentPeaks=new float[bands];
  int i;
  for(i=0;i<bands;i++) {
    currentPeaks[i]=0.0;
  }

  width=bands;
  height=spaHeight;
  setMinimumSize( width, height );
  setMaximumSize( width, height );
  nextPeaks=NULL;

}


void GuiSpectrumAnalyser::setValues(float floatArray[75]) {
  nextPeaks=floatArray;
  repaint(false);
}


void GuiSpectrumAnalyser::mousePressEvent ( QMouseEvent* mouseEvent) {
  if (mouseEvent->button() ==  RightButton) {
    cout << "RightButton"<<endl;
  }
}


QSize GuiSpectrumAnalyser::sizeHint() const {
  QSize size(70,20);
  return size;
}



void GuiSpectrumAnalyser::paintEvent (QPaintEvent * paintEvent) {
  int i;
  float* bandPtr;
  int bands;
  float value;
  QPixmap* peakMap;

  if (nextPeaks == NULL) {
    return;
  }
  bandPtr=nextPeaks;
  bands=75;
  peakMap=spectrumImage->getPixmap();

  QPainter p;                             // our painter
  p.begin( pixMap );                     // start painting pixmap

  for (i=0;i<bands;i++) {
    value=bandPtr[i];
    // if the peak is less we prefer the higher one
    if (currentPeaks[i] < value) {
      currentPeaks[i]=value;
    } else {
      currentPeaks[i]=currentPeaks[i]-1.3;
    }
    if (currentPeaks[i] < 0) {
      currentPeaks[i]=0;
    }
    if (currentPeaks[i] > spaHeight) {
      currentPeaks[i]=spaHeight;
    }    
    p.drawPixmap(i,0,(*peakMap),currentPeaks[i],0,1,spaHeight);
  } 

  p.end();                                // painting done
  bitBlt( this, 0,0, pixMap,0,0 );        
}


  





