#include <klocale.h>
#include <qframe.h>
#include <qvbox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <kapp.h>
#include "krfboptions.h"

#include "kvncoptionsdlg.moc"

#include "kvncoptionsdlg.h"

KVNCOptionsDlg::KVNCOptionsDlg( KRFBOptions *options,
				QWidget *parent, char *name, bool modal )
  : KDialogBase( TreeList, i18n("Preferences"), Help|Default|Ok|Cancel,
		 Ok, parent, name, modal, true )
{
  this->options = options;

  setHelp( "keystone/index.html", QString::null );

  QString item = i18n( "Connection Options" );
  QFrame *frame2 = addPage( item );
  setupConnectionPage( frame2 );

  item = i18n( "Data Encoding" );
  QString header = i18n("RFB Data Encoding Formats");

  QFrame *frame = addPage( item, header );
  setupEncodingPage( frame );

  incInitialSize( QSize(100,100) );
}

KVNCOptionsDlg::~KVNCOptionsDlg()
{

}

void KVNCOptionsDlg::slotDefault()
{

}

void KVNCOptionsDlg::slotOk()
{
  options->hexTile = hex->isChecked();
  options->corre = corre->isChecked();
  options->rre = rre->isChecked();
  options->copyrect = copyRect->isChecked();
  options->deIconify = deIconify->isChecked();
  options->colors256 = bit->isChecked();
  options->shared = shared->isChecked();
  options->updateRate = timeBox->value();

  done(1);
}

void KVNCOptionsDlg::setupEncodingPage( QFrame *frame )
{
  QVBoxLayout *outer = new QVBoxLayout( frame, 0, spacingHint() );
  QVBox *box = new QVBox( frame );
  box->setSpacing( spacingHint() );
  outer->addWidget( box );

  hex = new QCheckBox(i18n("He&xtile encoding"), box);
  corre = new QCheckBox(i18n("&CoRRE encoding"),box);
  rre = new QCheckBox(i18n("&RRE encoding"),box);
  copyRect = new QCheckBox(i18n("C&opy rectangle encoding"),box);
  raw = new QCheckBox(i18n("Raw encoding (always enabled)"),box);

  hex->setChecked( options->hexTile );
  corre->setChecked( options->corre );
  rre->setChecked( options->rre );
  copyRect->setChecked( options->copyrect );

  raw->setChecked( true );
  raw->setEnabled( false );

  // TODO
  hex->setEnabled( false );
  corre->setEnabled( false );
  rre->setEnabled( false );
  // /TODO

  outer->addStretch( 10 );
}

void KVNCOptionsDlg::setupConnectionPage( QFrame *frame )
{
  QVBoxLayout *outer = new QVBoxLayout( frame, 0, spacingHint() );

  QLabel *speedLabel = new QLabel( i18n("&Check for screen updates every:"),
                                   frame );

  QHBox *hbox = new QHBox( frame );
  hbox->setSpacing( spacingHint() );

  timeBox = new QSpinBox( 1, 30000, 1, hbox );
  hbox->setSpacing( spacingHint() );
  new QLabel( i18n( "Milliseconds" ), hbox );

  speedLabel->setBuddy( timeBox );
  outer->addWidget( speedLabel );
  outer->addWidget( hbox );

  outer->addSpacing( spacingHint() );


  QVBox *box2 = new QVBox( frame );
  box2->setSpacing( spacingHint() );
  outer->addWidget( box2 );

  bit = new QCheckBox( i18n( "Request &8-bit session" ), box2 );
  QWhatsThis::add( bit, i18n ( "<qt><p>If enabled this option tells Keystone to use 8 bit color even if "\
                              "both the local and remote screens support higher color depths. This "\
                              "gives better performance over slow links, but a less realistic "\
                              "representation of the remote screen.</p>"\
                              "<p>Note that Keystone will automatically use 8 bit mode if this is "\
                              "the most realistic representation available.</p></qt>" ) );

  deIconify = new QCheckBox( i18n( "Deiconify on &bell" ), box2 );
  QWhatsThis::add( deIconify, i18n ( "<qt><p>If enabled this option tells Keystone to de-iconify "\
                                     "itself when the bell is rung on the remote screen.</p></qt>" ) );

  shared = new QCheckBox( i18n( "Request &shared session" ), box2 );
  QWhatsThis::add( shared, i18n ( "<qt><p>If enabled this option tells Keystone to allow other sessions "\
                                 "to remain connected to the remote screen. Unless this is selected, "\
                                  "other sessions will be disconnected when Keystone logs onto a "\
                                  "remote screen.</p></qt>" ) );

  deIconify->setChecked( options->deIconify );
  bit->setChecked( options->colors256 );
  shared->setChecked( options->shared );
  timeBox->setValue( options->updateRate );

  outer->addStretch( 10 );
}


