#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "kvnc.h"
#include "version.h"

static const char *description=I18N_NOOP("The KDE Virtual Network Computer Client");

static const KCmdLineOptions options[] =
{
	{ "+url",
      I18N_NOOP("A VNC URL to Open (ie. vnc://:pass@localhost:1/)"),
      0 },
	{ 0, 0, 0}
};

int main( int argc, char **argv )
{
  KAboutData aboutData( "keystone", I18N_NOOP("Keystone"),
			KVNCVERSION, description, KAboutData::License_GPL,
			"(c) 1999-2000, Richard Moore");
  aboutData.addAuthor("Richard Moore",0, "rich@kde.org");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication a;
  KVNC *view = new KVNC( "Keystone" );
  view->resize( 320, 240 );

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  if ( args->count() )
    view->openURL( args->url( 0 ) );

  view->show();

  return a.exec();
}

