// kitsockset.h
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#ifndef KITSOCKSET_H
#define KITSOCKSET_H

#include "kitsocket.h"

bool socksConnect(int socket, const QString &host, unsigned short port,
                  bool do1929 = false, const QString &name = QString::null, const QString &password = QString::null);

class KitSOCKSet : public KitSocket
{
	Q_OBJECT

	public:
		KitSOCKSet(const QString &host, unsigned short port,
                     const QString &socksHost, unsigned short socksPort,
                     bool auth = false, const QString &name = QString::null, const QString &password = QString::null,
                     int timeout = 30);
		~KitSOCKSet();
		virtual bool connect(void);
	private:
		QString wantedHost;
		unsigned short wantedPort;
		QString username, password;
		bool do1929;
};

#endif
