
#include<assert.h>

#include<qwidget.h>
#include<qstring.h>
#include<qtooltip.h>
#include<qpainter.h>
#include<qcolor.h>
#include<qpalette.h>

#include<kiconloader.h>
#include<kglobal.h>
#include<krun.h>
#include<kdebug.h>
#include<kprocess.h>

#include"kornbutt.h"
#include"maildrop.h"

KornButton::KornButton( QWidget *parent, KMailDrop *box )
  :
  QToolButton(parent, "kornbutton"),
  _box(box),
  _lastNum(0)
{
  assert(box);

  connect(_box, SIGNAL(changed(int)),       this, SLOT(setNumber(int)));
  connect(_box, SIGNAL(notifyDisconnect()), this, SLOT(disconnectMonitor()));
  connect(_box, SIGNAL(configChanged()),    this, SLOT(monitorUpdated()));

  monitorUpdated();

  _box->startMonitor();
}

void KornButton::setNumber(int num)
{
  if (0 == _box)
    return;
  
  if (_box->count() != _lastNum)
    setText(QString::number(_box->count()));

  bool newMessages = _box->count() > _lastNum;
  _lastNum = num;

  if (newMessages && !_box->newMailCmd().isEmpty())
	{
		KShellProcess * proc = new KShellProcess;
		*proc << _box->newMailCmd();
		proc->start();
	}
}

void KornButton::runCommand(bool onlyIfUnread)
{
  kdDebug() << "KornButton::runCommand(" << (onlyIfUnread ? "true" : "false") << ")" << endl;
  if (0 == _box)
    return;

  if (onlyIfUnread) {

    _box->recheck();

    if (0 == _box->count())
      return;
  }

  kdDebug() << "KornButton::runCommand: clickCmd == `" << _box->clickCmd() << "'" << endl;

  if (!_box->clickCmd().isEmpty())
	{
		KShellProcess * proc = new KShellProcess;
		*proc << _box->clickCmd();
		proc->start();
	}
}

void KornButton::disconnectMonitor()
{
  _box->stopMonitor();
  _box = 0;

  emit dying(this);
}

void KornButton::monitorUpdated()
{
  kdDebug() << "KornButton::monitorUpdated()" << endl;
  kdDebug() << "count = " << _box->count() << endl;

  kdDebug() << "modes: Plain: " << KMailDrop::Plain << ", Colour: " << KMailDrop::Colour << ", Icon: " << KMailDrop::Icon << endl;

#if 0
  kdDebug() << "mode = " << _box->displayStyle() << endl;
  kdDebug() << "bg   = " << _box->bgColour().name() << endl;
  kdDebug() << "fg   = " << _box->fgColour().name() << endl;
  kdDebug() << "bgn  = " << _box->newBgColour().name() << endl;
  kdDebug() << "fgn  = " << _box->newFgColour().name() << endl;
  kdDebug() << "icon = " << _box->icon() << endl;
  kdDebug() << "iconn= " << _box->newIcon() << endl;
#endif

  if (0 == _box)
    return;

  QToolTip::remove(this);

  QToolTip::add(this, _box->caption());

  bool newMessages = _box->count() > _lastNum;
  _lastNum = _box->count();
  
  setText(QString::number(_box->count()));

  switch (_box->displayStyle()) {

    case KMailDrop::Colour:
      {
        kdDebug() << "Setting palette" << endl;
        QPalette p = palette();

        if (newMessages) {

          p.setColor(QColorGroup::Button, _box->newBgColour());
          p.setColor(QColorGroup::ButtonText, _box->newFgColour());
          p.setColor(QColorGroup::Foreground, _box->newFgColour());

        } else {

          p.setColor(QColorGroup::Button, _box->bgColour());
          p.setColor(QColorGroup::ButtonText, _box->fgColour());
          p.setColor(QColorGroup::Foreground, _box->fgColour());
        }

        setPalette(p);
      }
      break;

    case KMailDrop::Icon:
      {
        kdDebug() << "Setting icon" << endl;
        QPixmap icon(KGlobal::iconLoader()->loadIcon(_box->icon(), KIcon::Desktop));
        QPixmap newIcon(KGlobal::iconLoader()->loadIcon(_box->newIcon(), KIcon::Desktop));
        if (icon.isNull())
          kdDebug() << "icon is null" << endl;
        if (newIcon.isNull())
          kdDebug() << "newicon is null" << endl;

        QSize size1 = icon.size();
        QSize size2 = newIcon.size();

        QSize mySize(
          QMAX(size1.width(), size2.width()),
          QMAX(size1.height(), size2.height())
                    );

        resize(mySize);

        if (_lastNum < _box->count())
          setPixmap(newIcon);
        else
          setPixmap(icon);
      }
      break;

    default:
      break;
  }
}

  void
KornButton::mousePressEvent(QMouseEvent * e)
{
  if (e->button() == RightButton) {
    emit(rightClick());
  }
}
  void
KornButton::mouseReleaseEvent(QMouseEvent * e)
{
  switch (e->button()) {
    case LeftButton:  runCommand(e->state() & ShiftButton); break;
    case MidButton:   _box->forceCountZero();               break;
    default:                                                break;
  }
}

HeadButton::HeadButton( QWidget *parent )
  :
  QToolButton(parent, "headbutton")
{
  setText("Korn");
}

void
HeadButton::mousePressEvent(QMouseEvent * e)
{
  if (e->button() == RightButton) {
    emit(rightClick());
  }
}


#include "kornbutt.moc"
