/*
    YPS-0.2, NIS-Server for Linux
    Copyright (C) 1994  Tobias Reber

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
static char rcsid[]="(#)$Id: makedbm.c,v 0.18 1994/01/02 21:59:08 root Exp $";

/*
 * $Author: root $
 * $log$
 */

#define BUFFERSIZE 4096

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/param.h>
#include <netdb.h>
#ifdef GDBM
#include "dbmcompat.h"
#else
#include <dbm.h>
#endif

extern int optind;
extern char *optarg;

static char *DomainName=NULL;
static char *InputFileName=NULL;
static char *OutputFileName=NULL;
static char *MasterName=NULL;
static char thisHost[MAXHOSTNAMELEN+1];

static void
unLoad(char *DbName)
{
	datum key, data;
	if (dbminit(DbName)) {
		fprintf(stderr, "%s: Cannot open\n", DbName);
		perror(DbName);
		exit(1);
	}
	for (key=firstkey(); key.dptr; key=nextkey(key)) {
		data=fetch(key);
		if (!data.dptr) {
			fprintf(stderr, "Error\n");
			exit (1);
		}
		fwrite(key.dptr, key.dsize, 1, stdout);
		putc(' ', stdout);
		fwrite(data.dptr, data.dsize, 1, stdout);
		putc('\n', stdout);
	}
	dbmclose();
}

static void
load( char *FileName, char *DbName)
{
	static char Buffer[BUFFERSIZE];
	static char filename[1024], filename2[1024];
	FILE *infile;
	datum key, data;

	infile=strcmp(FileName, "-")?fopen(FileName, "r"):stdin;
	if (infile==NULL) {
		fprintf(stderr, "%s: Cannot open\n", FileName);
		exit(1);
	}

#ifndef GDBM
	sprintf(filename, "%s~.dir", DbName);
	{
		int fd=open(filename, O_WRONLY|O_TRUNC|O_CREAT, 0755);
		if (fd<0) perror(filename);
		close(fd);
	}
	sprintf(filename, "%s~.pag", DbName);
	{
		int fd=open(filename, O_WRONLY|O_TRUNC|O_CREAT, 0755);
		if (fd<0) perror(filename);
		close(fd);
	}
#endif
	sprintf(filename, "%s~", DbName);
	if (dbminit(filename)) {
		fprintf(stderr, "%s: Cannot open\n", filename);
		exit(1);
	}

	if (MasterName && *MasterName) {
		key.dptr="YP_MASTER_NAME"; key.dsize=strlen(key.dptr);
		data.dptr=MasterName; data.dsize=strlen(MasterName);
		store(key, data);
	}

	if (DomainName && *DomainName) {
		key.dptr="YP_DOMAIN_NAME"; key.dsize=strlen(key.dptr);
		data.dptr=DomainName; data.dsize=strlen(DomainName);
		store(key, data);
	}

	if (InputFileName && *InputFileName) {
		key.dptr="YP_INPUT_NAME"; key.dsize=strlen(key.dptr);
		data.dptr=InputFileName; data.dsize=strlen(InputFileName);
		store(key, data);
	}

	if (OutputFileName && *OutputFileName) {
		key.dptr="YP_OUTPUT_NAME"; key.dsize=strlen(key.dptr);
		data.dptr=OutputFileName; data.dsize=strlen(OutputFileName);
		store(key, data);
	}

	{
		char OrderNum[12];
		struct timeval tv;
		struct timezone tz;
		gettimeofday(&tv, &tz);
		sprintf(OrderNum, "%ld", tv.tv_sec);
		key.dptr="YP_LAST_MODIFIED"; key.dsize=strlen(key.dptr);
		data.dptr=OrderNum; data.dsize=strlen(OrderNum);
		store(key, data);
	}

	for(;;) {
		register int r;

		fgets(Buffer, BUFFERSIZE, infile);
		if (feof(infile)) break;
		r=strlen(Buffer)-1;
		if (Buffer[r]!='\n' && r>=BUFFERSIZE) {
			fprintf(stderr, "%s: Buffer overflow\n", FileName);
			exit(1);
		} else
			Buffer[r]='\0';

		for (r=0; Buffer[r]; r++) {
			if (Buffer[r]==' ' || Buffer[r]=='\t') {
				Buffer[r]='\0';
				r++;
				break;
			}
		}
		for (; Buffer[r]; r++)
			if (Buffer[r]!=' ' && Buffer[r]!='\t') break;

		key.dptr=Buffer; key.dsize=strlen(Buffer);
		data.dptr=Buffer+r; data.dsize=strlen(Buffer+r);
		store(key, data);
	}
	dbmclose();
#ifndef GDBM
	sprintf(filename, "%s.dir", DbName);
	sprintf(filename2, "%s~.dir", DbName);
	unlink(filename);
	rename(filename2, filename);
#endif
	sprintf(filename, "%s.pag", DbName);
	sprintf(filename2, "%s~.pag", DbName);
	unlink(filename);
	rename(filename2, filename);
}

static void
Usage( void)
{
	fprintf(stderr, "usage: makedbm -u dbname\n");
	fprintf(stderr, "       makedbm [-i inputfile] [-o outputfile]\n");
	fprintf(stderr, "               [-m mastername] inputfile dbname\n");
	exit(1);
}

void
main(int argc, char **argv)
{
	int UFlag=0;

	while(1) {
		int c=getopt(argc, argv, "ui:o:m:d:");
		if (c==EOF) break;
		switch (c) {
		case 'u': 
			UFlag++;
			break;
		case 'd':
			DomainName=optarg;
			break;
		case 'i':
			InputFileName=optarg;
			break;
		case 'o':
			OutputFileName=optarg;
			break;
		case 'm':
			MasterName=optarg;
			break;
		case '?':
			Usage();
			break;
		}
	}
	argc-=optind;
	argv+=optind;

	if (!MasterName) {
		if (gethostname(thisHost, sizeof thisHost)<0) {
			perror("gethostname");
		} else {
			struct hostent *h;
			h=gethostbyname(thisHost);
			if (h) strncpy(thisHost, h->h_name, sizeof thisHost);
			MasterName=thisHost;
		}
	}
	if (UFlag) {
		if (argc<1) Usage();
		unLoad(argv[0]);
	} else {
		if (argc<2) Usage();
		load(argv[0], argv[1]);
	}
}
