.\" $Xorg: XdbeGetV.man,v 1.3 2000/08/17 19:41:55 cpqbld Exp $
.\"
.\" Copyright (c) 1995  Hewlett-Packard Company
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"), 
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense, 
.\" and/or sell copies of the Software, and to permit persons to whom the 
.\" Software furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
.\" HEWLETT-PACKARD COMPANY BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
.\" SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the Hewlett-Packard Company shall not 
.\" be used in advertising or otherwise to promote the sale, use or other 
.\" dealing in this Software without prior written authorization from the 
.\" Hewlett-Packard Company.
.\"
.\" $XFree86: xc/doc/man/Xext/dbe/XdbeGetV.man,v 3.5 2001/02/07 22:35:22 tsi Exp $
.\"
.TH XdbeGetVisualInfo 3X11 __xorgversion__ "X FUNCTIONS"
.SH NAME
XdbeGetVisualInfo
.SH SYNOPSIS
\&#include <X11/extensions/Xdbe.h>

XdbeScreenVisualInfo *XdbeGetVisualInfo(
    Display  *dpy,
    Drawable *screen_specifiers,
    int      *num_screens)
.SH DESCRIPTION
This function returns information about which visuals support double
buffering.  The argument
.I num_screens
specifies how many elements there are 
in the
.I screen_specifiers
list.  Each drawable in
.I screen_specifiers
designates a 
screen for which the supported visuals are being requested.  If
.I num_screens
is zero, information for all screens is requested.  In this case, upon return
from this function,
.I num_screens
will be set to the number of screens that were
found.  If an error occurs, this function returns NULL, else it returns a
pointer to a list of
.I XdbeScreenVisualInfo
structures of length
.I num_screens.
The nth
element in the returned list corresponds to the nth drawable in the 
.I screen_specifiers
list, unless
.I num_screens
was passed in with the value zero,
in which case the nth element in the returned list corresponds to the nth screen
of the server, starting with screen zero.  The
.I XdbeScreenVisualInfo
structure has the following fields:

     int            count
     XdbeVisualInfo *visinfo

.I count
specifies the number of items in
.I visinfo.
.I visinfo
specifies a list of visuals, depths, and performance hints for this screen.

The
.I XdbeVisualInfo
structure has the following fields:

     VisualID visual
     int      depth
     int      perflevel

.I visual
specifies one visual ID that supports double-buffering.
.I depth
specifies the depth of the visual.
.I perflevel
is a performance hint.

The only operation defined on a
.I perflevel
is comparison to a
.I perflevel
of another visual on the same screen.  The visual having the higher
.I perflevel
is likely to have better double-buffering graphics performance than the visual
having the lower
.I perflevel.
Nothing can be deduced from the following: the magnitude of the difference
of two
.I perflevels,
a
.I perflevel
value in isolation, or comparing
.I perflevels
from different servers.

.SH ERRORS
.IP BadDrawable
One or more values passed in
.I screen_specifiers
is not a valid drawable.
.SH SEE ALSO
DBE,
.I XdbeAllocateBackBufferName(),
.I XdbeBeginIdiom(),
.I XdbeDeallocateBackBufferName(),
.I XdbeEndIdiom(),
.I XdbeFreeVisualInfo(),
.I XdbeGetBackBufferAttributes(),
.I XdbeQueryExtension(),
.I XdbeSwapBuffers().

