dnl
dnl $Id: acinclude.m4,v 1.16 2001/05/18 16:03:06 amai Exp $
dnl
dnl This file provides the following macros:
dnl
dnl AC_FIND_XPM
dnl AC_PATH_MOTIF_DIRECT
dnl AC_PATH_MOTIF
dnl LT_HAVE_GETSERVBYNAME
dnl LT_HAVE_GETHOSTBYNAME
dnl LT_WITH_DMALLOC
dnl AC_HAVE_EXCTAGS
dnl



dnl
dnl
dnl AC_FIND_XPM : find libXpm, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_xpm		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_xpm		(e.g. -I/usr/lesstif/lib)
dnl	xpm_libraries		(e.g. /usr/lesstif/lib)
dnl	xpm_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_xpm and include_xpm variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
AC_DEFUN(AC_FIND_XPM,
[
AC_REQUIRE([AC_PATH_XTRA])
xpm_includes=
xpm_libraries=
AC_ARG_WITH(xpm,
[  --without-xpm         do not use Xpm])
dnl Treat --without-xpm like
dnl --without-xpm-includes --without-xpm-libraries.
if test "$with_xpm" = "no"
then
    xpm_includes=no
    xpm_libraries=no
fi
AC_ARG_WITH(xpm-includes,
    [  --with-xpm-includes=DIR    Xpm include files are in DIR], xpm_includes="$withval")
AC_ARG_WITH(xpm-libraries,
    [  --with-xpm-libraries=DIR   Xpm libraries are in DIR], xpm_libraries="$withval")
if test "$xpm_includes" = "no" && test "$xpm_libraries" = "no"
then
    with_xpm="no"
fi

AC_MSG_CHECKING([for Xpm])
if test "$with_xpm" != "no"
then
    #
    #
    # Search the include files.
    #
    if test "$xpm_includes" = ""
    then
	AC_CACHE_VAL(ac_cv_xpm_includes,
	[
	ac_xpm_save_CFLAGS="$CFLAGS"
	ac_xpm_save_CPPFLAGS="$CPPFLAGS"
	#
	CFLAGS="$X_CFLAGS $CFLAGS"
	CPPFLAGS="$X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_COMPILE([#include <X11/xpm.h>],[int a;],
	[
	# X11/xpm.h is in the standard search path.
	ac_cv_xpm_includes=
	],
	[
	# X11/xpm.h is not in the standard search path.
	# Locate it and put its directory in `xpm_includes'
	#
	# Other directories are just guesses.
	for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
		/usr/include/Motif2.1 /usr/include/Motif2.0 /usr/include/Motif1.2 \
		/usr/include/X11R6 /usr/include/X11R5 \
		/usr/dt/include /usr/openwin/include \
		/usr/dt/*/include /opt/*/include /usr/include/Xpm* \
		"${prefix}"/*/include /usr/*/include /usr/local/*/include \
		"${prefix}"/include/* /usr/include/* /usr/local/include/* \
		"${HOME}"/include
	do
	    if test -f "$dir/X11/xpm.h"
	    then
		ac_cv_xpm_includes="$dir"
		break
	    fi
	done
	])
	#
	CFLAGS="$ac_xpm_save_CFLAGS"
	CPPFLAGS="$ac_xpm_save_CPPFLAGS"
	])
	xpm_includes="$ac_cv_xpm_includes"
    fi

    if test -z "$xpm_includes"
    then
	xpm_includes_result="default path"
	XPM_CFLAGS=""
    else
	if test "$xpm_includes" = "no"
	then
	    xpm_includes_result="told not to use them"
	    XPM_CFLAGS=""
	else
	    xpm_includes_result="$xpm_includes"
	    XPM_CFLAGS="-I$xpm_includes"
	fi
    fi
    #
    #
    # Now for the libraries.
    #
    if test "$xpm_libraries" = ""
    then
	AC_CACHE_VAL(ac_cv_xpm_libraries,
	[
	ac_xpm_save_LIBS="$LIBS"
	ac_xpm_save_CFLAGS="$CFLAGS"
	ac_xpm_save_CPPFLAGS="$CPPFLAGS"
	#
	LIBS="-lXpm $X_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
	CFLAGS="$XPM_CFLAGS $X_CFLAGS $CFLAGS"
	CPPFLAGS="$XPM_CFLAGS $X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_LINK([#include <X11/xpm.h>],[XpmAttributesSize();],
	[
	# libXpm.a is in the standard search path.
	ac_cv_xpm_libraries=
	],
	[
	# libXpm.a is not in the standard search path.
	# Locate it and put its directory in `xpm_libraries'
	#
	# Other directories are just guesses.
	for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
		   /usr/lib/Xlt2.0 /usr/lib/Xlt1.2 /usr/lib/Xlt1.1 \
		   /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11 \
		   /usr/dt/lib /usr/openwin/lib \
		   /usr/dt/*/lib /opt/*/lib /usr/lib/Xpm* \
		   /usr/lesstif*/lib /usr/lib/Lesstif* \
		   "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
		   "${prefix}"/lib/* /usr/lib/* /usr/local/lib/* \
		   "${HOME}"/lib
	do
	    for ext in "sl" "so" "a" "lib" ; do
		if test -d "$dir" && test -f "$dir/libXpm.$ext"; then
		    ac_cv_xpm_libraries="$dir"
		    break 2
		fi
	    done
	done
	])
	#
	LIBS="$ac_xpm_save_LIBS"
	CFLAGS="$ac_xpm_save_CFLAGS"
	CPPFLAGS="$ac_xpm_save_CPPFLAGS"
	])
	#
	xpm_libraries="$ac_cv_xpm_libraries"
    fi
    if test -z "$xpm_libraries"
    then
	xpm_libraries_result="default path"
	XPM_LIBS="-lXpm"
    else
	if test "$xpm_libraries" = "no"
	then
	    xpm_libraries_result="told not to use it"
	    XPM_LIBS=""
	else
	    xpm_libraries_result="$xpm_libraries"
	    XPM_LIBS="-L$xpm_libraries -lXpm"
	fi
    fi
#
# Make sure, whatever we found out, we can link.
#
    ac_xpm_save_LIBS="$LIBS"
    ac_xpm_save_CFLAGS="$CFLAGS"
    ac_xpm_save_CPPFLAGS="$CPPFLAGS"
    #
    LIBS="$XPM_LIBS -lXpm $X_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
    CFLAGS="$XPM_CFLAGS $X_CFLAGS $CFLAGS"
    CPPFLAGS="$XPM_CFLAGS $X_CFLAGS $CPPFLAGS"

    AC_TRY_LINK([#include <X11/xpm.h>],[XpmAttributesSize();],
	[
	#
	# link passed
	#
	AC_DEFINE(HAVE_XPM)
	],
	[
	#
	# link failed
	#
	xpm_libraries_result="test link failed"
	xpm_includes_result="test link failed"
	with_xpm="no"
	XPM_CFLAGS=""
	XPM_LIBS=""
	]) dnl AC_TRY_LINK

    LIBS="$ac_xpm_save_LIBS"
    CFLAGS="$ac_xpm_save_CFLAGS"
    CPPFLAGS="$ac_xpm_save_CPPFLAGS"
else
    xpm_libraries_result="told not to use it"
    xpm_includes_result="told not to use them"
    XPM_CFLAGS=""
    XPM_LIBS=""
fi
AC_MSG_RESULT([libraries $xpm_libraries_result, headers $xpm_includes_result])
AC_SUBST(XPM_CFLAGS)
AC_SUBST(XPM_LIBS)
])
dnl AC_DEFN




AC_DEFUN(AC_PATH_MOTIF_DIRECT,
[test -z "$motif_direct_test_library" && motif_direct_test_library=Xm
test -z "$motif_direct_test_function" && motif_direct_test_function=XmCreatePushButton
test -z "$motif_direct_test_include" && motif_direct_test_include=Xm/Xm.h
  for ac_dir in               \
    /usr/include/Motif2.1     \
    /usr/Motif2.1/include     \
                              \
    /usr/include/Motif2.0     \
    /usr/Motif2.0/include     \
                              \
    /usr/include/Motif1.2     \
    /usr/Motif1.2/include     \
                              \
    /usr/motif/include        \
                              \
    /usr/X11R6/include        \
    /usr/X11R5/include        \
                              \
    /usr/include/X11R6        \
    /usr/include/X11R5        \
                              \
    /usr/local/X11R6/include  \
    /usr/local/X11R5/include  \
                              \
    /usr/local/include/X11R6  \
    /usr/local/include/X11R5  \
                              \
    /usr/X11/include          \
    /usr/include/X11          \
    /usr/local/X11/include    \
    /usr/local/include/X11    \
                              \
    /usr/X386/include         \
    /usr/x386/include         \
    /usr/XFree86/include/X11  \
                              \
    /usr/dt/include           \
    /usr/openwin/include      \
    /opt/openwin/include      \
                              \
    /usr/include              \
    /usr/local/include        \
    /usr/unsupported/include  \
    /usr/athena/include       \
    /usr/local/x11r5/include  \
    /usr/lpp/Xamples/include  \
    $PWD/../../include/Motif-1.2   \
    ; \
  do
    if test -r "$ac_dir/$motif_direct_test_include"; then
      no_motif= ac_motif_includes=$ac_dir
      break
    fi
  done

# Check for the libraries.
# See if we find them without any special options.
# Don't add to $LIBS permanently.
ac_save_LIBS="$LIBS"
LIBS="-l$motif_direct_test_library $LIBS"
# First see if replacing the include by lib works.
for ac_dir in `echo "$ac_motif_includes" | sed s/include/lib/` \
    /usr/lib/Motif2.1     \
    /usr/Motif2.1/lib     \
                          \
    /usr/lib/Motif2.0     \
    /usr/Motif2.0/lib     \
                          \
    /usr/lib/Motif1.2     \
    /usr/Motif1.2/lib     \
                          \
    /usr/motif/lib        \
                          \
    /usr/X11R6/lib        \
    /usr/X11R5/lib        \
                          \
    /usr/lib/X11R6        \
    /usr/lib/X11R5        \
                          \
    /usr/local/X11R6/lib  \
    /usr/local/X11R5/lib  \
                          \
    /usr/local/lib/X11R6  \
    /usr/local/lib/X11R5  \
                          \
    /usr/X11/lib          \
    /usr/lib/X11          \
    /usr/local/X11/lib    \
                          \
    /usr/X386/lib         \
    /usr/x386/lib         \
    /usr/XFree86/lib/X11  \
                          \
    /usr/dt/lib           \
    /usr/openwin/lib      \
    /opt/openwin/lib      \
                          \
    /usr/lib              \
    /usr/local/lib        \
    /usr/unsupported/lib  \
    /usr/athena/lib       \
    /usr/local/x11r5/lib  \
    /usr/lpp/Xamples/lib  \
    $PWD/../Xm/.libs      \
    ; \
do
  for ac_extension in a so sl; do
    if test -r $ac_dir/lib${motif_direct_test_library}.$ac_extension; then
      no_motif= ac_motif_libraries=$ac_dir
      break 2
    fi
  done
done
LIBS=$ac_save_LIBS])

AC_DEFUN(AC_PATH_MOTIF,
[AC_REQUIRE_CPP()dnl

AC_ARG_WITH(motif-includes, [  --with-motif-includes=DIR     Motif include files are in DIR])
if test -z "$with_motif_includes"; then
  motif_includes=NONE
else
  motif_includes=$with_motif_includes
fi
AC_ARG_WITH(motif-libraries, [  --with-motif-libraries=DIR    Motif library files are in DIR])
if test -z "$with_motif_libraries"; then
  motif_libraries=NONE
else
  motif_libraries=$with_motif_libraries
fi

AC_MSG_CHECKING(for Motif)
AC_ARG_WITH(motif, [  --with-motif            enable Motif])
if test "x$with_motif" = xno; then
  no_motif=yes
else
  if test "x$motif_includes" != xNONE && test "x$motif_libraries" != xNONE; then
    no_motif=
  else
AC_CACHE_VAL(ac_cv_path_motif,
[# One or both of these vars are not set, and there is no cached value.
no_motif=yes
AC_PATH_MOTIF_DIRECT

if test "$no_motif" = yes; then
  ac_cv_path_motif="no_motif=yes"
else
  ac_cv_path_motif="no_motif= ac_motif_includes=$ac_motif_includes ac_motif_libraries=$ac_motif_libraries"
fi])dnl
  fi
  eval "$ac_cv_path_motif"
fi # with_motif != no

if test "$no_motif" = yes; then
  AC_MSG_RESULT(no)
else
  test "x$motif_includes" = xNONE && motif_includes=$ac_motif_includes
  test "x$motif_libraries" = xNONE && motif_libraries=$ac_motif_libraries
  ac_cv_path_motif="no_motif= ac_motif_includes=$motif_includes ac_motif_libraries=$motif_libraries"
  AC_MSG_RESULT([libraries $motif_libraries, headers $motif_includes])
fi
test "x$motif_libraries" != "xNONE" && test "x$motif_libraries" != "x" && MOTIF_LIBS=-L$motif_libraries
test "x$motif_includes" != "xNONE" && test "x$motif_includes" != "x" && MOTIF_CFLAGS=-I$motif_includes
AC_SUBST(MOTIF_LIBS)
AC_SUBST(MOTIF_CFLAGS)
])



dnl
dnl Extended check for getservbyname()
dnl
AC_DEFUN(LT_HAVE_GETSERVBYNAME,
[AC_REQUIRE([AC_PATH_X])
AC_CACHE_CHECK(whether getservbyname() is available, lt_cv_getservbyname,
[lt_save_CFLAGS="$CFLAGS"
lt_save_CPPFLAGS="$CPPFLAGS"
lt_save_LIBS="$LIBS"
LIBS="$X_EXTRA_LIBS"
CFLAGS="$X_CFLAGS $CFLAGS"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
AC_TRY_LINK(
[
#include <netdb.h>
],
[
struct servent *se;
const char *service="";
const char *protocol="tcp";
se=getservbyname(service, protocol);
],
lt_cv_getservbyname=yes,
lt_cv_getservbyname=no)
CFLAGS="$lt_save_CFLAGS"
CPPFLAGS="$lt_save_CPPFLAGS"
LIBS="$lt_save_LIBS"
])
if test $lt_cv_getservbyname = yes; then
  AC_DEFINE(HAVE_GETSERVBYNAME)
fi
])



dnl
dnl Extended check for gethostbyname()
dnl
AC_DEFUN(LT_HAVE_GETHOSTBYNAME,
[AC_REQUIRE([AC_PATH_X])
AC_CACHE_CHECK(whether gethostbyname() is available, lt_cv_gethostbyname,
[lt_save_CFLAGS="$CFLAGS"
lt_save_CPPFLAGS="$CPPFLAGS"
lt_save_LIBS="$LIBS"
LIBS="$X_EXTRA_LIBS"
CFLAGS="$X_CFLAGS $CFLAGS"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
AC_TRY_LINK(
[
#include <netdb.h>
],
[
struct hostent *she;
const char *name="";
she=gethostbyname(name);
],
lt_cv_gethostbyname=yes,
lt_cv_gethostbyname=no)
CFLAGS="$lt_save_CFLAGS"
CPPFLAGS="$lt_save_CPPFLAGS"
LIBS="$lt_save_LIBS"
])
if test $lt_cv_gethostbyname = yes; then
  AC_DEFINE(HAVE_GETHOSTBYNAME)
fi
])


dnl
dnl Enable malloc checker for debugging purposes
dnl See http://dmalloc.com, INSTALL(.html) for references to this.
dnl Source code which depends on this is mostly in
dnl DebugUtil.c/.h
dnl
AC_DEFUN(LT_WITH_DMALLOC,
[AC_MSG_CHECKING(if malloc debugging is wanted)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc[=path]   use dmalloc, see INSTALL(.html) for reference],
[if test "$withval" = no; then
  AC_MSG_RESULT(no)
else
  if test "$withval" != yes; then
dnl  a path was given
     CFLAGS="$CFLAGS -I$withval/include -DDMALLOC_FUNC_CHECK"
dnl link libs (LDFLAGS) and programs (LIBS) with it!?
     LDFLAGS="$LDFLAGS -L$withval/lib -ldmalloc"
     LIBS="$LIBS -L$withval/lib -ldmalloc"
  else
     CFLAGS="$CFLAGS -DDMALLOC_FUNC_CHECK"
     LDFLAGS="$LDFLAGS -ldmalloc"
     LIBS="$LIBS -ldmalloc"
  fi
  AC_TRY_LINK(
  [#include <dmalloc.h>],
  [char *ptr;
  ptr=malloc(1);]
  ,
  [AC_DEFINE(WITH_DMALLOC,1,
            [Define if using the dmalloc debugging malloc package])
  AC_MSG_RESULT(Using dmalloc)],
  AC_MSG_ERROR(dmalloc not found)
  
  )
fi],
[AC_MSG_RESULT(no)])
])



dnl
dnl Checks whether Exuberant ctags is present
dnl (see http://darren.hiebert.com/ctags/index.html)
dnl
AC_DEFUN(AC_HAVE_EXCTAGS,
[
ac_have_exctags=no
AC_CHECK_PROG(ac_have_ctags, ctags, yes, no)
if test "$ac_have_ctags" = "yes"; then
  AC_MSG_CHECKING(if ctags is actually Exuberant ctags)
  if test -z "`ctags --version 2>/dev/null | grep Exuberant`" ; then
    ac_have_exctags=no
  else
    ac_have_exctags=yes
  fi
  AC_MSG_RESULT($ac_have_exctags)
fi 
AM_CONDITIONAL(Have_Exctags, test "$ac_have_exctags" = "yes")
])
