/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.io.Serializable;

public class Dialog
extends Window
implements Serializable {
    private static final long serialVersionUID = 5920926903803293709L;
    private boolean modal;
    private boolean resizable;
    private String title;

    public Dialog(Frame parent) {
        this(parent, "", false);
    }

    public Dialog(Frame parent, boolean modal) {
        this(parent, "", modal);
    }

    public Dialog(Frame parent, String title) {
        this(parent, title, false);
    }

    public Dialog(Frame parent, String title, boolean modal) {
        super(parent);
        this.title = title;
        this.modal = modal;
        this.resizable = false;
        this.setLayout(new BorderLayout());
    }

    public Dialog(Dialog owner) {
        this(owner, "", false);
    }

    public Dialog(Dialog owner, String title) {
        this(owner, title, false);
    }

    public Dialog(Dialog owner, String title, boolean modal) {
        super(owner);
        this.modal = modal;
        this.title = title;
        this.setLayout(new BorderLayout());
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String title) {
        this.title = title;
        if (this.peer != null) {
            DialogPeer d = (DialogPeer)this.peer;
            d.setTitle(title);
        }
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (this.peer != null) {
            DialogPeer d = (DialogPeer)this.peer;
            d.setResizable(resizable);
        }
    }

    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createDialog(this);
        }
        super.addNotify();
    }

    public void show() {
        super.show();
    }

    protected String paramString() {
        return "title+" + this.title + ",modal=" + this.modal + ",resizable=" + this.resizable + "," + super.paramString();
    }
}

