/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.peer.FileDialogPeer;
import java.io.FilenameFilter;
import java.io.Serializable;

public class FileDialog
extends Dialog
implements Serializable {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    private static final long serialVersionUID = 5035145889651310422L;
    private String dir;
    private String file;
    private FilenameFilter filter;
    private int mode;

    public FileDialog(Frame parent) {
        this(parent, "", 0);
    }

    public FileDialog(Frame parent, String title) {
        this(parent, title, 0);
    }

    public FileDialog(Frame parent, String title, int mode) {
        super(parent, title, true);
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        this.mode = mode;
    }

    public String getDirectory() {
        return this.dir;
    }

    public synchronized void setDirectory(String dir) {
        this.dir = dir;
        if (this.peer != null) {
            FileDialogPeer f = (FileDialogPeer)this.peer;
            f.setDirectory(dir);
        }
    }

    public String getFile() {
        return this.file;
    }

    public synchronized void setFile(String file) {
        this.file = file;
        if (this.peer != null) {
            FileDialogPeer f = (FileDialogPeer)this.peer;
            f.setFile(file);
        }
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public synchronized void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
        if (this.peer != null) {
            FileDialogPeer f = (FileDialogPeer)this.peer;
            f.setFilenameFilter(filter);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createFileDialog(this);
        }
        super.addNotify();
    }

    protected String paramString() {
        return "dir=" + this.dir + ",file=" + this.file + ",mode=" + this.mode + "," + super.paramString();
    }
}

