/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    int lineNumber;

    public LineNumberReader(Reader in) {
        super(in, 8192);
    }

    public LineNumberReader(Reader in, int size) {
        super(in, size);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    private static int countLines(char[] buffer, int off, int len) {
        int count = 0;
        int prev = 0;
        for (int i = 0; i < len; ++i) {
            int ch = buffer[i + off];
            if (ch == 10 && prev != 13 || ch == 13) {
                ++count;
            }
            prev = ch;
        }
        return count;
    }

    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos + readLimit > this.limit) {
                    int saveCR = this.pos > 0 && this.buffer[this.pos - 1] == '\r' ? 1 : 0;
                    char[] old_buffer = this.buffer;
                    if (readLimit > this.limit) {
                        this.buffer = new char[saveCR + readLimit];
                    }
                    int copy_start = this.pos - saveCR;
                    this.limit -= copy_start;
                    System.arraycopy(old_buffer, copy_start, this.buffer, 0, this.limit);
                    this.pos = saveCR;
                }
                this.markPos = this.pos;
            }
            finally {
                Object var3_4 = null;
            }
            return;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.markPos < 0) {
                    throw new IOException("mark never set or invalidated");
                }
                if (this.markPos > 0 && this.pos > this.markPos && this.buffer[this.markPos - 1] == '\r' && this.buffer[this.markPos] == '\n') {
                    --this.lineNumber;
                }
                this.lineNumber -= LineNumberReader.countLines(this.buffer, this.markPos, this.pos - this.markPos);
                this.pos = this.markPos;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                char ch;
                this.skipRedundantLF();
                if (this.pos >= this.limit) {
                    int count;
                    if (this.markPos >= 0 && this.limit == this.buffer.length) {
                        this.markPos = -1;
                    }
                    if (this.markPos <= 0) {
                        this.limit = 0;
                        this.pos = 0;
                    }
                    if ((count = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) <= 0) {
                        return -1;
                    }
                    this.limit += count;
                }
                if ((ch = this.buffer[this.pos++]) != '\r') {
                    if (ch != '\n') return ch;
                }
                ++this.lineNumber;
                return 10;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                throw throwable;
            }
        }
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (count <= 0) {
            if (count < 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                int first = this.read();
                if (first < 0) {
                    int n2 = -1;
                    Object var5_6 = null;
                    return n2;
                }
                int start_offset = offset;
                buf[offset++] = (char)first;
                if (this.buffer[this.pos - 1] == '\r' && this.pos < this.limit && this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
                while (true) {
                    int ch;
                    int n3 = --count;
                    --count;
                    if (n3 <= 0 || this.pos >= this.limit) break;
                    if ((ch = this.buffer[this.pos++]) == 13) {
                        ++this.lineNumber;
                        ch = 10;
                        if (this.pos < this.limit && this.buffer[this.pos] == '\n') {
                            ++this.pos;
                        }
                    } else if (ch == 10) {
                        ++this.lineNumber;
                    }
                    buf[offset++] = ch;
                }
                n = offset - start_offset;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
            Object var5_7 = null;
            return n;
        }
    }

    private void skipRedundantLF() throws IOException {
        if (this.pos > 0 && this.buffer[this.pos - 1] == '\r') {
            if (this.pos < this.limit) {
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            } else {
                if (this.pos >= this.buffer.length) {
                    this.markPos = -1;
                }
                this.limit = 0;
                this.pos = 0;
                int ch = this.read();
                if (ch >= 0 && ch != 10) {
                    --this.pos;
                }
            }
        }
    }

    public String readLine() throws IOException {
        char ch;
        int tmpLineNumber = this.lineNumber;
        this.skipRedundantLF();
        String str = super.readLine();
        if (this.pos > this.limit) {
            --this.pos;
        }
        if (this.pos > 0 && ((ch = this.buffer[this.pos - 1]) == '\n' || ch == '\r')) {
            this.lineNumber = tmpLineNumber + 1;
        }
        return str;
    }

    public long skip(long count) throws IOException {
        int ch;
        if (count <= 0L) {
            return 0L;
        }
        long to_do = count;
        while ((ch = this.read()) >= 0) {
            --to_do;
            if (ch == 10 || ch == 13) {
                ++this.lineNumber;
            } else {
                char endch;
                long fence = (long)this.pos + to_do;
                if ((long)this.limit < fence) {
                    fence = this.limit;
                }
                int end = this.pos;
                while ((long)end < fence && (endch = this.buffer[end]) != '\n' && endch != '\r') {
                    ++end;
                }
                to_do -= (long)(end - this.pos);
                this.pos = end;
            }
            if (to_do > 0L) continue;
        }
        return count - to_do;
    }
}

