/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('I');
    private final int value;

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Integer && this.value == ((Integer)obj).value;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        if (result == null) {
            return new Integer(val);
        }
        return result;
    }

    public static Integer getInteger(String nm, Integer def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static String toUnsignedString(int num, int exp) {
        int radix = 1 << (exp & 0x1F);
        int mask = radix - 1;
        char[] buffer = new char[32];
        int i = 32;
        do {
            buffer[--i] = Character.forDigit(num & mask, radix);
        } while ((num >>>= exp & 0x1F) != 0);
        return String.valueOf(buffer, i, 32 - i);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    public static String toString(int i) {
        return String.valueOf(i);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(int num, int radix) {
        boolean isNeg;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[33];
        int i = 33;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                buffer[--i] = Character.forDigit(-(num + radix) % radix, radix);
                num = -(num / radix);
            }
        } else {
            isNeg = false;
        }
        do {
            buffer[--i] = Character.forDigit(num % radix, radix);
        } while ((num /= radix) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return String.valueOf(buffer, i, 33 - i);
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return new Integer(Integer.parseInt(s));
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return new Integer(Integer.parseInt(s, radix));
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static int parseInt(String str, int radix) throws NumberFormatException {
        if (str == null) {
            throw new NumberFormatException();
        }
        int len = str.length();
        if (len == 0 || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        boolean isNeg = false;
        int index = 0;
        if (str.charAt(index) == '-') {
            if (len > 1) {
                isNeg = true;
                ++index;
            } else {
                throw new NumberFormatException();
            }
        }
        return Integer.parseInt(str, index, len, isNeg, radix);
    }

    private static int parseInt(String str, int index, int len, boolean isNeg, int radix) throws NumberFormatException {
        int val = 0;
        int max = Integer.MAX_VALUE / radix;
        if (isNeg && Integer.MAX_VALUE % radix == radix - 1) {
            ++max;
        }
        while (index < len) {
            if (val < 0 || val > max) {
                throw new NumberFormatException();
            }
            int digval = Character.digit(str.charAt(index), radix);
            if (digval < 0) {
                throw new NumberFormatException();
            }
            if (!((val = val * radix + digval) >= 0 || isNeg && val == Integer.MIN_VALUE)) {
                throw new NumberFormatException();
            }
            ++index;
        }
        if (isNeg) {
            return -val;
        }
        return val;
    }

    public static Integer decode(String str) throws NumberFormatException {
        boolean isNeg = false;
        int index = 0;
        int radix = 10;
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException("empty string");
        }
        if (str.charAt(index) == '-') {
            if (len > 1) {
                isNeg = true;
                ++index;
            } else {
                throw new NumberFormatException();
            }
        }
        if (str.charAt(index) == '#') {
            radix = 16;
            ++index;
        } else if (str.charAt(index) == '0') {
            if (len == ++index) {
                return new Integer(0);
            }
            if (str.charAt(index) == 'x' || str.charAt(index) == 'X') {
                radix = 16;
                ++index;
            } else {
                radix = 8;
            }
        }
        if (index >= len) {
            throw new NumberFormatException("empty value");
        }
        return new Integer(Integer.parseInt(str, index, len, isNeg, radix));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int compareTo(Integer i) {
        if (this.value == i.value) {
            return 0;
        }
        if (this.value > i.value) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Integer)o);
    }
}

