/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    transient String[] dateFormats;
    transient String[] timeFormats;

    private String[] formatsForKey(ResourceBundle res, String key) {
        String[] values = new String[formatPrefixes.length];
        for (int i = 0; i < formatPrefixes.length; ++i) {
            values[i] = res.getString(formatPrefixes[i] + key);
        }
        return values;
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale);
        this.ampms = res.getStringArray("ampms");
        this.eras = res.getStringArray("eras");
        this.localPatternChars = res.getString("localPatternChars");
        this.months = res.getStringArray("months");
        this.shortMonths = res.getStringArray("shortMonths");
        this.shortWeekdays = res.getStringArray("shortWeekdays");
        this.weekdays = res.getStringArray("weekdays");
        this.zoneStrings = (String[][])res.getObject("zoneStrings");
        this.dateFormats = this.formatsForKey(res, "DateFormat");
        this.timeFormats = this.formatsForKey(res, "TimeFormat");
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] value) {
        this.ampms = value;
    }

    public void setEras(String[] value) {
        this.eras = value;
    }

    public void setLocalPatternChars(String value) {
        this.localPatternChars = value;
    }

    public void setMonths(String[] value) {
        this.months = value;
    }

    public void setShortMonths(String[] value) {
        this.shortMonths = value;
    }

    public void setShortWeekdays(String[] value) {
        this.shortWeekdays = value;
    }

    public void setWeekdays(String[] value) {
        this.weekdays = value;
    }

    public void setZoneStrings(String[][] value) {
        this.zoneStrings = value;
    }

    private static boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (!(x instanceof Object[]) || !(y instanceof Object[])) {
            return x.equals(y);
        }
        Object[] xa = (Object[])x;
        Object[] ya = (Object[])y;
        if (xa.length != ya.length) {
            return false;
        }
        int i = xa.length;
        while (--i >= 0) {
            if (DateFormatSymbols.equals(xa[i], ya[i])) continue;
            return false;
        }
        return true;
    }

    private static int hashCode(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Object[])) {
            return x.hashCode();
        }
        Object[] xa = (Object[])x;
        int hash = 0;
        for (int i = 0; i < xa.length; ++i) {
            hash = 37 * DateFormatSymbols.hashCode(xa[i]);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols other = (DateFormatSymbols)obj;
        return DateFormatSymbols.equals(this.ampms, other.ampms) && DateFormatSymbols.equals(this.eras, other.eras) && DateFormatSymbols.equals(this.localPatternChars, other.localPatternChars) && DateFormatSymbols.equals(this.months, other.months) && DateFormatSymbols.equals(this.shortMonths, other.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, other.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, other.weekdays) && DateFormatSymbols.equals(this.zoneStrings, other.zoneStrings);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }
}

