/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class PropertyPermission
extends BasicPermission {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("action", PropertyPermission.class$("java.lang.String"))};
    private static final long serialVersionUID = 885438825399942851L;
    private static final int READ = 1;
    private static final int WRITE = 2;
    private transient int actions;
    private static final String[] actionStrings = new String[]{"", "read", "write", "read,write"};

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public PropertyPermission(String name, String actions) {
        super(name);
        this.setActions(actions.toLowerCase());
    }

    private void setActions(String actions) {
        this.actions = 0;
        StringTokenizer actionTokenizer = new StringTokenizer(actions, ",");
        while (actionTokenizer.hasMoreElements()) {
            String anAction = actionTokenizer.nextToken();
            if ("read".equals(anAction)) {
                this.actions |= 1;
                continue;
            }
            if ("write".equals(anAction)) {
                this.actions |= 2;
                continue;
            }
            throw new IllegalArgumentException("illegal action " + anAction);
        }
    }

    public boolean implies(Permission p) {
        if (!(p instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission pp = (PropertyPermission)p;
        if ((pp.actions & ~this.actions) != 0) {
            return false;
        }
        return super.implies(p);
    }

    public String getActions() {
        return actionStrings[this.actions];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission p = (PropertyPermission)obj;
        return this.actions == p.actions && super.equals(p);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.setActions((String)fields.get("actions", null));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("actions", this.getActions());
        s.writeFields();
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(this){
            private /* synthetic */ PropertyPermission this$0;
            Hashtable permissions;
            int allActions;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.permissions = new Hashtable();
                this.allActions = 0;
            }

            public void add(Permission permission) {
                if (this.isReadOnly()) {
                    throw new IllegalStateException("readonly");
                }
                PropertyPermission pp = (PropertyPermission)permission;
                String name = pp.getName();
                if (name.equals("*")) {
                    this.allActions |= pp.actions;
                }
                this.permissions.put(name, pp);
            }

            public boolean implies(Permission permission) {
                if (!(permission instanceof PropertyPermission)) {
                    return false;
                }
                PropertyPermission toImply = (PropertyPermission)permission;
                if ((toImply.actions & ~this.allActions) == 0) {
                    return true;
                }
                String name = toImply.getName();
                if (name.equals("*")) {
                    return false;
                }
                int prefixLength = name.length();
                if (name.endsWith("*")) {
                    prefixLength -= 2;
                }
                PropertyPermission forName;
                while ((forName = (PropertyPermission)this.permissions.get(name)) == null || (toImply.actions & ~forName.actions) != 0) {
                    if ((prefixLength = name.lastIndexOf(46, prefixLength)) < 0) {
                        return false;
                    }
                    name = name.substring(0, prefixLength + 1) + '*';
                }
                return true;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

