/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE_l;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;
import sun.security.util.BigInt;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.a = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.b = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            derValue.data.reset();
            this.a = derValue.data.getOctetString();
            this.b = derValue.data.getInteger().toInt();
            if (derValue.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("iteration count too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("javax.crypto.spec.PBEParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new PBEParameterSpec(this.a, this.b);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.a);
        derOutputStream2.putInteger(new BigInt(BigInteger.valueOf(this.b)));
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = "\n    salt:\n[";
        SunJCE_l sunJCE_l = new SunJCE_l();
        string = string + sunJCE_l.b(this.a);
        string = string + "]";
        return string + "\n    iterationCount:\n" + new BigInt(BigInteger.valueOf(this.b)).toString() + "\n";
    }
}

