/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel model;
    Object pixels;
    int pixeloffset;
    int pixelscan;
    Hashtable properties;
    Vector theConsumers = new Vector();
    boolean animating;
    boolean fullbuffers;

    public MemoryImageSource(int n2, int n3, ColorModel colorModel, byte[] byArray, int n4, int n5) {
        this.initialize(n2, n3, colorModel, byArray, n4, n5, null);
    }

    public MemoryImageSource(int n2, int n3, ColorModel colorModel, byte[] byArray, int n4, int n5, Hashtable hashtable) {
        this.initialize(n2, n3, colorModel, byArray, n4, n5, hashtable);
    }

    public MemoryImageSource(int n2, int n3, ColorModel colorModel, int[] nArray, int n4, int n5) {
        this.initialize(n2, n3, colorModel, nArray, n4, n5, null);
    }

    public MemoryImageSource(int n2, int n3, ColorModel colorModel, int[] nArray, int n4, int n5, Hashtable hashtable) {
        this.initialize(n2, n3, colorModel, nArray, n4, n5, hashtable);
    }

    private void initialize(int n2, int n3, ColorModel colorModel, Object object, int n4, int n5, Hashtable hashtable) {
        this.width = n2;
        this.height = n3;
        this.model = colorModel;
        this.pixels = object;
        this.pixeloffset = n4;
        this.pixelscan = n5;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.properties = hashtable;
    }

    public MemoryImageSource(int n2, int n3, int[] nArray, int n4, int n5) {
        this.initialize(n2, n3, ColorModel.getRGBdefault(), nArray, n4, n5, null);
    }

    public MemoryImageSource(int n2, int n3, int[] nArray, int n4, int n5, Hashtable hashtable) {
        this.initialize(n2, n3, ColorModel.getRGBdefault(), nArray, n4, n5, hashtable);
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        block5: {
            if (this.theConsumers.contains(imageConsumer)) {
                return;
            }
            this.theConsumers.addElement(imageConsumer);
            try {
                this.initConsumer(imageConsumer);
                this.sendPixels(imageConsumer, 0, 0, this.width, this.height);
                if (this.isConsumer(imageConsumer)) {
                    imageConsumer.imageComplete(this.animating ? 2 : 3);
                    if (!this.animating && this.isConsumer(imageConsumer)) {
                        imageConsumer.imageComplete(1);
                        this.removeConsumer(imageConsumer);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.isConsumer(imageConsumer)) break block5;
                imageConsumer.imageComplete(1);
            }
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return this.theConsumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.theConsumers.removeElement(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public synchronized void setAnimated(boolean bl2) {
        this.animating = bl2;
        if (!this.animating) {
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.imageComplete(3);
                if (!this.isConsumer(imageConsumer)) continue;
                imageConsumer.imageComplete(1);
            }
            this.theConsumers.removeAllElements();
        }
    }

    public synchronized void setFullBufferUpdates(boolean bl2) {
        if (this.fullbuffers == bl2) {
            return;
        }
        this.fullbuffers = bl2;
        if (this.animating) {
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                imageConsumer.setHints(bl2 ? 6 : 1);
            }
        }
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    public synchronized void newPixels(int n2, int n3, int n4, int n5) {
        this.newPixels(n2, n3, n4, n5, true);
    }

    public synchronized void newPixels(int n2, int n3, int n4, int n5, boolean bl2) {
        if (this.animating) {
            if (this.fullbuffers) {
                n3 = 0;
                n2 = 0;
                n4 = this.width;
                n5 = this.height;
            } else {
                if (n2 < 0) {
                    n4 += n2;
                    n2 = 0;
                }
                if (n2 + n4 > this.width) {
                    n4 = this.width - n2;
                }
                if (n3 < 0) {
                    n5 += n3;
                    n3 = 0;
                }
                if (n3 + n5 > this.height) {
                    n5 = this.height - n3;
                }
            }
            if (!(n4 > 0 && n5 > 0 || bl2)) {
                return;
            }
            Enumeration enumeration = this.theConsumers.elements();
            while (enumeration.hasMoreElements()) {
                ImageConsumer imageConsumer = (ImageConsumer)enumeration.nextElement();
                if (n4 > 0 && n5 > 0) {
                    this.sendPixels(imageConsumer, n2, n3, n4, n5);
                }
                if (!bl2 || !this.isConsumer(imageConsumer)) continue;
                imageConsumer.imageComplete(2);
            }
        }
    }

    public synchronized void newPixels(byte[] byArray, ColorModel colorModel, int n2, int n3) {
        this.pixels = byArray;
        this.model = colorModel;
        this.pixeloffset = n2;
        this.pixelscan = n3;
        this.newPixels();
    }

    public synchronized void newPixels(int[] nArray, ColorModel colorModel, int n2, int n3) {
        this.pixels = nArray;
        this.model = colorModel;
        this.pixeloffset = n2;
        this.pixelscan = n3;
        this.newPixels();
    }

    private void initConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setProperties(this.properties);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setColorModel(this.model);
        }
        if (this.isConsumer(imageConsumer)) {
            imageConsumer.setHints(this.animating ? (this.fullbuffers ? 6 : 1) : 30);
        }
    }

    private void sendPixels(ImageConsumer imageConsumer, int n2, int n3, int n4, int n5) {
        int n6 = this.pixeloffset + this.pixelscan * n3 + n2;
        if (this.isConsumer(imageConsumer)) {
            if (this.pixels instanceof byte[]) {
                imageConsumer.setPixels(n2, n3, n4, n5, this.model, (byte[])this.pixels, n6, this.pixelscan);
            } else {
                imageConsumer.setPixels(n2, n3, n4, n5, this.model, (int[])this.pixels, n6, this.pixelscan);
            }
        }
    }
}

