/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;

public class ThreadLocal {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static int nextHashCode = 0;
    private static final int HASH_INCREMENT = 1640531527;

    private static synchronized int nextHashCode() {
        int n2 = nextHashCode;
        nextHashCode = n2 + 1640531527;
        return n2;
    }

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            return threadLocalMap.get(this);
        }
        Object object = this.initialValue();
        this.createMap(thread, object);
        return object;
    }

    public void set(Object object) {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, object);
        } else {
            this.createMap(thread, object);
        }
    }

    ThreadLocalMap getMap(Thread thread) {
        return thread.threadLocals;
    }

    void createMap(Thread thread, Object object) {
        thread.threadLocals = new ThreadLocalMap(this, object);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap threadLocalMap) {
        return new ThreadLocalMap(threadLocalMap);
    }

    Object childValue(Object object) {
        throw new UnsupportedOperationException();
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int n2) {
            this.threshold = n2 * 2 / 3;
        }

        private static int nextIndex(int n2, int n3) {
            return n2 + 1 < n3 ? n2 + 1 : 0;
        }

        private static int prevIndex(int n2, int n3) {
            return n2 - 1 >= 0 ? n2 - 1 : n3 - 1;
        }

        ThreadLocalMap(ThreadLocal threadLocal, Object object) {
            this.table = new Entry[16];
            int n2 = threadLocal.threadLocalHashCode & 0xF;
            this.table[n2] = new Entry(threadLocal, object);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap threadLocalMap) {
            Entry[] entryArray = threadLocalMap.table;
            int n2 = entryArray.length;
            this.setThreshold(n2);
            this.table = new Entry[n2];
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                Entry entry = entryArray[n3];
                if (entry != null && (object = entry.get()) != null) {
                    ThreadLocal threadLocal = (ThreadLocal)object;
                    Object object2 = threadLocal.childValue(entry.value);
                    Entry entry2 = new Entry(threadLocal, object2);
                    int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                    while (this.table[n4] != null) {
                        n4 = ThreadLocalMap.nextIndex(n4, n2);
                    }
                    this.table[n4] = entry2;
                    ++this.size;
                }
                ++n3;
            }
        }

        private Object get(ThreadLocal threadLocal) {
            int n2 = threadLocal.threadLocalHashCode & this.table.length - 1;
            Entry entry = this.table[n2];
            if (entry != null && entry.get() == threadLocal) {
                return entry.value;
            }
            return this.getAfterMiss(threadLocal, n2, entry);
        }

        private Object getAfterMiss(ThreadLocal threadLocal, int n2, Entry entry) {
            Object object;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            while (entry != null) {
                object = entry.get();
                if (object == threadLocal) {
                    return entry.value;
                }
                if (object == null) {
                    return this.replaceStaleEntry(threadLocal, null, n2, true);
                }
                n2 = ThreadLocalMap.nextIndex(n2, n3);
                entry = entryArray[n2];
            }
            object = threadLocal.initialValue();
            entryArray[n2] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
            return object;
        }

        private void set(ThreadLocal threadLocal, Object object) {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = threadLocal.threadLocalHashCode & n2 - 1;
            Entry entry = entryArray[n3];
            while (entry != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    entry.value = object;
                    return;
                }
                if (object2 == null) {
                    this.replaceStaleEntry(threadLocal, object, n3, false);
                    return;
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
                entry = entryArray[n3];
            }
            entryArray[n3] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
        }

        private Object replaceStaleEntry(ThreadLocal threadLocal, Object object, int n2, boolean bl2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            int n4 = n2;
            int n5 = ThreadLocalMap.prevIndex(n2, n3);
            while ((entry = entryArray[n5]) != null) {
                if (entry.get() == null) {
                    n4 = n5;
                }
                n5 = ThreadLocalMap.prevIndex(n5, n3);
            }
            int n6 = ThreadLocalMap.nextIndex(n2, n3);
            while ((entry = entryArray[n6]) != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    if (bl2) {
                        object = entry.value;
                    } else {
                        entry.value = object;
                    }
                    entryArray[n6] = entryArray[n2];
                    entryArray[n2] = entry;
                    if (n4 == n2) {
                        n4 = n6;
                    }
                    this.expungeStaleEntry(n4);
                    return object;
                }
                if (object2 == null && n4 == n2) {
                    n4 = n6;
                }
                n6 = ThreadLocalMap.nextIndex(n6, n3);
            }
            if (bl2) {
                object = threadLocal.initialValue();
            }
            entryArray[n2].value = null;
            entryArray[n2] = new Entry(threadLocal, object);
            if (n4 != n2) {
                this.expungeStaleEntry(n4);
            }
            return object;
        }

        private void expungeStaleEntry(int n2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n3 = entryArray.length;
            entryArray[n2].value = null;
            entryArray[n2] = null;
            --this.size;
            int n4 = ThreadLocalMap.nextIndex(n2, n3);
            while ((entry = entryArray[n4]) != null) {
                Object object = entry.get();
                if (object == null) {
                    entry.value = null;
                    entryArray[n4] = null;
                    --this.size;
                } else {
                    ThreadLocal threadLocal = (ThreadLocal)object;
                    int n5 = threadLocal.threadLocalHashCode & n3 - 1;
                    if (n5 != n4) {
                        entryArray[n4] = null;
                        while (entryArray[n5] != null) {
                            n5 = ThreadLocalMap.nextIndex(n5, n3);
                        }
                        entryArray[n5] = entry;
                    }
                }
                n4 = ThreadLocalMap.nextIndex(n4, n3);
            }
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = n2 * 2;
            Entry[] entryArray2 = new Entry[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                Entry entry = entryArray[n5];
                entryArray[n5] = null;
                if (entry != null) {
                    Object object = entry.get();
                    if (object == null) {
                        entry.value = null;
                    } else {
                        ThreadLocal threadLocal = (ThreadLocal)object;
                        int n6 = threadLocal.threadLocalHashCode & n3 - 1;
                        while (entryArray2[n6] != null) {
                            n6 = ThreadLocalMap.nextIndex(n6, n3);
                        }
                        entryArray2[n6] = entry;
                        ++n4;
                    }
                }
                ++n5;
            }
            this.setThreshold(n3);
            this.size = n4;
            this.table = entryArray2;
        }

        private void expungeStaleEntries() {
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Entry entry = entryArray[n3];
                if (entry != null && entry.get() == null) {
                    this.expungeStaleEntry(n3);
                }
                ++n3;
            }
        }

        private static class Entry
        extends WeakReference {
            private Object value;

            private Entry(ThreadLocal threadLocal, Object object) {
                super(threadLocal);
                this.value = object;
            }
        }
    }
}

