/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.x509.X509CertImpl;

public abstract class X509Certificate
extends Certificate
implements X509Extension {
    protected X509Certificate() {
        super("X.509");
    }

    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        if (this.getIssuerDN() == null) {
            throw new IllegalStateException("issuer may not be null");
        }
        if (this.getIssuerDN().getName() == null || this.getIssuerDN().getName().length() == 0) {
            throw new IllegalStateException("issuer may not be empty");
        }
        try {
            return new X500Principal(this.getIssuerDN().getName());
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("unable to instantiate X500Principal");
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public abstract Principal getSubjectDN();

    public X500Principal getSubjectX500Principal() {
        if (this.getSubjectDN() == null) {
            throw new IllegalStateException("subject may not be null");
        }
        try {
            return this.getSubjectDN().getName() == null ? new X500Principal("") : new X500Principal(this.getSubjectDN().getName());
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("unable to instantiate X500Principal");
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract byte[] getTBSCertificate() throws CertificateEncodingException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract boolean[] getIssuerUniqueID();

    public abstract boolean[] getSubjectUniqueID();

    public abstract boolean[] getKeyUsage();

    public List getExtendedKeyUsage() throws CertificateParsingException {
        return X509CertImpl.getExtendedKeyUsage(this);
    }

    public abstract int getBasicConstraints();

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return X509CertImpl.getSubjectAlternativeNames(this);
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return X509CertImpl.getIssuerAlternativeNames(this);
    }
}

