/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.VolatileImage;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.AncestorNotifier;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.Popup;
import javax.swing.RepaintManager;
import javax.swing.SwingGraphics;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public abstract class JComponent
extends Container
implements Serializable {
    private static final String uiClassID = "ComponentUI";
    private static final Hashtable readObjectCallbacks = new Hashtable(1);
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private static boolean suppressDropSupport;
    private static boolean checkedSuppressDropSupport;
    private Dimension preferredSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Float alignmentX;
    private Float alignmentY;
    private AncestorNotifier ancestorNotifier;
    Rectangle _bounds = new Rectangle();
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private Hashtable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private Autoscroller autoscroller;
    private Border border;
    private int flags;
    private TransferHandler transfer;
    private InputVerifier inputVerifier = null;
    private boolean verifyInputWhenFocusTarget = true;
    private transient Rectangle tmpRect;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    private static final String WHEN_IN_FOCUSED_WINDOW_BINDINGS = "_WhenInFocusedWindow";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private static final int IS_DOUBLE_BUFFERED = 0;
    private static final int ANCESTOR_USING_BUFFER = 1;
    private static final int IS_PAINTING_TILE = 2;
    private static final int IS_OPAQUE = 3;
    private static final int KEY_EVENTS_ENABLED = 4;
    private static final int FOCUS_INPUTMAP_CREATED = 5;
    private static final int ANCESTOR_INPUTMAP_CREATED = 6;
    private static final int WIF_INPUTMAP_CREATED = 7;
    private static final int ACTIONMAP_CREATED = 8;
    private static final int CREATED_DOUBLE_BUFFER = 9;
    private static final int CREATED_VOLATILE_DOUBLE_BUFFER = 10;
    private static final int IS_PRINTING = 11;
    private static final int IS_PRINTING_ALL = 12;
    private static final int IS_REPAINTING = 13;
    private static final int WRITE_OBJ_COUNTER_FIRST = 14;
    private static final int RESERVED_1 = 15;
    private static final int RESERVED_2 = 16;
    private static final int RESERVED_3 = 17;
    private static final int RESERVED_4 = 18;
    private static final int RESERVED_5 = 19;
    private static final int RESERVED_6 = 20;
    private static final int WRITE_OBJ_COUNTER_LAST = 21;
    private static final int REQUEST_FOCUS_DISABLED = 22;
    private InputMap focusInputMap;
    private InputMap ancestorInputMap;
    private ComponentInputMap windowInputMap;
    private ActionMap actionMap;
    private static final String defaultLocale = "JComponent.defaultLocale";
    protected AccessibleContext accessibleContext = null;
    private static final String htmlKey = "html";
    private Object htmlView;
    private SwingPropertyChangeSupport changeSupport;
    private Rectangle paintImmediatelyClip = new Rectangle(0, 0, 0, 0);
    static /* synthetic */ Class class$javax$swing$JComponent$KeyboardState;
    static /* synthetic */ Class class$javax$swing$event$AncestorListener;
    static /* synthetic */ Class class$java$beans$VetoableChangeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    static Set getManagingFocusForwardTraversalKeys() {
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return managingFocusForwardTraversalKeys;
    }

    static Set getManagingFocusBackwardTraversalKeys() {
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        }
        return managingFocusBackwardTraversalKeys;
    }

    private static boolean getSuppressDropTarget() {
        if (!checkedSuppressDropSupport) {
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("suppressSwingDropSupport");
                    if (string != null) {
                        return Boolean.valueOf(string);
                    }
                    return Boolean.FALSE;
                }
            });
            suppressDropSupport = bl2;
            checkedSuppressDropSupport = true;
        }
        return suppressDropSupport;
    }

    public JComponent() {
        this.enableEvents(8L);
        this.enableSerialization();
        if (this.isManagingFocus()) {
            this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
            this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        }
        this.setLocale(JComponent.getDefaultLocale());
    }

    public void updateUI() {
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            if (graphics instanceof SwingGraphics) {
                if (!(((SwingGraphics)graphics).subGraphics() instanceof DebugGraphics)) {
                    DebugGraphics debugGraphics = new DebugGraphics(((SwingGraphics)graphics).subGraphics(), this);
                    graphics2 = SwingGraphics.createSwingGraphics(debugGraphics);
                    ((Graphics)debugGraphics).dispose();
                }
            } else {
                graphics2 = new DebugGraphics(graphics, this);
            }
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            try {
                this.ui.update(graphics2, this);
                Object var4_3 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2 = null;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n2 = this.getComponentCount() - 1;
                if (n2 < 0) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 22] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
                    Object var20_5 = null;
                    if (graphics2 == null) return;
                    graphics2.dispose();
                    return;
                }
                graphics2 = SwingGraphics.createSwingGraphics(graphics);
                if (this.paintingChild != null && this.paintingChild instanceof JComponent && ((JComponent)this.paintingChild).isOpaque()) {
                    while (n2 >= 0 && this.getComponent(n2) != this.paintingChild) {
                        --n2;
                    }
                }
                if (this.tmpRect == null) {
                    this.tmpRect = new Rectangle();
                }
                boolean bl2 = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
                Rectangle rectangle = null;
                if (bl2 && (rectangle = graphics2.getClipBounds()) == null) {
                    rectangle = new Rectangle(0, 0, this._bounds.width, this._bounds.height);
                }
                boolean bl3 = this.getFlag(11);
                while (true) {
                    block29: {
                        Object var17_20;
                        int n3;
                        Rectangle rectangle2;
                        boolean bl4;
                        Component component;
                        block30: {
                            if (n2 < 0) {
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 8, 26] lbl27 : MonitorExitStatement: MONITOREXIT : var4_3
                                break;
                            }
                            component = this.getComponent(n2);
                            if (component == null || !JComponent.isLightweightComponent(component) || !component.isVisible()) break block29;
                            bl4 = component instanceof JComponent;
                            if (bl4) {
                                rectangle2 = this.tmpRect;
                                ((JComponent)component).getBounds(rectangle2);
                            } else {
                                rectangle2 = component.getBounds();
                            }
                            boolean bl5 = graphics.hitClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            if (!bl5) break block29;
                            if (!bl2 || n2 <= 0) break block30;
                            int n4 = rectangle2.x;
                            n3 = rectangle2.y;
                            int n5 = rectangle2.width;
                            int n6 = rectangle2.height;
                            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                            if (this.rectangleIsObscuredBySibling(n2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height)) break block29;
                            rectangle2.x = n4;
                            rectangle2.y = n3;
                            rectangle2.width = n5;
                            rectangle2.height = n6;
                        }
                        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics3.setColor(component.getForeground());
                        graphics3.setFont(component.getFont());
                        n3 = 0;
                        try {
                            block28: {
                                block31: {
                                    if (!bl4) break block31;
                                    if (this.getFlag(1)) {
                                        ((JComponent)component).setFlag(1, true);
                                        n3 = 1;
                                    }
                                    if (this.getFlag(2)) {
                                        ((JComponent)component).setFlag(2, true);
                                        n3 = 1;
                                    }
                                    if (!bl3) {
                                        ((JComponent)component).paint(graphics3);
                                        break block28;
                                    } else if (!this.getFlag(12)) {
                                        component.print(graphics3);
                                        break block28;
                                    } else {
                                        component.printAll(graphics3);
                                    }
                                    break block28;
                                }
                                if (!bl3) {
                                    component.paint(graphics3);
                                } else if (!this.getFlag(12)) {
                                    component.print(graphics3);
                                } else {
                                    component.printAll(graphics3);
                                }
                            }
                            var17_20 = null;
                            graphics3.dispose();
                            if (n3 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                        }
                        catch (Throwable throwable) {
                            var17_20 = null;
                            graphics3.dispose();
                            if (n3 == 0) throw throwable;
                            ((JComponent)component).setFlag(1, false);
                            ((JComponent)component).setFlag(2, false);
                            throw throwable;
                        }
                    }
                    --n2;
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_7 = null;
            if (graphics2 == null) throw throwable;
            graphics2.dispose();
            throw throwable;
        }
        Object var20_6 = null;
        if (graphics2 == null) return;
        graphics2.dispose();
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        Graphics graphics2 = this.getComponentGraphics(graphics);
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        try {
            boolean bl4;
            int n2;
            int n3;
            int n4;
            int n5;
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            Rectangle rectangle = graphics3.getClipBounds();
            if (rectangle == null) {
                n5 = 0;
                n4 = 0;
                n3 = this._bounds.width;
                n2 = this._bounds.height;
            } else {
                n4 = rectangle.x;
                n5 = rectangle.y;
                n3 = rectangle.width;
                n2 = rectangle.height;
            }
            if (n3 > this.getWidth()) {
                n3 = this.getWidth();
            }
            if (n2 > this.getHeight()) {
                n2 = this.getHeight();
            }
            if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                this.adjustPaintFlags();
                bl2 = true;
            }
            if (!(bl4 = this.getFlag(11)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(1) && this.isDoubleBuffered()) {
                bl3 = this.paintDoubleBuffered(this, this, graphics3, n4, n5, n3, n2);
            }
            if (!bl3) {
                if (rectangle == null) {
                    graphics3.setClip(n4, n5, n3, n2);
                }
                if (!this.rectangleIsObscured(n4, n5, n3, n2)) {
                    if (!bl4) {
                        this.paintComponent(graphics3);
                        this.paintBorder(graphics3);
                    } else {
                        this.printComponent(graphics3);
                        this.printBorder(graphics3);
                    }
                }
                if (!bl4) {
                    this.paintChildren(graphics3);
                } else {
                    this.printChildren(graphics3);
                }
            }
            Object var16_13 = null;
            graphics3.dispose();
            if (bl2) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            graphics3.dispose();
            if (bl2) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
            throw throwable;
        }
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JComponent) {
                jComponent = (JComponent)container;
                if (jComponent.getFlag(1)) {
                    this.setFlag(1, true);
                }
                if (jComponent.getFlag(2)) {
                    this.setFlag(2, true);
                }
                if (jComponent.getFlag(11)) {
                    this.setFlag(11, true);
                }
                if (!jComponent.getFlag(12)) break;
                this.setFlag(12, true);
                break;
            }
            container = container.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAll(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.print(graphics);
            Object var3_2 = null;
            this.setFlag(12, false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setFlag(12, false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        this.setFlag(11, true);
        try {
            this.paint(graphics);
            Object var3_2 = null;
            this.setFlag(11, false);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setFlag(11, false);
            throw throwable;
        }
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    public boolean isPaintingTile() {
        return this.getFlag(2);
    }

    public boolean isManagingFocus() {
        return false;
    }

    private void registerNextFocusableComponent() {
        this.registerNextFocusableComponent(this.getNextFocusableComponent());
    }

    private void registerNextFocusableComponent(Component component) {
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (!(focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy)) {
            focusTraversalPolicy = new LegacyGlueFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).setNextFocusableComponent(this, component);
    }

    private void deregisterNextFocusableComponent() {
        Component component = this.getNextFocusableComponent();
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy) {
            ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).unsetNextFocusableComponent(this, component);
        }
    }

    public void setNextFocusableComponent(Component component) {
        boolean bl2 = this.isDisplayable();
        if (bl2) {
            this.deregisterNextFocusableComponent();
        }
        this.putClientProperty(NEXT_FOCUS, component);
        if (bl2) {
            this.registerNextFocusableComponent(component);
        }
    }

    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public void setRequestFocusEnabled(boolean bl2) {
        this.setFlag(22, !bl2);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(22);
    }

    private boolean runInputVerifier() {
        if (!this.getVerifyInputWhenFocusTarget()) {
            return true;
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == null || !(component instanceof JComponent)) {
            return true;
        }
        JComponent jComponent = (JComponent)component;
        InputVerifier inputVerifier = jComponent.getInputVerifier();
        if (inputVerifier == null) {
            return true;
        }
        return inputVerifier.shouldYieldFocus(jComponent);
    }

    public void requestFocus() {
        if (this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    public boolean requestFocus(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocus(bl2) : false;
    }

    public boolean requestFocusInWindow() {
        return this.runInputVerifier() ? super.requestFocusInWindow() : false;
    }

    protected boolean requestFocusInWindow(boolean bl2) {
        return this.runInputVerifier() ? super.requestFocusInWindow(bl2) : false;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public void setVerifyInputWhenFocusTarget(boolean bl2) {
        boolean bl3 = this.verifyInputWhenFocusTarget;
        this.verifyInputWhenFocusTarget = bl2;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl3, bl2);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension;
        this.firePropertyChange("maximumSize", dimension2, dimension);
    }

    public Dimension getMaximumSize() {
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    public boolean isMinimumSizeSet() {
        return this.minimumSize != null;
    }

    public boolean isPreferredSizeSet() {
        return this.preferredSize != null;
    }

    public boolean isMaximumSizeSet() {
        return this.maximumSize != null;
    }

    public boolean contains(int n2, int n3) {
        return this.ui != null ? this.ui.contains(this, n2, n3) : super.contains(n2, n3);
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return ((AbstractBorder)this.border).getBorderInsets(this, insets);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    public float getAlignmentY() {
        return this.alignmentY != null ? this.alignmentY.floatValue() : super.getAlignmentY();
    }

    public void setAlignmentY(float f2) {
        this.alignmentY = new Float(f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2));
    }

    public float getAlignmentX() {
        return this.alignmentX != null ? this.alignmentX.floatValue() : super.getAlignmentX();
    }

    public void setAlignmentX(float f2) {
        this.alignmentX = new Float(f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2));
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public Graphics getGraphics() {
        if (this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    public void setDebugGraphicsOptions(int n2) {
        DebugGraphics.setDebugOptions(this, n2);
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n2) {
        InputMap inputMap = this.getInputMap(n2, true);
        if (inputMap != null) {
            ActionMap actionMap = this.getActionMap(true);
            ActionStandin actionStandin = new ActionStandin(actionListener, string);
            inputMap.put(keyStroke, actionStandin);
            if (actionMap != null) {
                actionMap.put(actionStandin, actionStandin);
            }
        }
    }

    private void registerWithKeyboardManager(boolean bl2) {
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap(2, false);
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (inputMap != null) {
            keyStrokeArray = inputMap.allKeys();
            if (keyStrokeArray != null) {
                int n2 = keyStrokeArray.length - 1;
                while (n2 >= 0) {
                    if (!bl2 || hashtable == null || hashtable.get(keyStrokeArray[n2]) == null) {
                        this.registerWithKeyboardManager(keyStrokeArray[n2]);
                    }
                    if (hashtable != null) {
                        hashtable.remove(keyStrokeArray[n2]);
                    }
                    --n2;
                }
            }
        } else {
            keyStrokeArray = null;
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
            hashtable.clear();
        }
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable(keyStrokeArray.length);
                this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, hashtable);
            }
            int n3 = keyStrokeArray.length - 1;
            while (n3 >= 0) {
                hashtable.put(keyStrokeArray[n3], keyStrokeArray[n3]);
                --n3;
            }
        } else {
            this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
        }
    }

    private void unregisterWithKeyboardManager() {
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
        }
        this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
    }

    void componentInputMapChanged(ComponentInputMap componentInputMap) {
        InputMap inputMap = this.getInputMap(2, false);
        while (inputMap != componentInputMap && inputMap != null) {
            inputMap = (ComponentInputMap)inputMap.getParent();
        }
        if (inputMap != null) {
            this.registerWithKeyboardManager(false);
        }
    }

    private void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    private void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n2) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n2);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        int n2 = 0;
        while (n2 < 3) {
            InputMap inputMap = this.getInputMap(n2, false);
            if (inputMap != null) {
                Object object = inputMap.get(keyStroke);
                if (actionMap != null && object != null) {
                    actionMap.remove(object);
                }
                inputMap.remove(keyStroke);
            }
            ++n2;
        }
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        KeyStroke[] keyStrokeArray;
        int[] nArray = new int[3];
        KeyStroke[][] keyStrokeArrayArray = new KeyStroke[3][];
        int n2 = 0;
        while (n2 < 3) {
            keyStrokeArray = this.getInputMap(n2, false);
            keyStrokeArrayArray[n2] = keyStrokeArray != null ? keyStrokeArray.allKeys() : null;
            nArray[n2] = keyStrokeArrayArray[n2] != null ? keyStrokeArrayArray[n2].length : 0;
            ++n2;
        }
        keyStrokeArray = new KeyStroke[nArray[0] + nArray[1] + nArray[2]];
        int n3 = 0;
        int n4 = 0;
        while (n3 < 3) {
            if (nArray[n3] > 0) {
                System.arraycopy(keyStrokeArrayArray[n3], 0, keyStrokeArray, n4, nArray[n3]);
                n4 += nArray[n3];
            }
            ++n3;
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        int n2 = 0;
        while (n2 < 3) {
            InputMap inputMap = this.getInputMap(n2, false);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < 3) {
            Object object;
            InputMap inputMap = this.getInputMap(n2, false);
            if (inputMap != null && (object = inputMap.get(keyStroke)) != null) {
                Action action = actionMap.get(object);
                if (action instanceof ActionStandin) {
                    return ((ActionStandin)action).actionListener;
                }
                return action;
            }
            ++n2;
        }
        return null;
    }

    public void resetKeyboardActions() {
        Serializable serializable;
        int n2 = 0;
        while (n2 < 3) {
            serializable = this.getInputMap(n2, false);
            if (serializable != null) {
                ((InputMap)serializable).clear();
            }
            ++n2;
        }
        serializable = this.getActionMap(false);
        if (serializable != null) {
            ((ActionMap)serializable).clear();
        }
    }

    public final void setInputMap(int n2, InputMap inputMap) {
        switch (n2) {
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMaps must be of type ComponentInputMap");
                }
                this.windowInputMap = (ComponentInputMap)inputMap;
                this.setFlag(7, true);
                this.registerWithKeyboardManager(false);
                break;
            }
            case 1: {
                this.ancestorInputMap = inputMap;
                this.setFlag(6, true);
                break;
            }
            case 0: {
                this.focusInputMap = inputMap;
                this.setFlag(5, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
    }

    public final InputMap getInputMap(int n2) {
        return this.getInputMap(n2, true);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0, true);
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
        this.setFlag(8, true);
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    final InputMap getInputMap(int n2, boolean bl2) {
        switch (n2) {
            case 0: {
                if (this.getFlag(5)) {
                    return this.focusInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 1: {
                if (this.getFlag(6)) {
                    return this.ancestorInputMap;
                }
                if (!bl2) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n2, inputMap);
                return inputMap;
            }
            case 2: {
                if (this.getFlag(7)) {
                    return this.windowInputMap;
                }
                if (!bl2) break;
                ComponentInputMap componentInputMap = new ComponentInputMap(this);
                this.setInputMap(n2, componentInputMap);
                return componentInputMap;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
        return null;
    }

    final ActionMap getActionMap(boolean bl2) {
        if (this.getFlag(8)) {
            return this.actionMap;
        }
        if (bl2) {
            ActionMap actionMap = new ActionMap();
            this.setActionMap(actionMap);
            return actionMap;
        }
        return null;
    }

    public boolean requestDefaultFocus() {
        Container container;
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return false;
        }
        Component component = container.getFocusTraversalPolicy().getDefaultComponent(container);
        if (component != null) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    public void setVisible(boolean bl2) {
        if (bl2 != this.isVisible()) {
            super.setVisible(bl2);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
        }
    }

    public void setEnabled(boolean bl2) {
        boolean bl3 = this.isEnabled();
        super.setEnabled(bl2);
        this.firePropertyChange("enabled", bl3, bl2);
        if (bl2 != bl3) {
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public static Locale getDefaultLocale() {
        Locale locale = (Locale)SwingUtilities.appContextGet(defaultLocale);
        if (locale == null) {
            locale = Locale.getDefault();
            JComponent.setDefaultLocale(locale);
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        SwingUtilities.appContextPut(defaultLocale, locale);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        boolean bl2 = KeyboardState.shouldProcess(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl2 && this.processKeyBindings(keyEvent, keyEvent.getID() == 401)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        InputMap inputMap = this.getInputMap(n2, false);
        ActionMap actionMap = this.getActionMap(false);
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl2) {
        if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
            return false;
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl2);
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl2)) {
            return true;
        }
        Container container = this;
        while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
            if (container instanceof JComponent && container.processKeyBinding(keyStroke, keyEvent, 1, bl2)) {
                return true;
            }
            if (container instanceof JInternalFrame && JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2)) {
                return true;
            }
            container = container.getParent();
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl2);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl2) {
        while (true) {
            if (KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl2, container)) {
                return true;
            }
            if (!(container instanceof Popup.HeavyWeightWindow)) break;
            container = ((Window)container).getOwner();
        }
        return false;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            if (string2 == null) {
                toolTipManager.registerComponent(this);
            }
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n2 = this.getX();
        int n3 = this.getY();
        Container container = this.getParent();
        while (container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane)) {
            Rectangle rectangle2 = container.getBounds();
            n2 += rectangle2.x;
            n3 += rectangle2.y;
            container = container.getParent();
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n2;
            rectangle.y += n3;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n2;
            rectangle.y -= n3;
        }
    }

    public void setAutoscrolls(boolean bl2) {
        if (bl2) {
            if (this.autoscroller == null) {
                this.autoscroller = new Autoscroller(this);
            }
        } else if (this.autoscroller != null) {
            this.autoscroller.dispose();
            this.autoscroller = null;
        }
    }

    public boolean getAutoscrolls() {
        return this.autoscroller != null;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        DropTarget dropTarget;
        TransferHandler transferHandler2 = this.transfer;
        this.transfer = transferHandler;
        if (!JComponent.getSuppressDropTarget() && ((dropTarget = this.getDropTarget()) == null || dropTarget instanceof UIResource)) {
            if (transferHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new TransferHandler.SwingDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", transferHandler2, this.transfer);
    }

    public TransferHandler getTransferHandler() {
        return this.transfer;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl2 = true;
        if (this.autoscroller != null && mouseEvent.getID() == 506) {
            bl2 = !this.autoscroller.timer.isRunning();
            this.autoscroller.mouseDragged(mouseEvent);
        }
        if (bl2) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    void setCreatedDoubleBuffer(boolean bl2, boolean bl3) {
        this.setFlag(bl2 ? 10 : 9, bl3);
    }

    boolean getCreatedDoubleBuffer(boolean bl2) {
        return this.getFlag(bl2 ? 10 : 9);
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        if (this.clientProperties == null) {
            return null;
        }
        if (object == htmlKey) {
            return this.htmlView;
        }
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        Object object3 = this.getClientProperties().get(object);
        if (object2 != null) {
            if (object == htmlKey) {
                this.htmlView = object2;
            } else {
                this.getClientProperties().put(object, object2);
                this.firePropertyChange(object.toString(), object3, object2);
            }
        } else if (object3 != null) {
            this.getClientProperties().remove(object);
            this.firePropertyChange(object.toString(), object3, object2);
        } else if (object == htmlKey) {
            this.htmlView = null;
        }
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        if (this._bounds.x == n2 && this._bounds.y == n3 && this._bounds.width == n4 && this._bounds.height == n5) {
            return;
        }
        if (this.isShowing()) {
            if (this._bounds.x + this._bounds.width > n2 && this._bounds.y + this._bounds.height > n3 && this._bounds.x < n2 + n4 && this._bounds.y < n3 + n5) {
                Rectangle[] rectangleArray = SwingUtilities.computeDifference(this.getBounds(), new Rectangle(n2, n3, n4, n5));
                Container container = this.getParent();
                int n6 = 0;
                int n7 = rectangleArray.length;
                while (n6 < n7) {
                    container.repaint(rectangleArray[n6].x, rectangleArray[n6].y, rectangleArray[n6].width, rectangleArray[n6].height);
                    ++n6;
                }
            } else {
                Container container = this.getParent();
                if (container != null) {
                    container.repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                }
            }
        }
        this._bounds.setBounds(n2, n3, n4, n5);
        super.reshape(n2, n3, n4, n5);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getHeight() {
        return this._bounds.height;
    }

    public boolean isOpaque() {
        return this.getFlag(3);
    }

    public void setOpaque(boolean bl2) {
        boolean bl3 = this.getFlag(3);
        this.setFlag(3, bl2);
        this.firePropertyChange("opaque", bl3, bl2);
    }

    boolean rectangleIsObscured(int n2, int n3, int n4, int n5) {
        int n6 = this.getComponentCount();
        int n7 = 0;
        while (n7 < n6) {
            Component component = this.getComponent(n7);
            Rectangle rectangle = component instanceof JComponent ? ((JComponent)component)._bounds : component.getBounds();
            if (n2 >= rectangle.x && n2 + n4 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 + n5 <= rectangle.y + rectangle.height && component.isVisible()) {
                if (component instanceof JComponent) {
                    return ((JComponent)component).isOpaque();
                }
                return false;
            }
            ++n7;
        }
        return false;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null && by != by2) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c2, char c3) {
        if (this.changeSupport != null && c2 != c3) {
            this.changeSupport.firePropertyChange(string, new Character(c2), new Character(c3));
        }
    }

    public void firePropertyChange(String string, short s2, short s3) {
        if (this.changeSupport != null && s2 != s3) {
            this.changeSupport.firePropertyChange(string, new Short(s2), new Short(s3));
        }
    }

    public void firePropertyChange(String string, int n2, int n3) {
        if (this.changeSupport != null && n2 != n3) {
            this.changeSupport.firePropertyChange(string, new Integer(n2), new Integer(n3));
        }
    }

    public void firePropertyChange(String string, long l2, long l3) {
        if (this.changeSupport != null && l2 != l3) {
            this.changeSupport.firePropertyChange(string, new Long(l2), new Long(l3));
        }
    }

    public void firePropertyChange(String string, float f2, float f3) {
        if (this.changeSupport != null && f2 != f3) {
            this.changeSupport.firePropertyChange(string, new Float(f2), new Float(f3));
        }
    }

    public void firePropertyChange(String string, double d2, double d3) {
        if (this.changeSupport != null && d2 != d3) {
            this.changeSupport.firePropertyChange(string, new Double(d2), new Double(d3));
        }
    }

    public void firePropertyChange(String string, boolean bl2, boolean bl3) {
        if (this.changeSupport != null && bl2 != bl3) {
            this.changeSupport.firePropertyChange(string, new Boolean(bl2), new Boolean(bl3));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public Container getTopLevelAncestor() {
        Container container = this;
        while (container != null) {
            if (container instanceof Window || container instanceof Applet) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            this.ancestorNotifier = new AncestorNotifier(this);
        }
        this.ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            return;
        }
        this.ancestorNotifier.removeAncestorListener(ancestorListener);
        if (this.ancestorNotifier.listenerList.getListenerList().length == 0) {
            this.ancestorNotifier.removeAllListeners();
            this.ancestorNotifier = null;
        }
    }

    public AncestorListener[] getAncestorListeners() {
        if (this.ancestorNotifier == null) {
            return new AncestorListener[0];
        }
        return this.ancestorNotifier.getAncestorListeners();
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener[] eventListenerArray = clazz == (class$javax$swing$event$AncestorListener == null ? (class$javax$swing$event$AncestorListener = JComponent.class$("javax.swing.event.AncestorListener")) : class$javax$swing$event$AncestorListener) ? this.getAncestorListeners() : (clazz == (class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = JComponent.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener) ? this.getVetoableChangeListeners() : (clazz == (class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = JComponent.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener) ? this.getPropertyChangeListeners() : this.listenerList.getListeners(clazz)));
        if (eventListenerArray.length == 0) {
            return super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        this.registerWithKeyboardManager(false);
        this.registerNextFocusableComponent();
    }

    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        this.unregisterWithKeyboardManager();
        this.deregisterNextFocusableComponent();
        if (this.getCreatedDoubleBuffer(false)) {
            RepaintManager.currentManager(this).resetDoubleBuffer();
            this.setCreatedDoubleBuffer(false, false);
        }
        if (this.getCreatedDoubleBuffer(true)) {
            RepaintManager.currentManager(this).resetVolatileDoubleBuffer();
            this.setCreatedDoubleBuffer(true, false);
        }
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n2, n3, n4, n5);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void paintImmediately(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 /* !! */  = this;
        if (this.isShowing()) ** GOTO lbl10
        return;
        while ((var6_6 = var5_5 /* !! */ .getParent()) != null) {
            var7_7 = var5_5 /* !! */  instanceof JComponent != false ? var5_5 /* !! */ ._bounds : var5_5 /* !! */ .getBounds();
            var1_1 += var7_7.x;
            var2_2 += var7_7.y;
            var5_5 /* !! */  = var6_6;
            if (!(var5_5 /* !! */  instanceof JComponent)) break;
lbl10:
            // 2 sources

            if (!var5_5 /* !! */ .isOpaque()) continue;
        }
        if (var5_5 /* !! */  instanceof JComponent) {
            var5_5 /* !! */ ._paintImmediately(var1_1, var2_2, var3_3, var4_4);
        } else {
            var5_5 /* !! */ .repaint(var1_1, var2_2, var3_3, var4_4);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean alwaysOnTop() {
        return false;
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _paintImmediately(int n2, int n3, int n4, int n5) {
        Throwable throwable3;
        Vector vector;
        JComponent jComponent;
        block30: {
            int n6;
            block31: {
                int n7;
                Object object;
                int n8 = 0;
                int n9 = 0;
                boolean bl2 = false;
                Container container = null;
                jComponent = this;
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                vector = new Vector(7);
                int n10 = -1;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                this.paintImmediatelyClip.x = n2;
                this.paintImmediatelyClip.y = n3;
                this.paintImmediatelyClip.width = n4;
                this.paintImmediatelyClip.height = n5;
                boolean bl3 = this.alwaysOnTop() && this.isOpaque();
                Container container2 = this;
                JComponent jComponent2 = null;
                while (true) {
                    if (container2 == null || container2 instanceof Window || container2 instanceof Applet) {
                        if (container2 == null) return;
                        if (container2.getPeer() != null) break;
                        return;
                    }
                    vector.addElement(container2);
                    if (!bl3 && container2 instanceof JComponent && !((JComponent)container2).isOptimizedDrawingEnabled()) {
                        if (container2 != this) {
                            object = container2.getComponents();
                            n7 = 0;
                            while (n7 < ((Component[])object).length && object[n7] != jComponent2) {
                                ++n7;
                            }
                            if (((JComponent)container2).rectangleIsObscuredBySibling(n7, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height)) {
                                return;
                            }
                        }
                        jComponent = container2;
                        n10 = n11;
                        n9 = 0;
                        n8 = 0;
                        bl2 = false;
                    }
                    ++n11;
                    if (repaintManager.isDoubleBufferingEnabled() && container2 instanceof JComponent && ((JComponent)container2).isDoubleBuffered()) {
                        bl2 = true;
                        container = container2;
                    }
                    if (!bl3) {
                        Rectangle rectangle = container2 instanceof JComponent ? ((JComponent)container2)._bounds : container2.getBounds();
                        n13 = rectangle.width;
                        n12 = rectangle.height;
                        SwingUtilities.computeIntersection(n15, n14, n13, n12, this.paintImmediatelyClip);
                        this.paintImmediatelyClip.x += rectangle.x;
                        this.paintImmediatelyClip.y += rectangle.y;
                        n8 += rectangle.x;
                        n9 += rectangle.y;
                    }
                    jComponent2 = container2;
                    container2 = container2.getParent();
                }
                if (this.paintImmediatelyClip.width <= 0) return;
                if (this.paintImmediatelyClip.height <= 0) {
                    return;
                }
                jComponent.setFlag(13, true);
                this.paintImmediatelyClip.x -= n8;
                this.paintImmediatelyClip.y -= n9;
                if (jComponent != this) {
                    n7 = n10;
                    while (n7 > 0) {
                        object = (Component)vector.elementAt(n7);
                        if (object instanceof JComponent) {
                            ((JComponent)object).setPaintingChild((Component)vector.elementAt(n7 - 1));
                        }
                        --n7;
                    }
                }
                try {
                    Graphics graphics;
                    try {
                        object = jComponent.getGraphics();
                        graphics = SwingGraphics.createSwingGraphics((Graphics)object);
                        object.dispose();
                    }
                    catch (NullPointerException nullPointerException) {
                        graphics = null;
                        nullPointerException.printStackTrace();
                    }
                    if (graphics == null) {
                        System.err.println("In paintImmediately null graphics");
                        Object var28_27 = null;
                        if (jComponent != this) {
                            int n16 = n10;
                            while (n16 > 0) {
                                Component component = (Component)vector.elementAt(n16);
                                if (component instanceof JComponent) {
                                    ((JComponent)component).setPaintingChild(null);
                                }
                                --n16;
                            }
                        }
                        vector.removeAllElements();
                        jComponent.setFlag(13, false);
                        return;
                    }
                    try {
                        boolean bl4 = false;
                        if (bl2) {
                            bl4 = this.paintDoubleBuffered(jComponent, container, graphics, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                        }
                        if (!bl4) {
                            graphics.setClip(this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                            jComponent.paint(graphics);
                        }
                        Object var26_36 = null;
                        graphics.dispose();
                    }
                    catch (Throwable throwable2) {
                        Object var26_37 = null;
                        graphics.dispose();
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    Object var28_29 = null;
                    if (jComponent == this) break block30;
                    n6 = n10;
                    break block31;
                }
                Object var28_28 = null;
                if (jComponent != this) {
                    int n17 = n10;
                    while (n17 > 0) {
                        Component component = (Component)vector.elementAt(n17);
                        if (component instanceof JComponent) {
                            ((JComponent)component).setPaintingChild(null);
                        }
                        --n17;
                    }
                }
                vector.removeAllElements();
                jComponent.setFlag(13, false);
                return;
            }
            while (n6 > 0) {
                Component component = (Component)vector.elementAt(n6);
                if (component instanceof JComponent) {
                    ((JComponent)component).setPaintingChild(null);
                }
                --n6;
            }
        }
        vector.removeAllElements();
        jComponent.setFlag(13, false);
        throw throwable3;
    }

    private boolean paintDoubleBuffered(JComponent jComponent, Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        boolean bl2 = false;
        Image image = null;
        if (repaintManager.useVolatileDoubleBuffer() && (image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            VolatileImage volatileImage = (VolatileImage)image;
            int n6 = 0;
            while (!bl2 && n6 < 1) {
                if (volatileImage.validate(jComponent.getGraphicsConfiguration()) == 2) {
                    repaintManager.resetVolatileDoubleBuffer();
                    image = repaintManager.getVolatileOffscreenBuffer(component, n4, n5);
                    volatileImage = (VolatileImage)image;
                }
                this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
                bl2 = !volatileImage.contentsLost();
                ++n6;
            }
        }
        if (!bl2 && (image = repaintManager.getOffscreenBuffer(component, n4, n5)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            this.paintWithOffscreenBuffer(jComponent, graphics, n2, n3, n4, n5, image);
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWithOffscreenBuffer(JComponent jComponent, Graphics graphics, int n2, int n3, int n4, int n5, Image image) {
        Graphics graphics2 = image.getGraphics();
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        graphics2.dispose();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        if (n6 > n4) {
            n6 = n4;
        }
        if (n7 > n5) {
            n7 = n5;
        }
        try {
            jComponent.setFlag(1, true);
            jComponent.setFlag(2, true);
            int n8 = n2;
            int n9 = n2 + n4;
            while (n8 < n9) {
                int n10 = n3;
                int n11 = n3 + n5;
                while (n10 < n11) {
                    if (n10 + n7 >= n11 && n8 + n6 >= n9) {
                        jComponent.setFlag(2, false);
                    }
                    graphics3.translate(-n8, -n10);
                    graphics3.setClip(n8, n10, n6, n7);
                    if (this.getFlag(13)) {
                        jComponent.paint(graphics3);
                    } else {
                        if (!jComponent.rectangleIsObscured(n2, n3, n6, n7)) {
                            jComponent.paintComponent(graphics3);
                            jComponent.paintBorder(graphics3);
                        }
                        jComponent.paintChildren(graphics3);
                    }
                    graphics.setClip(n8, n10, n6, n7);
                    graphics.drawImage(image, n8, n10, jComponent);
                    graphics3.translate(n8, n10);
                    n10 += n7;
                }
                n8 += n6;
            }
            Object var17_16 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
            throw throwable;
        }
    }

    boolean rectangleIsObscuredBySibling(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 - 1;
        while (n7 >= 0) {
            block2: {
                Rectangle rectangle;
                block4: {
                    Component component;
                    block3: {
                        component = this.getComponent(n7);
                        if (!component.isVisible()) break block2;
                        if (!(component instanceof JComponent)) break block3;
                        if (!((JComponent)component).isOpaque()) break block2;
                        rectangle = ((JComponent)component).getBounds(this.tmpRect);
                        break block4;
                    }
                    rectangle = component.getBounds();
                }
                if (n3 >= rectangle.x && n3 + n5 <= rectangle.x + rectangle.width && n4 >= rectangle.y && n4 + n6 <= rectangle.y + rectangle.height) {
                    return true;
                }
            }
            --n7;
        }
        return false;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    private void setFlag(int n2, boolean bl2) {
        this.flags = bl2 ? (this.flags |= 1 << n2) : (this.flags &= ~(1 << n2));
    }

    private boolean getFlag(int n2) {
        int n3 = 1 << n2;
        return (this.flags & n3) == n3;
    }

    static void setWriteObjCounter(JComponent jComponent, byte by) {
        jComponent.flags = jComponent.flags & 0xFFC03FFF | by << 14;
    }

    static byte getWriteObjCounter(JComponent jComponent) {
        return (byte)(jComponent.flags >> 14 & 0xFF);
    }

    public void setDoubleBuffered(boolean bl2) {
        this.setFlag(0, bl2);
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(0);
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    void compWriteObjectNotify() {
        byte by = JComponent.getWriteObjCounter(this);
        JComponent.setWriteObjCounter(this, (byte)(by + 1));
        if (by != 0) {
            return;
        }
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        if (this.getToolTipText() != null || this instanceof JTableHeader) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    void enableSerialization() {
        this.addFocusListener(new EnableSerializationFocusListener());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = (ReadObjectCallback)readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        readObjectCallback.registerComponent(this);
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        JComponent.setWriteObjCounter(this, (byte)0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.preferredSize != null ? this.preferredSize.toString() : "";
        String string2 = this.minimumSize != null ? this.minimumSize.toString() : "";
        String string3 = this.maximumSize != null ? this.maximumSize.toString() : "";
        String string4 = this.border != null ? this.border.toString() : "";
        return super.paramString() + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string4 + ",flags=" + this.flags + ",maximumSize=" + string3 + ",minimumSize=" + string2 + ",preferredSize=" + string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector roots = new Vector(1);
        private final ObjectInputStream inputStream;

        ReadObjectCallback(ObjectInputStream objectInputStream) throws Exception {
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateObject() throws InvalidObjectException {
            try {
                int n2 = 0;
                while (n2 < this.roots.size()) {
                    JComponent jComponent = (JComponent)this.roots.elementAt(n2);
                    SwingUtilities.updateComponentTreeUI(jComponent);
                    ++n2;
                }
                Object var4_3 = null;
                readObjectCallbacks.remove(this.inputStream);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                readObjectCallbacks.remove(this.inputStream);
                throw throwable;
            }
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            int n2 = 0;
            while (n2 < this.roots.size()) {
                JComponent jComponent2 = (JComponent)this.roots.elementAt(n2);
                container = jComponent;
                while (container != null) {
                    if (container == jComponent2) {
                        return;
                    }
                    container = container.getParent();
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.roots.size()) {
                container = (JComponent)this.roots.elementAt(n3);
                Container container2 = container.getParent();
                while (container2 != null) {
                    if (container2 == jComponent) {
                        this.roots.removeElementAt(n3--);
                        break;
                    }
                    container2 = container2.getParent();
                }
                ++n3;
            }
            this.roots.addElement(jComponent);
        }
    }

    private class EnableSerializationFocusListener
    implements FocusListener,
    Serializable {
        private EnableSerializationFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            JComponent.this.compWriteObjectNotify();
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        protected ContainerListener accessibleContainerHandler = null;
        protected FocusListener accessibleFocusHandler = null;

        protected AccessibleJComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                JComponent.this.addFocusListener(this.accessibleFocusHandler);
            }
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler != null) {
                JComponent.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = this.getBorderTitle(JComponent.this.getBorder());
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                try {
                    string = this.getToolTipText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n2) {
            return super.getAccessibleChild(n2);
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public String getToolTipText() {
            return null;
        }

        public String getTitledBorderText() {
            Border border = JComponent.this.getBorder();
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext != null) {
                    ((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext != null) {
                    ((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = class$javax$swing$JComponent$KeyboardState == null ? (class$javax$swing$JComponent$KeyboardState = JComponent.class$("javax.swing.JComponent$KeyboardState")) : class$javax$swing$JComponent$KeyboardState;

        KeyboardState() {
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static void registerKeyPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (intVector.elementAt(n4) == -1) {
                    intVector.setElementAt(n2, n4);
                    return;
                }
                ++n4;
            }
            intVector.addElement(n2);
        }

        static void registerKeyReleased(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (intVector.elementAt(n4) == n2) {
                    intVector.setElementAt(-1, n4);
                    return;
                }
                ++n4;
            }
        }

        static boolean keyIsPressed(int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (intVector.elementAt(n4) == n2) {
                    return true;
                }
                ++n4;
            }
            return false;
        }

        static boolean shouldProcess(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
                    }
                    return true;
                }
                case 402: {
                    if (KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
                        return true;
                    }
                    return false;
                }
                case 400: {
                    return true;
                }
            }
            return false;
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        IntVector() {
        }

        int size() {
            return this.count;
        }

        int elementAt(int n2) {
            return this.array[n2];
        }

        void addElement(int n2) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n2;
        }

        void setElementAt(int n2, int n3) {
            this.array[n3] = n2;
        }
    }

    final class ActionStandin
    implements Action {
        private final ActionListener actionListener;
        private final String command;
        private final Action action;

        ActionStandin(ActionListener actionListener, String string) {
            this.actionListener = actionListener;
            this.action = actionListener instanceof Action ? (Action)actionListener : null;
            this.command = string;
        }

        public Object getValue(String string) {
            if (string != null) {
                if (string.equals("ActionCommandKey")) {
                    return this.command;
                }
                if (this.action != null) {
                    return this.action.getValue(string);
                }
                if (string.equals("Name")) {
                    return "ActionStandin";
                }
            }
            return null;
        }

        public boolean isEnabled() {
            if (this.actionListener == null) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            return this.action.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl2) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }
}

