/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Vector;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.WrappedRuntimeException;

public class ObjectPool
implements Serializable {
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new Vector();
    }

    public ObjectPool(String string) {
        try {
            this.objectType = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
        this.freeStack = new Vector();
    }

    public ObjectPool(Class clazz, int n2) {
        this.objectType = clazz;
        this.freeStack = new Vector(n2);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object object = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return object;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new RuntimeException(XSLMessages.createMessage(178, null));
        }
        Object object = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return object;
    }

    public synchronized void freeInstance(Object object) {
        this.freeStack.addElement(object);
    }
}

