/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;

public class FunctionMultiArgs
extends Function3Args {
    Expression[] m_args;

    public void setArg(Expression expression, int n2) throws WrongNumberArgsException {
        if (n2 < 3) {
            super.setArg(expression, n2);
        } else if (null == this.m_args) {
            this.m_args = new Expression[1];
            this.m_args[0] = expression;
        } else {
            Expression[] expressionArray = new Expression[this.m_args.length + 1];
            System.arraycopy(this.m_args, 0, expressionArray, 0, this.m_args.length);
            expressionArray[this.m_args.length] = expression;
            this.m_args = expressionArray;
        }
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        if (null != this.m_args) {
            int n3 = 0;
            while (n3 < this.m_args.length) {
                this.m_args[n3].fixupVariables(vector, n2);
                ++n3;
            }
        }
    }

    public void checkNumberArgs(int n2) throws WrongNumberArgsException {
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n2 = this.m_args.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.m_args[n3].canTraverseOutsideSubtree()) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

