/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class NativeFontWrapper {
    private static boolean usePlatformFontMetrics = false;
    public static final int ROTATE_UNKNOWN = -1;
    public static final int ROTATE_FALSE = 0;
    public static final int ROTATE_TRUE = 1;
    public static final int ROTATE_CHECK_STRING = 2;

    public static boolean usePlatformFontMetrics() {
        return usePlatformFontMetrics;
    }

    static native boolean getPlatformFontVar();

    public static synchronized native String getFontPath(boolean var0);

    public static synchronized native void setNativeFontPath(String var0);

    public static synchronized native void registerFonts(Vector var0, int var1, Vector var2, int var3, boolean var4);

    public static synchronized native void registerCompositeFont(String var0, String[] var1, int[] var2, int[] var3);

    public static synchronized native int getNumFonts();

    public static synchronized native String getFamilyNameByIndex(int var0, int var1);

    public static synchronized native String getFullNameByIndex(int var0);

    public static synchronized native String getFullNameByFileName(String var0);

    public static synchronized native String createFont(String var0, int var1);

    public static synchronized native boolean getType1FontVar();

    public static synchronized native void initializeFont(Font var0, String var1, int var2);

    public static synchronized native String getFamilyName(Font var0, short var1);

    public static synchronized native String getFullName(Font var0, short var1);

    public static synchronized native int getNumGlyphs(Font var0);

    public static synchronized native int getMissingGlyphCode(Font var0);

    public static byte getBaselineFor(Font font, char c2) {
        return 0;
    }

    public static synchronized native boolean canDisplay(Font var0, char var1);

    public static synchronized native boolean doesGlyphShaping(Font var0);

    public static synchronized native boolean isStyleSupported(Font var0, int var1);

    public static synchronized native boolean charsToGlyphs(Font var0, char[] var1, int var2, int[] var3, int var4, int var5);

    public static void getBaseLineOffsetsFor(Font font, char c2, double[] dArray, float[] fArray) {
        float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        NativeFontWrapper.getFontMetrics(font, dArray, false, false, fArray2);
        fArray[0] = 0.0f;
        fArray[1] = (fArray2[0] + fArray2[1]) / 2.0f - fArray2[0];
        fArray[2] = fArray2[1] - fArray2[0];
    }

    public static synchronized native int fontCanRotate(Font var0);

    public static synchronized native boolean fontCanRotateText(Font var0, String var1, double[] var2, boolean var3, boolean var4);

    public static synchronized native boolean fontCanRotateGlyphVector(Font var0, int[] var1, double[] var2, boolean var3, boolean var4);

    public static synchronized native void getFontMetrics(Font var0, double[] var1, boolean var2, boolean var3, float[] var4);

    public static synchronized native float getItalicAngle(Font var0, double[] var1, boolean var2, boolean var3);

    public static synchronized native void getCharMetrics(Font var0, int var1, double[] var2, double[] var3, boolean var4, boolean var5, float[] var6);

    public static synchronized native Rectangle2D getGlyphLogicalBounds(Font var0, int var1, int[] var2, float[] var3, double[] var4, int[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native Rectangle2D getVisualBounds(Font var0, int[] var1, float[] var2, double[] var3, int[] var4, double[] var5, boolean var6, boolean var7);

    public static synchronized native Rectangle2D getGlyphVisualBounds(Font var0, int var1, int[] var2, float[] var3, double[] var4, int[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native void getGlyphMetrics(Font var0, int var1, double[] var2, double[] var3, boolean var4, boolean var5, float[] var6);

    public static synchronized native float[] getGlyphInfo(Font var0, int[] var1, float[] var2, double[] var3, int[] var4, double[] var5, double[] var6, boolean var7, boolean var8);

    public static synchronized native Rectangle getPixelBounds(Font var0, float var1, float var2, int[] var3, float[] var4, double[] var5, int[] var6, double[] var7, double[] var8, boolean var9, boolean var10);

    public static synchronized native Rectangle getGlyphPixelBounds(Font var0, int var1, float var2, float var3, int[] var4, float[] var5, double[] var6, int[] var7, double[] var8, double[] var9, boolean var10, boolean var11);

    public static synchronized native void populateGlyphVector(Font var0, char[] var1, double[] var2, boolean var3, boolean var4, GlyphVector var5);

    public static synchronized native void populateGlyphVector(Font var0, char[] var1, int var2, int var3, double[] var4, boolean var5, boolean var6, GlyphVector var7);

    public static synchronized native void populateAndLayoutGlyphVector(Font var0, char[] var1, int var2, int var3, int var4, double[] var5, double[] var6, boolean var7, boolean var8, GlyphVector var9);

    public static synchronized native void layoutGlyphVector(Font var0, double[] var1, double[] var2, boolean var3, boolean var4, GlyphVector var5);

    public static synchronized native void shapeGlyphVector(GlyphVector var0, Font var1, double[] var2, boolean var3, boolean var4, Object var5, GlyphVector var6);

    public static synchronized native Shape getGlyphVectorOutline(GlyphVector var0, Font var1, double[] var2, double[] var3, boolean var4, boolean var5, float var6, float var7);

    public static synchronized native Shape getGlyphOutline(GlyphVector var0, int var1, Font var2, double[] var3, double[] var4, boolean var5, boolean var6, float var7, float var8);

    public static synchronized native void getGlyphJustificationInfo(Font var0, int var1, GlyphJustificationInfo var2);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        AccessController.doPrivileged(new LoadLibraryAction("fontmanager"));
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("java2d.font.usePlatformFont"));
        if (string != null && string.startsWith("Windows") && ("true".equals(string2) || NativeFontWrapper.getPlatformFontVar())) {
            usePlatformFontMetrics = true;
            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
            System.out.println("functionality. This property will be removed in a later release.");
        }
    }
}

