/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.security.action.GetPropertyAction;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static long hEnv;
    protected static long hDbc;
    protected static Hashtable connectionList;
    protected static String nativePrefix;

    public JdbcOdbcDriver() {
        connectionList = new Hashtable();
        nativePrefix = "";
    }

    protected synchronized void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Driver.finalize");
        }
        try {
            if (hDbc != 0L) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        jdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(string), properties, DriverManager.getLoginTimeout());
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl2 = false;
        if (this.knownURL(string) && this.trusted()) {
            bl2 = true;
        }
        return bl2;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Driver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String string2 = JdbcOdbcDriver.makeConnectionString(properties);
        String string3 = "";
        string3 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(string), string2);
        Hashtable hashtable = this.getAttributeProperties(string3);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[hashtable.size()];
        int n2 = 0;
        while (n2 < hashtable.size()) {
            driverPropertyInfoArray[n2] = (DriverPropertyInfo)hashtable.get(new Integer(n2));
            ++n2;
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private boolean initialize() throws SQLException {
        boolean bl2 = true;
        if (OdbcApi == null) {
            try {
                OdbcApi = new JdbcOdbc(nativePrefix);
                JdbcOdbcDriver.OdbcApi.charSet = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
            }
            catch (Exception exception) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Unable to load JdbcOdbc library");
                }
                bl2 = false;
            }
        }
        if (hEnv == 0L) {
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Unable to allocate environment");
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean knownURL(String string) {
        String string2 = JdbcOdbcDriver.getProtocol(string);
        if (!string2.equalsIgnoreCase("jdbc")) {
            return false;
        }
        string2 = JdbcOdbcDriver.getSubProtocol(string);
        return string2.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n2;
        String string2 = "";
        int n3 = string.indexOf(58);
        if (n3 >= 0 && (n2 = string.indexOf(58, n3 + 1)) >= 0) {
            string2 = string.substring(n3 + 1, n2);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n2;
        String string2 = "";
        int n3 = string.indexOf(58);
        if (n3 >= 0 && (n2 = string.indexOf(58, n3 + 1)) >= 0) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    private boolean trusted() {
        SecurityManager securityManager;
        boolean bl2 = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = (String)AccessController.doPrivileged(new GetPropertyAction("browser"));
                if (string != null && string.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                securityManager.checkWrite("JdbcOdbcSecurityCheck");
                bl2 = true;
            }
            catch (SecurityException securityException) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Security check failed: " + securityException.getMessage());
                }
                bl2 = false;
            }
        } else {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bl2 = true;
        }
        bl2 = true;
        return bl2;
    }

    public String getConnectionAttributes(String string, String string2) throws SQLException {
        String string3;
        String string4 = "DSN=" + string + string2;
        if (hDbc == 0L) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((string3 = OdbcApi.SQLBrowseConnect(hDbc, string4)) == null) {
            string3 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        return string3;
    }

    public Hashtable getAttributeProperties(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Hashtable hashtable = new Hashtable();
        int n5 = string.length();
        while (n2 < n5) {
            boolean bl2 = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            n3 = string.indexOf(";", n2);
            if (n3 < 0) {
                n3 = n5;
            }
            String string5 = string.substring(n2, n3);
            int n6 = 0;
            int n7 = string5.indexOf(":", 0);
            int n8 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl2 = false;
                ++n6;
            }
            if (n7 > 0) {
                string2 = string5.substring(n6, n7);
            }
            if (n7 > 0 && n8 > 0) {
                string3 = string5.substring(n7 + 1, n8);
            }
            if (n8 > 0 && (string4 = string5.substring(n8 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = JdbcOdbcDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl2;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n4), driverPropertyInfo);
            ++n4;
            n2 = n3 + 1;
        }
        return hashtable;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration enumeration = properties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = properties.getProperty("charSet", (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding")));
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    protected static String[] listToArray(String var0) {
        var1_1 = null;
        var3_2 = new Hashtable();
        var4_3 = 0;
        var5_4 = 1;
        var6_5 = 1;
        var7_6 = var0.length();
        if (!var0.startsWith("{")) {
            return null;
        }
        if (var0.endsWith("}")) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            var6_5 = var0.indexOf(",", var5_4);
            if (var6_5 < 0) {
                var6_5 = var7_6 - 1;
            }
            var2_7 = var0.substring(var5_4, var6_5);
            var3_2.put(new Integer(var4_3), var2_7);
            ++var4_3;
            var5_4 = var6_5 + 1;
lbl19:
            // 2 sources

            ** while (var5_4 < var7_6)
        }
lbl20:
        // 1 sources

        var1_1 = new String[var4_3];
        var5_4 = 0;
        while (var5_4 < var4_3) {
            var1_1[var5_4] = var2_7 = (String)var3_2.get(new Integer(var5_4));
            ++var5_4;
        }
        return var1_1;
    }

    public long allocConnection(long l2) throws SQLException {
        long l3 = 0L;
        l3 = OdbcApi.SQLAllocConnect(l2);
        connectionList.put(new Long(l3), new Long(l2));
        return l3;
    }

    public void closeConnection(long l2) throws SQLException {
        OdbcApi.SQLFreeConnect(l2);
        Long l3 = (Long)connectionList.remove(new Long(l2));
        if (connectionList.size() == 0 && hEnv != 0L) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0L;
        }
    }

    public void disconnect(long l2) throws SQLException {
        OdbcApi.SQLDisconnect(l2);
    }

    static {
        block3: {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(jdbcOdbcDriver);
            }
            catch (SQLException sQLException) {
                if (!JdbcOdbcObject.isTracing()) break block3;
                JdbcOdbcObject.trace("Unable to register driver");
            }
        }
    }
}

