/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Modifier;

public class Reflection {
    public static native Class getCallerClass(int var0);

    private static native int getClassAccessFlags(Class var0);

    public static boolean quickCheckMemberAccess(Class clazz, int n2) {
        return Modifier.isPublic(Reflection.getClassAccessFlags(clazz) & n2);
    }

    public static void ensureMemberAccess(Class clazz, Class clazz2, Object object, int n2) throws IllegalAccessException {
        if (clazz == null || clazz2 == null) {
            throw new InternalError();
        }
        if (!Reflection.verifyMemberAccess(clazz, clazz2, object, n2)) {
            throw new IllegalAccessException("Class " + clazz.getName() + " can not access a member of class " + clazz2.getName() + " with modifiers \"" + Modifier.toString(n2) + "\"");
        }
    }

    public static boolean verifyMemberAccess(Class clazz, Class clazz2, Object object, int n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflection.getClassAccessFlags(clazz2))) {
            bl3 = Reflection.isSameClassPackage(clazz, clazz2);
            bl2 = true;
            if (!bl3) {
                return false;
            }
        }
        if (Modifier.isPublic(n2)) {
            return true;
        }
        boolean bl4 = false;
        if (Modifier.isProtected(n2) && Reflection.isSubclassOf(clazz, clazz2)) {
            bl4 = true;
        }
        if (!bl4 && !Modifier.isPrivate(n2)) {
            if (!bl2) {
                bl3 = Reflection.isSameClassPackage(clazz, clazz2);
                bl2 = true;
            }
            if (bl3) {
                bl4 = true;
            }
        }
        if (!bl4) {
            return false;
        }
        if (Modifier.isProtected(n2)) {
            Class clazz3;
            Class clazz4 = clazz3 = object == null ? clazz2 : object.getClass();
            if (clazz3 != clazz) {
                if (!bl2) {
                    bl3 = Reflection.isSameClassPackage(clazz, clazz2);
                    bl2 = true;
                }
                if (!bl3 && !Reflection.isSubclassOf(clazz3, clazz)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        return Reflection.isSameClassPackage(clazz.getClassLoader(), clazz.getName(), clazz2.getClassLoader(), clazz2.getName());
    }

    private static boolean isSameClassPackage(ClassLoader classLoader, String string, ClassLoader classLoader2, String string2) {
        int n2;
        int n3;
        if (classLoader != classLoader2) {
            return false;
        }
        int n4 = string.lastIndexOf(46);
        int n5 = string2.lastIndexOf(46);
        if (n4 == -1 || n5 == -1) {
            return n4 == n5;
        }
        int n6 = 0;
        int n7 = 0;
        if (string.charAt(n6) == '[') {
            while (string.charAt(++n6) == '[') {
            }
            if (string.charAt(n6) != 'L') {
                throw new InternalError("Illegal class name " + string);
            }
        }
        if (string2.charAt(n7) == '[') {
            while (string2.charAt(++n7) == '[') {
            }
            if (string2.charAt(n7) != 'L') {
                throw new InternalError("Illegal class name " + string2);
            }
        }
        if ((n3 = n4 - n6) != (n2 = n5 - n7)) {
            return false;
        }
        return string.regionMatches(false, n6, string2, n7, n3);
    }

    static boolean isSubclassOf(Class clazz, Class clazz2) {
        while (clazz != null) {
            if (clazz == clazz2) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

