.TH xautolock l "January 24, 1995"

.SH NAME
xautolock \- fire up programs in case of user inactivity under X

.SH VERSION
This man page applies to xautolock patchlevel 10 with local
modifications (-idlefile option).

.SH SYNOPSIS 
.TP 10
.B \fBxautolock\fR
[\fB\-help\fR] [\fB\-version\fR] 
[\fB\-time\fR \fImins\fR] [\fB\-locker\fR \fIlocker\fR]
[\fB\-notify \fImargin\fR] [\fB\-notifier \fInotifier\fR]
[\fB\-bell \fIpercent\fR]
[\fB\-corners\fR \fIxxxx\fR]
[\fB\-cornerdelay\fR \fIsecs\fR]
[\fB\-cornerredelay\fR \fIaltsecs\fR]
[\fB\-cornersize\fR \fIpixels\fR]
[\fB\-nocloseout\fR] [\fB\-nocloseerr\fR] [\fB\-noclose\fR]
[\fB\-disable\fR] [\fB\-enable\fR] [\fB\-toggle\fR]
[\fB\-idlefile\fR \fIstampfile\fR]

.SH DESCRIPTION 
Xautolock monitors the user activity on an X Window display. If none is
detected within \fImins\fR minutes, a program is started as specified by
the \fB\-locker\fR option. Xautolock will typically be used to lock the
screen (hence its primary name) but it really doesn't care what program
you make it start. For this reason, xautolock does not interfere with the
default screen saver. This implies that it is the job of the \fIlocker\fR
to take the appropriate actions if the default screen saver is to be 
disabled.  The only real assumption made by xautolock is that a new
countdown starts as soon as the \fIlocker\fR exits.
A \fIlocker\fR value of ``NONE'' suppresses the locking action,
which is typically used in conjunction with the \fB\-idlefile\fR
feature (described below).

In the presence of the \fB\-notify\fR option, a warning signal will be 
issued \fImargin\fR seconds before starting the \fIlocker\fR. Warning 
signals come in two kinds:
.TP 3
\(bu
You can use the \fB\-notifier\fR option to specify the command to be
issued to perform notification.
.TP
\(bu
Alternatively, you can let xautolock ring the bell. In this case, the
\fB\-bell\fR option specifies the loudness of the signal in \fIpercent\fR.
.RE

You can tell xautolock to take special actions when you move the mouse into
one of the corners of the display and leave it there, by using the
\fB\-corners\fR, \fB\-cornerdelay\fR, \fB\-cornerredelay\fR and
\fB\-cornersize\fR options. This works as follows:

The \fIxxxx\fR argument to the \fB\-corners\fR option must consist of exactly
4 characters from the following set: '0', '+', '-'. Each one of these
specifies what xautolock should do when the mouse enters a small square area
located in each of the corners of the screen. The corners are considered in
the following order: top left, top right, bottom left, bottom right.  A '0'
indicates that xautolock should ignore the corner. A '+' indicates that
xautolock should start the \fIlocker\fR after \fIsecs\fR or \fIaltsecs\fR
seconds (see below for the difference between both), unless the mouse is
moved or keyboard input is received. A '-' indicates that xautolock should
not start the \fIlocker\fR at all. The \fIpixels\fR argument specifies the
size in pixels of the corner areas.

Most users of the \fB\-corners\fR option want the \fIlocker\fR to activate
within a very short time interval after they move the mouse into a '+' corner.
This can be achieved by specifying a small value for the \fB\-cornerdelay\fR
option. However, if the mouse is subsequently left where it is, xautolock
will almost immediately start a new \fIlocker\fR right after the user quits
the current one. To prevent this from happening, the \fB\-cornerredelay\fR
option can be used to specify the time-out interval to be used if and only
if the mouse is sitting in a `+' corner and has not been moved since the 
previous \fIlocker\fR exited.

A running xautolock process can been also be disabled, in which case it will
not attempt to start the \fIlocker\fR. To disable an already running xautolock
process, use the \fB\-disable\fR option. To re-enable it, use \fB\-enable\fR.
To toggle it between both states, use \fB\-toggle\fR. Using this method is
preferable to using sending it SIGSTOP and SIGCONT signals, because while
disabled xautolock will still be emptying its event queue. 

The \fB\-idlefile\fR option can be used to pass the (approximate) time
of the last X input event on to other programs.  xautolock must be able to
create the specified \fIstampfile\fP, or it must be writable by the
invoking user.  xautolock will record the time of last input
(keyboard or mouse) as the `last access' time of \fIstampfile\fP.
The idlefile function can be explicitly disabled by giving ``NONE`` as
the \fIstampfile\fP.

By default xautolock closes stdout and stderr. This prevents the \fIlocker\fR
from writing error messages to these files in case you manually lock your
display.  The \fB\-nocloseout\fR, \fB\-nocloseerr\fR and \fB\-noclose\fR
options cause xautolock to not close stdout and/or stderr. On some platforms
users of xnlock will need to use \fB\-nocloseout\fR, in order to make xnlock's
witty sayings show up. These options can also be used for debugging cases in
which \fIlocker\fR invocation is not successful.

Xautolock is capable of managing multi-headed displays.

.SH OPTIONS
.TP 16
\fB\-help\fR
Print a help message and exit.
.TP 
\fB\-version\fR
Print the version number and exit.
.TP 
\fB\-time\fR
Specifies the time-out interval. The default is 10 minutes,
the minimum is 1 minute and the maximum is 1 hour.
.TP 
\fB\-locker\fR
Specifies the \fIlocker\fR to be used. The default is xlock. Notice that if
\fIlocker\fR contains several words, it must be specified between quotes.
In order to use your PATH to locate the program, xautolock feeds the
\fIlocker\fR command to /bin/sh, so it should be understandable for
whatever shell your /bin/sh is. Because this typically is a Bourne
shell, ~ expansion most likely will not work. 
.TP 
\fB\-notify\fR
Warn the user \fImargin\fR seconds before locking. The default is to not
warn the user. If used in conjunction with \fB\-cornerdelay\fR or 
\fB\-cornerredelay\fR, the notification margin iused is the minimum of
\fImargin\fR, \fIsecs\fR and/or \fIaltsecs\fR.
.TP
\fB\-notifier\fR
Specifies the notifier to be used. The default is none. This option is only
useful in conjunction with \fB\-notify\fR. Notice that if \fInotifier\fR 
contains several words, it must be specified between quotes. In order to 
use your PATH to locate the program, xautolock feeds the \fInotifier\fR
command to /bin/sh, so it should be understandable for whatever shell your
/bin/sh is. Because this typically is a Bourne shell, ~ expansion most
likely will not work.
.TP
\fB\-bell\fR
Specifies the loudness of the notification signal in the absence of the
\fB\-notifier\fR option. The default is 40 percent. This option is only 
useful in conjunction with \fB\-notify\fR.
.TP 
\fB\-corners\fR
Define special actions to be taken when the mouse enters one of the
corners of the display. The default is 0000, which means that no special
action is taken.
.TP 
\fB\-cornerdelay\fR
Specifies the number of seconds to wait before reacting to the mouse
entering a '+' corner. The default is 5 seconds.
.TP 
\fB\-cornerredelay\fR
Specifies the number of seconds to wait
before reacting again if the current \fIlocker\fR exits while the mouse is
sitting in a '+' corner. The default is for \fIaltsecs\fR to equal
\fIsecs\fR.
.TP 
\fB\-cornersize\fR
Specifies the size in pixels of the corner areas. The default is 10 pixels.
.TP 
\fB\-nocloseout\fR
Don't close stdout.
.TP 
\fB\-nocloseerr\fR
Don't close stderr.
.TP 
\fB\-noclose\fR
Close neither stdout nor stderr.
.TP 
\fB\-disable\fR
Disables an already running xautolock process (if there is one). In any
case, the current invocation of xautolock exits.
.TP 
\fB\-enable\fR
Enables an already running xautolock process (if there is one). In any
case, the current invocation of xautolock exits.
.TP 
\fB\-toggle\fR
Toggles an already running xautolock process (if there is one) between
its disabled and enabled modes of operation. In any case, the current
invocation of xautolock exits.

.SH RESOURCES
.TP 16
.B time 
Specifies the time out period.
.TP 
.B locker 
Specifies the \fIlocker\fR. No quotes are needed, even if your \fIlocker\fR
command contains several words.
.TP 
.B notify 
Specifies the notification margin.
.TP 
.B notifier 
Specifies the notifier. No quotes are needed, even if your notifier
command contains several words.
.TP 
.B bell 
Specifies the notification loudness.
.TP 
.B corners 
Specifies the corner behaviour.
.TP 
.B cornersize 
Specifies the size of the corner areas.
.TP 
.B cornerdelay 
Specifies the delay of a '+' corner.
.TP 
.B cornerredelay 
Specifies the alternative delay of a '+' corner.
.TP   
.B nocloseout
Don't close stdout.
.TP   
.B nocloseerr
Don't close stderr.
.TP   
.B noclose 
Close neither stdout nor stderr.

.PP
Resources can be specified in your \fI~/.Xdefaults\fR file, either for class
\fIXautolock\fR, or for whatever name you renamed xautolock to. This can be
useful in case xautolock is to be used for other purposes than simply locking
the screen. For example: if you have two copies of xautolock, one called
"xmonitor", and one called "xlogout", then both will honour the following:
.IP
\fBXautolock.corners: ++++\fR
.PP
In addition, "xmonitor" will honour:
.IP
\fBxmonitor.cornersize: 10\fR
.PP
while "xlogout" will honour:
.IP
\fBxlogout.cornersize: 5\fR
.PP
Each command line option takes precedence over the corresponding
default resource specification.

.SH KNOWN\ BUGS 
If, when creating a window, an application waits for more than 30 seconds 
before selecting KeyPress events on non-leaf windows, xautolock may
interfere with the event propagation mechanism. This effect is theoretical
and has never been observed in real life. It can only occur in case
xautolock has not been compiled to support the Xidle extension or in case
the X server does not support Xidle.

xautolock does not properly handle the secure keyboard mode of terminal
emulators like xterm, since that mode will prevent xautolock from noticing
the keyboard events occurring on the terminal. Therefore, xautolock
sometimes thinks that there is no keyboard activity while in reality there
is. This can only occur in case xautolock has not been compiled to support
the Xidle extension or in case the X server does not support Xidle.

xautolock does not check whether \fInotifier\fR and/or \fIlocker\fR are
available.

The xautolock resources have dummy resource classes. 

.SH SEE\ ALSO
X(1),
xlock(1),
xnlock(1),
xscreensaver(1).

.SH COPYRIGHT
Copyright 1990, 1992-1995 by S. De Troch and MCE.

Permission to use, copy, modify and distribute this software and the
supporting documentation without fee is hereby granted, provided that
.TP 4
.B 1:
Both the above copyright notice and this permission notice appear in all
copies of both the software and the supporting documentation.
.TP 4
.B 2:
No financial profit is made out of it.
.TP 0
THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL THEY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

.SH AUTHORS   
Stefan De Troch          detroch@imec.be
.br
Michel Eyckmans (MCE)    eyckmans@imec.be

.SH SPECIAL\ THANKS\ TO
Kris Croes               croes@imec.be

.SH LOCAL\ MODS
Andreas Stolcke		stolcke@icsi.berkeley.edu
