/*
 *  Copyright (C) 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __misc_callbacks_h
#define __misc_callbacks_h

#ifdef __cplusplus
extern "C" {
#endif

#include <gtk/gtk.h>
#include <libgnomeui/gnome-client.h>

/* misc_callbacks.c */
void history_menu_menuitem_activate_cb (GtkMenuItem *menuitem, 
					gpointer user_data);
gboolean history_menu_menuitem_button_release_cb (GtkMenuItem *menuitem,
				GdkEventButton *event, gpointer user_data);
void up_menu_menuitem_activate_cb (GtkMenuItem *menuitem, gpointer user_data);
gboolean up_menu_menuitem_button_release_cb (GtkMenuItem *menuitem,
				GdkEventButton *event, gpointer user_data);
gint popup_selection_done_cb (GtkMenuShell *menushell, GtkWidget *popup);
void context_bm_toolbar_appearance_menu_cb (GtkRadioMenuItem *menuitem, 
					    gpointer bm);
void context_main_toolbar_appearance_menu_cb (GtkRadioMenuItem *menuitem, 
					      gpointer data);
void context_main_toolbar_icons_menu_cb (GtkRadioMenuItem *menuitem,
					 gpointer user_data);
void context_main_toolbar_edit_toolbar_cb (GtkMenuItem *menuitem, 
					   GaleonWindow *window);
void separator_toolbar_orientation_changed_cb (GtkToolbar *tb,
					       GtkOrientation o,
					       GtkWidget *sep);
GdkFilterReturn gtk_theme_changed_cb (GdkXEvent *xevent, GdkEvent *event,
				      gpointer data);
gboolean generic_link_button_press_event_cb (GtkWidget *widget,
					     GdkEventButton *event,
				             GaleonWindow *window);
gboolean generic_editable_button_press_event_cb (GtkWidget *entry,
				                 GdkEventButton *event,
				                 gpointer user_data);
#ifdef __cplusplus
}
#endif
#endif
