/*
 *  Copyright (C) 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __misc_gui_h
#define __misc_gui_h

#ifdef __cplusplus
extern "C" {
#endif

/* system includes */
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomeui/gnome-dialog.h>
#include <gnome.h>

/* progress bar defines */
#define BAR_WIDTH             52
#define BAR_HEIGHT            10
#define BAR_BACKGROUND  0xffffff
#define BAR_BORDER      0x404040
#define BAR_LINE        0x808080
#define BAR_ACTIVE      0xdba906

/* misc_gui.c */
void misc_gui_label_set_accel_text (const gchar *text, GtkWidget *label,
				    GtkWidget *menu, GtkWidget *item);
GtkWidget *misc_gui_new_num_accel_label (gint num, gchar *origtext,
					 gboolean lettersok, GtkWidget *menu,
					 GtkWidget *item);
void misc_gui_menu_position_under_widget (GtkMenu *menu, gint *x, gint *y, 
					  gpointer user_data);
void misc_gui_colors_init (void);
PixmapData *misc_gui_pixmap_data_new_from_file (const gchar *file,
						gboolean prelight);
void misc_gui_pixmap_data_free (PixmapData *data);
void misc_gui_pixbuf_threshold_alpha (GdkPixbuf *pixbuf, gboolean prelight);
gint misc_gui_gtk_radio_button_get (GtkRadioButton *radio_button);
void misc_gui_gtk_radio_button_set (GtkRadioButton *radio_button, gint index);
gint misc_gui_radio_menuitem_index (GtkRadioMenuItem *menuitem);
gchar *misc_gui_string_from_accel_data (GtkWidget *widget, guint accel_key, 
					GdkModifierType accel_mods);
gint misc_gui_gnome_dialog_run (GnomeDialog *dialog, gboolean close_after);
void misc_gui_gtk_ctree_link (GtkCTree *ctree, GtkCTreeNode *node,
			      GtkCTreeNode *parent, GtkCTreeNode *sibling,
			      gboolean update_focus_row);
void misc_gui_gtk_ctree_unlink (GtkCTree *ctree, GtkCTreeNode *node,
				gboolean update_focus_row);
GtkWidget *misc_gui_toolbar_append_separator (GtkToolbar *toolbar);
GdkPixmap *misc_gui_render_bar (guint32 colour, gint width);
gboolean misc_gui_gdk_window_is_visible (GdkWindow *window);

GtkWidget *misc_gui_new_popup_menu_lock_accels (GnomeUIInfo *menu_uiinfo);

#ifdef __cplusplus
}
#endif
#endif

