/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef GQVIEW_H
#define GQVIEW_H

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#ifdef HAVE_STRVERSCMP
#  define _GNU_SOURCE
#endif

#include "intl.h"

/*
 *-------------------------------------
 * Standard library includes
 *-------------------------------------
 */

#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>

/*
 *-------------------------------------
 * includes for glib / gtk / gdk-pixbuf
 *-------------------------------------
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gdk-pixbuf-loader.h>

#include "typedefs.h"

/*
 *----------------------------------------------------------------------------
 * defines
 *----------------------------------------------------------------------------
 */

#define GDK_PIXBUF_TILES_BROKEN 1	/* tiles is broken in gdk-pixbuf 0.10.0 */

#define GQVIEW_RC_DIR             ".gqview"
#define GQVIEW_RC_DIR_THUMBS      ".gqview/thumbnails"
#define GQVIEW_RC_DIR_COLLECTIONS ".gqview/collections"

#define RC_FILE_NAME "gqviewrc"

#define ZOOM_RESET_ORIGINAL 0
#define ZOOM_RESET_FIT_WINDOW 1
#define ZOOM_RESET_NONE 2

#define MOUSEWHEEL_SCROLL_SIZE 20

/*
 *----------------------------------------------------------------------------
 * globals
 *----------------------------------------------------------------------------
 */

/*
 * Since globals are used everywhere,
 * it is easier to define them here.
 */

/* image */
extern ImageWindow *main_image;

/* main window */
extern GtkWidget *mainwindow;
extern GtkWidget *mainwindow_hbox;
extern GtkWidget *mainwindow_vbox;
extern GtkAccelGroup *mainwindow_accel_grp;

extern GtkWidget *info_box;
extern GtkWidget *info_progress_bar;
extern GtkWidget *info_status;
extern GtkWidget *info_details;
extern GtkWidget *info_zoom;

/* full screen */
extern ImageWindow *normal_image;
extern ImageWindow *full_screen_image;
extern GtkWidget *full_screen_window;

/* tools floating window */
extern GtkWidget *toolwindow;

/* tools */
extern GtkWidget *tool_vbox;

extern GtkWidget *path_entry;
extern GtkWidget *history_menu;

extern GtkWidget *dir_clist;
extern GtkWidget *file_clist;

extern GtkItemFactory *gqview_fact;

extern GtkWidget *thumb_button;

extern gchar *current_path;

extern GList *filename_filter;

/* -- options -- */
extern gint main_window_w;
extern gint main_window_h;
extern gint main_window_x;
extern gint main_window_y;

extern gint float_window_w;
extern gint float_window_h;
extern gint float_window_x;
extern gint float_window_y;

extern gint main_window_vdivider_pos;

extern gint save_window_positions;
extern gint tools_float;
extern gint tools_hidden;
extern gint progressive_key_scrolling;

extern gint startup_path_enable;
extern gchar *startup_path;
extern gint confirm_delete;
extern gint enable_delete_key;
extern gint restore_tool;
extern gint zoom_mode;
extern gint fit_window;
extern gint limit_window_size;
extern gint zoom_to_fit_expands;
extern gint max_window_size;
extern gint thumb_max_width;
extern gint thumb_max_height;
extern gint enable_thumb_caching;
extern gint enable_thumb_dirs;
extern gint use_xvpics_thumbnails;
extern gint show_dot_files;
extern gint file_filter_disable;
extern gint filter_include_jpg;
extern gint filter_include_xpm;
extern gint filter_include_tif;
extern gint filter_include_gif;
extern gint filter_include_png;
extern gint filter_include_ppm;
extern gint filter_include_pgm;
extern gint filter_include_pcx;
extern gint filter_include_bmp;
extern gchar *custom_filter;
extern gchar *editor_name[];
extern gchar *editor_command[];

extern gint thumbnails_enabled;
extern SortType file_sort_method;
extern gint file_sort_ascending;

extern gint slideshow_delay;	/* in seconds */
extern gint slideshow_random;
extern gint slideshow_repeat;

extern gint mousewheel_scrolls;
extern gint enable_in_place_rename;

extern gint debug;

extern gint recent_list_max;

extern gint collection_rectangular_selection;
extern gint collection_drop_insert;

extern gint tile_cache_max;	/* in megabytes */
extern gint thumbnail_quality;
extern gint zoom_quality;
extern gint dither_quality;

extern gint zoom_increment;	/* 10 is 1.0, 5 is 0.05, 20 is 2.0, etc. */

extern gint enable_read_ahead;

extern gint place_dialogs_under_mouse;

/* logo & images */
extern const char **logo;
extern const char **img_unknown;

/*
 *----------------------------------------------------------------------------
 * main.c
 *----------------------------------------------------------------------------
 */

/*
 * This also doubles as the main.c header.
 */

void window_set_icon(GtkWidget *window, const char **icon, const gchar *file);

gfloat get_zoom_increment(void);

void help_window_show(const gchar *key);

void start_editor_from_file(gint n, const gchar *path);
void start_editor_from_image(gint n);
void start_editor_from_path_list(gint n, GList *list);
void start_editor_from_list(gint n);
void keyboard_scroll_calc(gint *x, gint *y, GdkEventKey *event);
gint key_press_cb(GtkWidget *widget, GdkEventKey *event, gpointer data);
void exit_gqview(void);


#endif



