/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999, 2000, 2001  Pan Development Team <pan@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __TEXT_H__
#define __TEXT_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include <pan/base/pan-callback.h>

/**
***  CURRENT ARTICLE
**/

/**
 * called whenever the current article changes.
 * @param call_object the old article
 * @param call_arg the new article
 */
extern PanCallback * current_article_changed;

extern Article * get_current_article (void);

/**
***  Wrapping
**/

void          text_set_wrap                                  (gboolean);
gboolean      text_get_wrap                                  (void);
PanCallback*  text_get_fill_body_changed_callback            (void);

/**
***  Show all Headers
**/

void          text_set_show_all_headers                      (gboolean);
gboolean      text_get_show_all_headers                      (void);
PanCallback*  text_get_show_all_headers_changed_callback     (void);

/**
***  Mute Quoted Text
**/

void          text_set_mute_quoted                           (gboolean);
gboolean      text_get_mute_quoted                           (void);
PanCallback*  text_get_mute_quoted_changed_callback          (void);

/**
***  Rot 13
**/

void          text_set_rot13                                 (gboolean);

/**
***  Colors
**/

extern GdkColor text_fg_color;
extern GdkColor text_bg_color;
extern GdkColor text_url_color;
extern GdkColor text_quoted_color[3];


/**
***
**/

GtkWidget*   text_create                     (void);
void         text_read_more                  (void);
void         text_select_all                 (void);
void         text_refresh                    (void);
void         text_clear_nolock               (void);
void         text_set_from_cached_article    (Article      * article);
void         text_set_from_mem_article       (Article      * article, const gchar * text);
void         text_set_from_article           (Article      * article);
void         text_set_raw                    (const gchar  * text);


void         text_set_font                   (void);


gchar*       text_get_message_to_reply_to    (void);

void         update_body_pane                (GtkWidget    * body_widget,
	                                      const gchar  * body,
					      gboolean     mute_quotes);

#endif /* __TEXT_H__ */
