 /***************************************************************************
                          plugin_kateinsertcommand.h  -  description
                             -------------------
    begin                : THU Apr 19 2001
    copyright            : (C) 2001 by Anders Lund
    email                : anders@alweb.dk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PLUGIN_KATE_INSERT_COMMAND_H_
#define _PLUGIN_KATE_INSERT_COMMAND_H_

#include <kate/application.h>
#include <kate/docmanager.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>

#include <kcombobox.h>
#include <kdialogbase.h>
#include <klibloader.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <qcheckbox.h>


class InsertCommandConfigPage;
namespace Kate {
  class PluginConfigPage;
  class PluginView;
}
class KConfig;
class KProcess;
class KShellProcess;
class QButtonGroup;
class QCheckBox;
class QSpinBox;
class QStringList;
class WaitDlg;

class KatePluginFactory : public KLibFactory
{
  Q_OBJECT

  public:
    KatePluginFactory();
    virtual ~KatePluginFactory();

    virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

  private:
    static KInstance* s_instance;
};

class PluginKateInsertCommand : public Kate::Plugin
{
  Q_OBJECT

  public:
    PluginKateInsertCommand( QObject* parent = 0, const char* name = 0 );
    virtual ~PluginKateInsertCommand();

    Kate::PluginView *createView (Kate::MainWindow *win);
    Kate::View *kv;

    WaitDlg *wdlg;

    bool hasConfigPage() { return true; }
    Kate::PluginConfigPage *createConfigPage (QWidget *w);
    QString configPageName() { return i18n("Insert Command"); };
    QString configPageTitle() { return i18n("Configure Insert Command Plugin"); };
    //QPixmap configPageIcon() { return 0L; };

  private:
    void initConfigPage( InsertCommandConfigPage* );

    KShellProcess *sh;
    QString workingdir;
    QString cmd;
    QStringList cmdhist;
    bool bInsStdErr;
    int dialogSettings;
    KConfig *config;

  public slots:
    void slotInsertCommand();
    void slotAbort();
    void applyConfig( InsertCommandConfigPage* );

  private slots:
    void slotReceivedStdout(KProcess*, char*, int);
    void slotReceivedStderr(KProcess*, char*, int);
    void slotProcessExited(KProcess*);
    void slotShowWaitDlg();
};

class CmdPrompt : public KDialogBase
{
  public:
    CmdPrompt(QWidget* parent=0,
              const char* name=0,
              const QStringList& cmdhist=QStringList(),
              const QString& dir=QString::null,
              const QString& docdir=QString::null,
              int   settings=0);
    ~CmdPrompt();
    QString command() { return cmb_cmd->currentText(); }
    bool insertStdErr() { return cb_insStdErr->isChecked(); }
    bool printCmd() { return cb_printCmd->isChecked(); }
    QString wd() { return wdreq->url(); }

  private:
    KHistoryCombo *cmb_cmd;
    KURLRequester *wdreq;
    QCheckBox *cb_insStdErr;
    QCheckBox *cb_printCmd;

};

class WaitDlg : public KDialogBase
{
  public:
    WaitDlg(QWidget* parent, const QString& text=QString::null, const QString& title=QString(i18n("Please Wait")));
    ~WaitDlg();
};

/** Config page for the plugin. */
class InsertCommandConfigPage : public Kate::PluginConfigPage
{
  Q_OBJECT
  friend class PluginKateInsertCommand;

  public:
    InsertCommandConfigPage(QObject* parent = 0L, QWidget *parentWidget = 0L);
    ~InsertCommandConfigPage() {};

    /** Reimplemented from Kate::PluginConfigPage
     * just emits configPageApplyRequest( this ).
     */
    void applyConfig();

  signals:
    /** Ask the plugin to set initial values */
    void configPageApplyRequest( InsertCommandConfigPage* );
    /** Ask the plugin to apply changes */
    void configPageInitRequest( InsertCommandConfigPage* );

  protected:
    QSpinBox *sb_cmdhistlen;
    //QCheckBox *cb_startindocdir;
    QButtonGroup *rg_startin;
};

#endif // _PLUGIN_KATE_INSERT_COMMAND_H_
