////////////////////////////////////////////////////////////////////////////////
// $Id: pkgOptions.h,v 1.5 2001/09/26 16:33:31 mlaurent Exp $
// File  : pkgOptions.h
// Author: Toivo Pedaste
//
// This provides the installation options, plus the install and cancel
// buttons.  When the install button is clicked, the current package
// is installed.
/////////////////////////////

#ifndef PKGINSTALL_OPTIONS
#define PKGINSTALL_OPTIONS

#include "../config.h"
// Qt headers
#include <qframe.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <kdialog.h>

// kpackage headers
#include "packageInfo.h"
#include "pkgInterface.h"
#include "kpTerm.h"

class KListView;

class pkgOptions : public KDialog
{
  Q_OBJECT;
public:
  pkgOptions( pkgInterface *pki, QWidget *parent=0);
  ~pkgOptions();

  void setup(QPtrList<packageInfo> *pl, QString type);
  void setup(packageInfo *p, QString type);
  void reset();

  virtual QString doPackages(int installFlags, QPtrList<packageInfo> *p,
			     bool &test) = 0;

  QCheckBox **Boxs;
  // options buttons

  KListView *packages;

  int bnumber;
  // number of option buttons

  QLabel *title;
  // Widget title

  kpTerm *term;

  pkgInterface *pkgInt;

  bool notModified;
  bool test;
  bool running;

protected:
  // This sets up the sub-widgets
  void setupWidgets(QPtrList<param> &pars);

private slots:  
  virtual void pkginstallButtonClicked();
  virtual void cancelButtonClicked();
  void slotSearch(QListViewItem *item);

public slots:
 void slotResult(QStringList &rlist, int ret);

signals:
  // This signal indicates that the widget has finished.
  void finished(int refresh);

protected:
  // The layout managers
  QBoxLayout *layout, *hlayout, *vlayout;

  // Sub widgets
  QPushButton *installButton, *cancelButton;

  QString insType;
  bool installer;
  // install or uninstall

  QPtrList<packageInfo> *packList;
};


///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
class pkgOptionsI: public pkgOptions
{
  Q_OBJECT;
public:
  pkgOptionsI(pkgInterface *pkg, QWidget *parent = 0);
  QString doPackages(int installFlags, QPtrList<packageInfo> *p, bool &test);
};

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
class pkgOptionsU: public pkgOptions
{
  Q_OBJECT;
public:
  pkgOptionsU(pkgInterface *pkg, QWidget *parent = 0);
  QString doPackages(int installFlags, QPtrList<packageInfo> *p, bool &test);
};

#endif
