#include "Logging.moc"
#include "AddRCPT.h"
#include <qlabel.h>
#include <kapplication.h>
#include <klocale.h>
#include <qwhatsthis.h>

Logging::Logging(QWidget *parent, const char *name): QWidget(parent,name)
{
	int x=5, y=0;
	int w=640, h=380;
	ftpxs=0;

	int afterLogX, anonX, guestX, realX, mailX, mailLBX;
	int cmdY, tfY, secY;

	QLabel *lbl1=new QLabel(i18n("Log commands:"), this);
	QWhatsThis::add(lbl1, i18n("Use these check boxes to control for which types of users all commands will be logged."));	
	cmdY=y;	lbl1->move(x,cmdY);
	lbl1->resize(lbl1->sizeHint().width(),lbl1->height());
	y+=lbl1->height();
	afterLogX=lbl1->width();
	QLabel *lbl2=new QLabel(i18n("Log transfers:"), this);
	QWhatsThis::add(lbl2, i18n("Use these check boxes to control for which types of users file transfers will be logged."));	
	tfY=y; lbl2->move(x,tfY);
	lbl2->resize(lbl2->sizeHint().width(),lbl2->height());
	y+=lbl2->height();
	QLabel *lbl3=new QLabel(i18n("Inbound:"), this);
	QWhatsThis::add(lbl1, i18n("Log inbound transfers (uploads to this server)"));	
	y+=lbl3->height();
	QLabel *lbl4=new QLabel(i18n("Outbound:"), this);
	QWhatsThis::add(lbl4, i18n("Log outbound transfers (downloads from this server)"));
	QLabel *lbl5=new QLabel(i18n("Security log:"), this);
	QWhatsThis::add(lbl5, i18n("Log security-related messages (failed logins etc.)"));
	secY=y; lbl5->move(x,secY);
	lbl5->resize(lbl5->sizeHint().width(),lbl5->height());
	y+=lbl5->height();
	if(lbl5->width()>afterLogX)
		afterLogX=lbl5->width();
	afterLogX+=5;
	if(lbl3->width()<lbl4->width())
		anonX=afterLogX+lbl4->width()+5;
	else
		anonX=afterLogX+lbl3->width()+5;
	lbl3->move(afterLogX,tfY);
	lbl4->move(afterLogX,tfY+lbl3->height());
	
	logCommandsAnon=new QCheckBox(i18n("A&nonymous"),this);
	QWhatsThis::add(logCommandsAnon, i18n("Log commands given by anonymous (username <i>ftp</i> or <i>anonymous</i>) users."));
	logCommandsAnon->move(anonX,cmdY);
	guestX=anonX+5+logCommandsAnon->width();
	logCommandsGuest=new QCheckBox(i18n("&Guest"),this);
	QWhatsThis::add(logCommandsGuest, i18n("Log commands given by guest users (users with a real account, but restricted access)."));
	logCommandsGuest->move(guestX,cmdY);
	realX=guestX+5+logCommandsGuest->width();
	logCommandsReal=new QCheckBox(i18n("&Real"),this);
	QWhatsThis::add(logCommandsReal, i18n("Log commands given by real users (users with an unrestricted account on the server"));
	logCommandsReal->move(realX,cmdY);
	y=tfY;
	logTransfersAnonIn=new QCheckBox(i18n("An&onymous"),this);
	QWhatsThis::add(logTransfersAnonIn, i18n("Log inbound transfers (uploads to the server) by anonymous users (username <i>ftp</i> or <i>anonymous</i>)"));
	logTransfersAnonIn->move(anonX,y);
	logTransfersGuestIn=new QCheckBox(i18n("G&uest"),this);
	QWhatsThis::add(logTransfersGuestIn, i18n("Log inbound transfers (uploads to the server) by guest users (users with a real account, but restricted access)"));
	logTransfersGuestIn->move(guestX,y);
	logTransfersRealIn=new QCheckBox(i18n("R&eal"),this);
	QWhatsThis::add(logTransfersRealIn, i18n("Log inbound transfers (uploads to the server) by real users (users with a real account and without restrictions)"));
	logTransfersRealIn->move(realX,y);
	y+=lbl3->height();
	logTransfersAnonOut=new QCheckBox(i18n("Anon&ymous"),this);
	QWhatsThis::add(logTransfersAnonOut, i18n("Log outbound transfers (downloads from the server) by anonymous users (username <i>ftp</i> or <i>anonymous</i>)"));
	logTransfersAnonOut->move(anonX,y);
	logTransfersGuestOut=new QCheckBox(i18n("Gue&st"),this);
	QWhatsThis::add(logTransfersGuestOut, i18n("Log outbound transfers (downloads from the server) by guest users (users with a real account, but restricted access)"));
	logTransfersGuestOut->move(guestX,y);
	logTransfersRealOut=new QCheckBox(i18n("Re&al"),this);
	QWhatsThis::add(logTransfersRealOut, i18n("Log outbound transfers (downloads from the server) by real users (users with a real account and without restrictions)"));
	logTransfersRealOut->move(realX,y);
	logSecurityAnon=new QCheckBox(i18n("Anony&mous"),this);
	logSecurityAnon->move(anonX,secY);
	QWhatsThis::add(logSecurityAnon, i18n("Keep a security log (failed login attempts etc.) for anonymous users (username <i>anonymous</i> or <i>ftp</i>)"));
	logSecurityGuest=new QCheckBox(i18n("Gues&t"),this);
	logSecurityGuest->move(guestX,secY);
	QWhatsThis::add(logSecurityGuest, i18n("Keep a security log (failed login attempts etc.) for guest users (real users with restricted access)"));
	logSecurityReal=new QCheckBox(i18n("Rea&l"),this);
	logSecurityReal->move(realX,secY);
	QWhatsThis::add(logSecurityReal, i18n("Keep a security log (failed login attempts etc.) for guest users (real users with unrestricted access)"));
	logSyslog=new QCheckBox(i18n("Redirect lo&g to syslog"),this);
	logSyslog->move(x,secY+lbl5->height());
	logSyslog->resize(logSyslog->sizeHint().width(),logSyslog->height());
	QWhatsThis::add(logSyslog, i18n("Log to syslog instead of logfiles"));
	x=5;y=logSyslog->y()+logSyslog->height();
	mailAdmin=new QCheckBox(i18n("E&mail ftpadmin on uploads:"),this);
	QWhatsThis::add(mailAdmin, i18n("Automatically notify the administrator of uploads from anonymous users"));
	mailAdmin->setGeometry(x,y,mailAdmin->sizeHint().width(),mailAdmin->height());
	connect(mailAdmin,SIGNAL(clicked()),SLOT(mailAdminPressed()));
	mailX=x+mailAdmin->width();
	mailFrom=new InputCtl(i18n("&Send mail as"),0,this);
	mailFrom->setGeometry(mailX,y,w-mailX-5,mailFrom->height()); y+=mailFrom->height();
	QWhatsThis::add(mailFrom, i18n("The address entered here will appear in the <i>From:</i> header of upload notification email messages sent by wu-ftpd."));
	mailServer=new InputCtl(i18n("Mail ser&ver"),0,this);
	mailServer->setGeometry(mailX,y,w-mailX-5,mailFrom->height()); y+=mailServer->height();
	QWhatsThis::add(mailServer, i18n("The mail server entered here will be used to transmit upload notification email messages sent by wu-ftpd. If left blank, localhost will be used."));
	QLabel *lbl6=new QLabel(i18n("&Send mail to:"),this);
	QWhatsThis::add(lbl6, i18n("This list box shows the recipient(s) of upload notification emails. Use the <b>Add</b> and <b>Remove</b> buttons below to modify the recipients."));
	mailRecipients=new QListBox(this); lbl6->setBuddy(mailRecipients);
	QWhatsThis::add(mailRecipients, i18n("This list box shows the recipient(s) of upload notification emails. Use the <b>Add</b> and <b>Remove</b> buttons below to modify the recipients."));
	lbl6->setGeometry(mailX,y,lbl6->sizeHint().width(),lbl6->height());
	mailLBX=mailX+lbl6->width();
	mailRecipients->setGeometry(mailLBX,y,w-mailLBX-5,h-y-3*lbl6->height());
	y+=mailRecipients->height();
	addRecipient=new QPushButton(i18n("&Add"),this);
	addRecipient->setGeometry(mailLBX,y,(w-mailLBX-5)/2,addRecipient->height());
	QWhatsThis::add(addRecipient, i18n("Add a new recipient for upload notification emails"));
	connect(addRecipient,SIGNAL(clicked()),SLOT(addRecipientPressed()));
	rmRecipient=new QPushButton(i18n("&Remove"),this);
	rmRecipient->setGeometry(mailLBX+(w-mailLBX-5)/2,y,(w-mailLBX-5)/2,rmRecipient->height());
	QWhatsThis::add(rmRecipient, i18n("Remove the currently selected recipient for upload notification emails"));
	connect(rmRecipient,SIGNAL(clicked()),SLOT(rmRecipientPressed()));
	mailAdminPressed();
}
Logging::~Logging()
{
}
void Logging::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	logSyslog->setChecked(ftpxs->getLogSyslog());
	logCommandsAnon->setChecked((ftpxs->getLogCommands()&ANONYMOUS)!=0);
	logCommandsGuest->setChecked((ftpxs->getLogCommands()&GUEST)!=0);
	logCommandsReal->setChecked((ftpxs->getLogCommands()&REAL)!=0);
	logSecurityAnon->setChecked((ftpxs->getLogSecurity()&ANONYMOUS)!=0);
	logSecurityGuest->setChecked((ftpxs->getLogSecurity()&GUEST)!=0);
	logSecurityReal->setChecked((ftpxs->getLogSecurity()&REAL)!=0);
	logTransfersAnonIn->setChecked((ftpxs->getLogTransfers()&ANONYMOUS)!=0);
	logTransfersGuestIn->setChecked((ftpxs->getLogTransfers()&GUEST)!=0);
	logTransfersRealIn->setChecked((ftpxs->getLogTransfers()&REAL)!=0);
	logTransfersAnonOut->setChecked((ftpxs->getLogTransfers()&ANONYMOUS_OUT)!=0);
	logTransfersGuestOut->setChecked((ftpxs->getLogTransfers()&GUEST_OUT)!=0);
	logTransfersRealOut->setChecked((ftpxs->getLogTransfers()&REAL_OUT)!=0);
	mailAdmin->setChecked(ftpxs->getMailAdmin());
	mailFrom->setText(ftpxs->getMailFrom());
	mailServer->setText(ftpxs->getMailServer());
	mailAdminPressed();
	redraw();
}
void Logging::mailAdminPressed()
{
	mailFrom->setEnabled(mailAdmin->isChecked());
	mailServer->setEnabled(mailAdmin->isChecked());
	mailRecipients->setEnabled(mailAdmin->isChecked());
	addRecipient->setEnabled(mailAdmin->isChecked());
	rmRecipient->setEnabled(mailAdmin->isChecked());
}
void Logging::addRecipientPressed()
{
	AddRCPT *a=new AddRCPT;
	connect(a,SIGNAL(RCPTAdded(QString)),SLOT(RCPTAdded(QString)));
}
void Logging::rmRecipientPressed()
{
	QStringList *list = ftpxs->getMailRecipients();
	for(unsigned int i=0;i<mailRecipients->count();i++)
		if(mailRecipients->isSelected(i)) {
			mailRecipients->removeItem(i);
			list->remove(list->at(i));
		}
}
void Logging::RCPTAdded(QString rcpt)
{
	mailRecipients->insertItem(rcpt);
	ftpxs->getMailRecipients()->append(rcpt);
}
void Logging::redraw()
{
	mailRecipients->clear();
	mailRecipients->insertStringList(*ftpxs->getMailRecipients());
	mailRecipients->update();
}
void Logging::update()
{
	ftpxs->setLogSyslog(logSyslog->isChecked());
	ftpxs->setLogCommands(ANONYMOUS*logCommandsAnon->isChecked()+GUEST*logCommandsGuest->isChecked()+REAL*logCommandsReal->isChecked());
	ftpxs->setLogSecurity(ANONYMOUS*logSecurityAnon->isChecked()+GUEST*logSecurityGuest->isChecked()+REAL*logSecurityReal->isChecked());
	ftpxs->setLogTransfers(ANONYMOUS*logTransfersAnonIn->isChecked()+GUEST*logTransfersGuestIn->isChecked()+REAL*logTransfersRealIn->isChecked()+ANONYMOUS_OUT*logTransfersAnonOut->isChecked()+GUEST_OUT*logTransfersGuestOut->isChecked()+REAL_OUT*logTransfersRealOut->isChecked());
	ftpxs->setMailAdmin(mailAdmin->isChecked());
	if(mailAdmin->isChecked()) {
		ftpxs->setMailFrom(mailFrom->text());
		ftpxs->setMailServer(mailServer->text());
	}
}
