/*****************************************************************

Copyright (c) 1996-2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qtooltip.h>
#include <qdragobject.h>

#include <kconfig.h>
#include <kdesktopfile.h>
#include <kapplication.h>
#include <kglobal.h>
#include <krun.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kiconeffect.h>
#include <kdebug.h>

#include "exe_dlg.h"

#include "nonkdeappbutton.h"
#include "nonkdeappbutton.moc"

NonKDEAppButton::NonKDEAppButton( const QString& filePath, const QString& icon,
   const QString &cmdLine, bool inTerm, QWidget* parent )
  : PanelButton( parent, "NonKDEAppButton" )
{
    initialize( filePath, icon, cmdLine, inTerm );
}

NonKDEAppButton::NonKDEAppButton( const KConfigGroup& config, QWidget* parent )
  : PanelButton( parent, "NonKDEAppButton" )
{
    initialize(
        config.readEntry("Path"),
        config.readEntry("Icon"),
        config.readEntry("CommandLine"),
        config.readBoolEntry("RunInTerminal") );
}

void NonKDEAppButton::initialize( const QString& filePath, const QString& icon,
   const QString &cmdLine, bool inTerm )
{
    pathStr = filePath;
    iconStr = icon;
    cmdStr = cmdLine;
    term = inTerm;

    QToolTip::add(this, pathStr + " " + cmdStr);
    setTitle(pathStr);
    setIcon(iconStr);

    connect(this, SIGNAL(clicked()), SLOT(slotExec()));
}

void NonKDEAppButton::saveConfig( KConfigGroup& config ) const
{
    config.writeEntry("RunInTerminal", term);
    config.writeEntry("Path", pathStr);
    config.writeEntry("Icon", iconStr);
    config.writeEntry("CommandLine", cmdStr);
}

void NonKDEAppButton::dragEnterEvent(QDragEnterEvent *ev)
{
    if (QUriDrag::canDecode(ev))
	ev->accept(rect());
    PanelButton::dragEnterEvent(ev);
}

void NonKDEAppButton::dropEvent(QDropEvent *ev)
{
  QStrList fileList;
  QStringList blah;
  QString execStr;
  if(QUriDrag::decode(ev, fileList)){
    QStrListIterator it(fileList);
    for(;it.current(); ++it){
      KURL url(it.current());
      if(KDesktopFile::isDesktopFile(url.path())){
        KDesktopFile deskFile(url.path());
        deskFile.setDesktopGroup();
        execStr += deskFile.readURL() + " ";
      }
      else
        execStr += url.path() + " ";
    }
    bool result;
    kapp->propagateSessionManager();
    if(term){
      KConfig *config = KGlobal::config();
      config->setGroup("misc");
      QString termStr = config->readEntry("Terminal", "konsole");
      result = KRun::run(termStr + " -e " + pathStr + " " +
                         cmdStr + " " + execStr, blah);

    }
    else
      result = KRun::run(pathStr + " " + cmdStr + " " + execStr, blah);

    if(!result)
      KMessageBox::error(this, i18n("Cannot execute non-KDE application!"),
                         i18n("Kicker Error!"));
  }
  PanelButton::dropEvent(ev);
}

void NonKDEAppButton::slotExec()
{
  KIconEffect::visualActivate(this, rect());
  QStringList blah;
  bool result;
  kapp->propagateSessionManager();
  if(term){
    KConfig *config = KGlobal::config();
    config->setGroup("misc");
    QString termStr = config->readEntry("Terminal", "konsole");
    result = KRun::run(termStr + " -e " + pathStr + " " + cmdStr, blah);
  }
  else
    result = KRun::run(pathStr + " " + cmdStr, blah);
  if(!result)
    KMessageBox::error(this, i18n("Cannot execute non-KDE application!"),
                       i18n("Kicker Error!"));
}

void NonKDEAppButton::properties()
{
  PanelExeDialog dlg(pathStr, iconStr, cmdStr, term, this);
  if(dlg.exec() == QDialog::Accepted){
    iconStr = dlg.icon();
    cmdStr = dlg.commandLine();
    term = dlg.useTerminal();
    setIcon(iconStr);
    emit requestSave();
  }
}
