/***************************************************************************
                            kde_KCompletion.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCOMPLETION
#define KDE_KCOMPLETION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class offers easy use of "auto-completion", "manual-completion" or
 "shell completion" on QString objects. A common use is completing filenames
 or URLs (see @ref KURLCompletion()).
 But it is not limited to URL-completion -- everything should be completable!
 The user should be able to complete email-addresses, telephone-numbers,
 commands, SQL queries, ...
 Every time your program knows what the user can type into an edit-field, you
 should offer completion. With KCompletion, this is very easy, and if you are
 using a line edit widget (@ref KLineEdit), it is even more easy.
 Basically, you tell a KCompletion object what strings should be completable
 and whenever completion should be invoked, you call @ref makeCompletion().
 KLineEdit and (an editable) KComboBox even do this automatically for you.

 KCompletion offers the completed string via the signal @ref match() and
 all matching strings (when the result is ambiguous) via the method
 @ref allMatches().

 Notice: auto-completion, shell completion and manual completion work
         slightly differently:

 You don't have to worry much about that though, KCompletion handles
 that for you, according to the setting @ref setCompletionMode().
 The default setting is globally configured by the user and read
 from @ref KGlobalSettings::completionMode().

 A short example:
 <pre>
 KCompletion completion;
 completion.setOrder( KCompletion::Sorted );
 completion.addItem( "pfeiffer@kde.org" );
 completion.addItem( "coolo@kde.org" );
 completion.addItem( "carpdjih@sp.zrz.tu-berlin.de" );
 completion.addItem( "carp@cs.tu-berlin.de" );

 cout << completion.makeCompletion( "ca" ).latin1() << endl;
 </pre>
 In shell-completion-mode, this will be "carp"; in auto-completion-
 mode it will be "carp@cs.tu-berlin.de", as that is alphabetically
 smaller.
 If setOrder was set to Insertion, "carpdjih@sp.zrz.tu-berlin.de"
 would be completed in auto-completion-mode, as that was inserted before
 "carp@cs.tu-berlin.de".

 You can dynamically update the completable items by removing and adding them
 whenever you want.
 For advanced usage, you could even use multiple KCompletion objects. E.g.
 imagine an editor like kwrite with multiple open files. You could store
 items of each file in a different KCompletion object, so that you know (and
 tell the user) where a completion comes from.

 Note: KCompletion does not work with strings that contain 0x0 characters
       (unicode nul), as this is used internally as a delimiter.

 You may inherit from KCompletion and override @ref makeCompletion() in
 special cases (like reading directories/urls and then supplying the
 contents to KCompletion, as KURLCompletion does), but generally, this is
 not necessary.

 @author Carsten Pfeiffer <pfeiffer@kde.org>

 @version $Id: kde_KCompletion.h,v 1.3 2002/02/21 00:43:09 rdale Exp $
 
 @short A generic class for completing QStrings.
*/
#define KCOMPLETION_Sorted	0
#define KCOMPLETION_Insertion	1
#define KCOMPLETION_Weighted	2

/** 
 Constructor, nothing special here :)
     
*/
kde_KCompletion * kde_new_KCompletion();

/** 
 Destructor, nothing special here, either.
     
*/
void kde_del_KCompletion( kde_KCompletion* p );

/** 
 Attempts to find an item in the list of available completions,
 that begins with @p string. Will either return the first matching item
 (if there is more than one match) or QString::null, if no match was
 found.

 In the latter case, a sound will be issued, depending on
 @ref isSoundsEnabled().
 If a match was found, it will also be emitted via the signal
 @ref match().

 If this is called twice or more often with the same string while no
 items were added or removed in the meantime, all available completions
 will be emitted via the signal @ref matches().
 This happens only in shell-completion-mode.

*/
qt_QString * kde_KCompletion_makeCompletion(kde_KCompletion* instPointer,qt_QString * string);

/** 

*/
qt_QStringList* kde_KCompletion_substringCompletion(kde_KCompletion* instPointer,qt_QString * string);

/** 

*/
qt_QString * kde_KCompletion_previousMatch(kde_KCompletion* instPointer);

/** 

*/
qt_QString * kde_KCompletion_nextMatch(kde_KCompletion* instPointer);

/** 

*/
qt_QString * kde_KCompletion_lastMatch(kde_KCompletion* instPointer);

/** 
 Returns a list of all items inserted into KCompletion. This is useful
 if you need to save the state of a KCompletion object and restore it
 later.

 Important note: when @ref order() == Weighted, then every item in the
 stringlist has its weight appended, delimited by a colon. E.g. an item
 "www.kde.org" might look like "www.kde.org:4", where 4 is the weight.

 This is necessary so that you can save the items along with its
 weighting on disk and load them back with @ref setItems(), restoring its
 weight as well. If you really don't want the appended weightings, call
 @ref setOrder( KCompletion::Insertion )
 before calling items().

*/
qt_QStringList* kde_KCompletion_items(kde_KCompletion* instPointer);

/** 
 Sets the completion mode to Auto/Manual, Shell or None.
 If you don't set the mode explicitly, the global default value
 KGlobalSettings::completionMode() is used.
 @ref KGlobalSettings::CompletionNone disables completion.

*/
void kde_KCompletion_setCompletionMode(kde_KCompletion* instPointer,int mode);

/** 

*/
int kde_KCompletion_completionMode(kde_KCompletion* instPointer);

/** 
 KCompletion offers three different ways in which it offers its items:

 Choosing weighted makes KCompletion perform an implicit weighting based
 on how often an item is inserted. Imagine a web browser with a location
 bar, where the user enters URLs. The more often a URL is entered, the
 higher priority it gets.

 Note: Setting the order to sorted only affects new inserted items,
 already existing items will stay in the current order. So you probably
 want to call setOrder( Sorted ) before inserting items, when you want
 everything sorted.

 Default is insertion order

*/
void kde_KCompletion_setOrder(kde_KCompletion* instPointer,int order);

/** 

*/
int kde_KCompletion_order(kde_KCompletion* instPointer);

/** 
 Setting this to true makes KCompletion behave case insensitively.
 E.g. makeCompletion( "CA" ); might return "carp@cs.tu-berlin.de".
 Default is false (case sensitive).

*/
void kde_KCompletion_setIgnoreCase(kde_KCompletion* instPointer,int ignoreCase);

/** 

*/
int kde_KCompletion_ignoreCase(kde_KCompletion* instPointer);

/** 

*/
qt_QStringList* kde_KCompletion_allMatches(kde_KCompletion* instPointer);

/** 

*/
qt_QStringList* kde_KCompletion_allMatches1(kde_KCompletion* instPointer,qt_QString * string);

/** 

*/
//KCompletionMatches kde_KCompletion_allWeightedMatches(kde_KCompletion* instPointer);

/** 

*/
//KCompletionMatches kde_KCompletion_allWeightedMatches1(kde_KCompletion* instPointer,qt_QString * string);

/** 
 Enables/disables playing a sound when

 For playing the sounds, @ref KNotifyClient() is used.

*/
void kde_KCompletion_setEnableSounds(kde_KCompletion* instPointer,int enable);

/** 
 Tells you whether KCompletion will play sounds on certain occasions.
 Default is enabled

*/
int kde_KCompletion_isSoundsEnabled(kde_KCompletion* instPointer);

/** 

*/
int kde_KCompletion_hasMultipleMatches(kde_KCompletion* instPointer);

/** 

*/
void kde_KCompletion_enableSounds(kde_KCompletion* instPointer);

/** 

*/
void kde_KCompletion_disableSounds(kde_KCompletion* instPointer);

/** 
 Attempts to complete "string" and emits the completion via @ref match().
 Same as @ref makeCompletion() (just as a slot).

*/
void kde_KCompletion_slotMakeCompletion(kde_KCompletion* instPointer,qt_QString * string);

/** 
 Searches the previous matching item and emits it via @ref match()
 Same as @ref previousMatch() (just as a slot).

*/
void kde_KCompletion_slotPreviousMatch(kde_KCompletion* instPointer);

/** 
 Searches the next matching item and emits it via @ref match()
 Same as @ref nextMatch() (just as a slot).

*/
void kde_KCompletion_slotNextMatch(kde_KCompletion* instPointer);

/** 
 Inserts @p items into the list of possible completions.
 Does the same as @ref setItems(), but does not call @ref clear() before.
     
*/
void kde_KCompletion_insertItems(kde_KCompletion* instPointer,qt_QStringList* items);

/** 
 Sets the list of items available for completion. Removes all previous
 items.

 Notice: when order() == Weighted, then the weighting is looked up for
 every item in the stringlist. Every item should have ":number" appended,
 where number is an unsigned integer, specifying the weighting.

 If you don't like this, call
 setOrder( KCompletion::Insertion )
 before calling setItems().

*/
void kde_KCompletion_setItems(kde_KCompletion* instPointer,qt_QStringList* arg1);

/** 
 Adds an item to the list of available completions.
 Resets the current item-state (@ref previousMatch() and @ref nextMatch()
 won't work anymore).
     
*/
void kde_KCompletion_addItem(kde_KCompletion* instPointer,qt_QString * arg1);

/** 
 Adds an item to the list of available completions.
 Resets the current item-state (@ref previousMatch() and @ref nextMatch()
 won't work anymore).

 Sets the weighting of the item to @p weight or adds it to the current
 weighting if the item is already available. The weight has to be greater
 than 1 to take effect (default weight is 1).
     
*/
void kde_KCompletion_addItem1(kde_KCompletion* instPointer,qt_QString * arg1, unsigned int weight);

/** 
 Removes an item from the list of available completions.
 Resets the current item-state (@ref previousMatch() and @ref nextMatch()
 won't work anymore).
     
*/
void kde_KCompletion_removeItem(kde_KCompletion* instPointer,qt_QString * arg1);

/** 
 Removes all inserted items.
     
*/
void kde_KCompletion_clear(kde_KCompletion* instPointer);

/** 
 This method is called after a completion is found and before the
 matching string is emitted. You can override this method to modify the
 string that will be emitted.
 This is necessary e.g. in @ref KURLCompletion(), where files with spaces
 in their names are shown escaped ("filename\ with\ spaces"), but stored
 unescaped inside KCompletion.
 Never delete that pointer!

 Default implementation does nothing.

*/
void kde_KCompletion_postProcessMatch(kde_KCompletion* instPointer,qt_QString* arg1);

/** 
 This method is called before a list of all available completions is
 emitted via @ref matches. You can override this method to modify the
 found items before @ref match() or @ref matches() are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
void kde_KCompletion_postProcessMatches(kde_KCompletion* instPointer,qt_QStringList* arg1);

/** 
 This method is called before a list of all available completions is
 emitted via @ref matches. You can override this method to modify the
 found items before @ref match() or @ref matches() are emitted.
 Never delete that pointer!

 Default implementation does nothing.

*/
//void kde_KCompletion_postProcessMatches1(kde_KCompletion* instPointer,KCompletionMatches* arg1);

#endif
