/***************************************************************************
                            kde_KDEsuClient.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDESUCLIENT
#define KDE_KDESUCLIENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A client class to access kdesud, the KDE su daemon. Kdesud can assist in 
 password caching in two ways:

 @short 
 A client class to access kdesud, the KDE su daemon.
*/
kde_KDEsuClient * kde_new_KDEsuClient();
void kde_del_KDEsuClient( kde_KDEsuClient* p );

/** 
 Lets kdesud execute a command. If the daemon does not have a password
 for this command, this will fail and you need to call @ref #setPass().

*/
//int kde_KDEsuClient_exec(kde_KDEsuClient* instPointer,qt_QCString* command, qt_QCString* user, qt_QCString* options, QCStringList env);

/** 
 Set root's password, lasts one session.

*/
int kde_KDEsuClient_setPass(kde_KDEsuClient* instPointer,char* pass, int timeout);

/** 
 Set the target host (optional).
     
*/
int kde_KDEsuClient_setHost(kde_KDEsuClient* instPointer,qt_QCString* host);

/** 
 Set the desired priority (optional), see @ref #StubProcess.
     
*/
int kde_KDEsuClient_setPriority(kde_KDEsuClient* instPointer,int priority);

/** 
 Set the desired scheduler (optional), see @ref #StubProcess.
     
*/
int kde_KDEsuClient_setScheduler(kde_KDEsuClient* instPointer,int scheduler);

/** 
 Remove a password for a user/command.

*/
int kde_KDEsuClient_delCommand(kde_KDEsuClient* instPointer,qt_QCString* command, qt_QCString* user);

/** 
 Set a persistent variable.

*/
int kde_KDEsuClient_setVar(kde_KDEsuClient* instPointer,qt_QCString* key, qt_QCString* value, int timeout, qt_QCString* group);

/** 
 Get a persistent variable.

*/
qt_QCString* kde_KDEsuClient_getVar(kde_KDEsuClient* instPointer,qt_QCString* key);

/** 
 Returns true if the specified group exists is
 cached.

*/
int kde_KDEsuClient_findGroup(kde_KDEsuClient* instPointer,qt_QCString* group);

/** 
 Delete a persistent variable.

*/
int kde_KDEsuClient_delVar(kde_KDEsuClient* instPointer,qt_QCString* key);

/** 
 Delete all persistent variables with the given key.

 A specicalized variant of @ref delVar(QCString) that removes all
 subsets of the cached varaibles given by @p key. In order for all
 cached variables related to this key to be deleted properly, the
 value given to the @p group argument when the @ref setVar function
 was called, must be a subset of the argument given here and the key

 <u>NOTE:</u> Simply supplying the group key here WILL not necessarily
 work. If you only have a group key, then use @ref delGroup instead.

*/
int kde_KDEsuClient_delVars(kde_KDEsuClient* instPointer,qt_QCString* special_key);

/** 
 Delete all persistent variables in a group.

*/
int kde_KDEsuClient_delGroup(kde_KDEsuClient* instPointer,qt_QCString* group);

/** 
 Ping kdesud. This can be used for diagnostics.

*/
int kde_KDEsuClient_ping(kde_KDEsuClient* instPointer);

/**  Stop the daemon.  
*/
int kde_KDEsuClient_stopServer(kde_KDEsuClient* instPointer);

/**  Try to start up kdesud 
*/
int kde_KDEsuClient_startServer(kde_KDEsuClient* instPointer);

/**  Returns true if the server is safe (installed setgid), false otherwise. 
*/
int kde_KDEsuClient_isServerSGID(kde_KDEsuClient* instPointer);

#endif
