/***************************************************************************
                            kde_KGlobalSettings.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGLOBALSETTINGS
#define KDE_KGLOBALSETTINGS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Access the KDE global configuration.

 @author David Faure <faure@kde.org>

 @version $Id: kde_KGlobalSettings.h,v 1.4 2002/03/15 01:26:11 rdale Exp $
 
 @short 
 Access the KDE global configuration.
*/
#define KGLOBALSETTINGS_CompletionNone	1
#define KGLOBALSETTINGS_CompletionAuto	0
#define KGLOBALSETTINGS_CompletionMan	1
#define KGLOBALSETTINGS_CompletionShell	2
#define KGLOBALSETTINGS_CompletionPopup	3

/** 
 Returns a threshold in pixels for drag & drop operations.
 As long as the mouse movement has not exceeded this number
 of pixels in either X or Y direction no drag operation may
 be started. This prevents spurious drags when the user intended
 to click on something but moved the mouse a bit while doing so.

 For this to work you must save the position of the mouse (oldPos)
 in the @ref QWidget::mousePressEvent().
 When the position of the mouse (newPos)
 in a  @ref QWidget::mouseMoveEvent() exceeds this threshold
 you may start a drag
 which should originate from oldPos.

 Example code:
 <pre>
 void KColorCells::mousePressEvent( QMouseEvent *e )
 {
    mOldPos = e->pos();
 }

 void KColorCells::mouseMoveEvent( QMouseEvent *e )
 {
    if( !(e->state() && LeftButton)) return;

    int delay = KGlobalSettings::dndEventDelay();
    QPoint newPos = e->pos();
    if(newPos.x() > mOldPos.x()+delay || newPos.x() < mOldPos.x()-delay ||
       newPos.y() > mOldPos.y()+delay || newPos.y() < mOldPos.y()-delay)
    {
       // Drag color object
       int cell = posToCell(mOldPos); // Find color at mOldPos
       if ((cell != -1) && colors[cell].isValid())
       {
          KColorDrag *d = KColorDrag::makeDrag( colors[cell], this);
          d->dragCopy();
       }
    }
 }
 </pre>

     
*/
int kde_KGlobalSettings_dndEventDelay( );

/** 
 Returns whether KDE runs in single (default) or double click
 mode.

 see @ref http://developer.kde.org/documentation/standards/kde/style/mouse/index.html

*/
int kde_KGlobalSettings_singleClick( );

/** 
 Returns whether tear-off handles are inserted in KPopupMenus.

*/
int kde_KGlobalSettings_insertTearOffHandle( );

/** 

*/
int kde_KGlobalSettings_changeCursorOverIcon( );

/** 

*/
int kde_KGlobalSettings_visualActivate( );
unsigned int kde_KGlobalSettings_visualActivateSpeed( );

/** 
 Returns the KDE setting for the auto-select option

*/
int kde_KGlobalSettings_autoSelectDelay( );

/** 
 Returns the KDE setting for the shortcut key to open
 context menus.

*/
int kde_KGlobalSettings_contextMenuKey( );

/** 
 Returns the KDE setting for context menus.

*/
int kde_KGlobalSettings_showContextMenusOnPress( );

/** 
 Returns the preferred completion mode setting.

*/
int kde_KGlobalSettings_completionMode( );

/** 
 This returns the current mouse settings.
     
*/
//KMouseSettings& kde_KGlobalSettings_mouseSettings( );

/** 
 The path to the desktop directory of the current user.
     
*/
qt_QString * kde_KGlobalSettings_desktopPath( );

/** 
 The path to the autostart directory of the current user.
     
*/
qt_QString * kde_KGlobalSettings_autostartPath( );

/** 
 The path to the trash directory of the current user.
     
*/
qt_QString * kde_KGlobalSettings_trashPath( );

/** 
 The path where documents are stored of the current user.
     
*/
qt_QString * kde_KGlobalSettings_documentPath( );

/** 
 The default color to use when highlighting toolbar buttons
     
*/
qt_QColor * kde_KGlobalSettings_toolBarHighlightColor( );
qt_QColor * kde_KGlobalSettings_inactiveTitleColor( );
qt_QColor * kde_KGlobalSettings_inactiveTextColor( );
qt_QColor * kde_KGlobalSettings_activeTitleColor( );
qt_QColor * kde_KGlobalSettings_activeTextColor( );
int kde_KGlobalSettings_contrast( );

/** 
 The default colors to use for text and links.
     
*/
qt_QColor * kde_KGlobalSettings_baseColor( );
qt_QColor * kde_KGlobalSettings_textColor( );
qt_QColor * kde_KGlobalSettings_linkColor( );
qt_QColor * kde_KGlobalSettings_visitedLinkColor( );
qt_QColor * kde_KGlobalSettings_highlightedTextColor( );
qt_QColor * kde_KGlobalSettings_highlightColor( );

/** 
 Returns the alternate background color used by @ref KListView with
 @ref KListViewItem. Any other list that uses alternating background
 colors should use this too, to obey to the user's preferences. Returns
 an invalid color if the user doesn't want alternating backgrounds.

*/
qt_QColor * kde_KGlobalSettings_alternateBackgroundColor( );

/** 
 Calculates a color based on @p base to be used as alternating
 color for e.g. listviews.

*/
qt_QColor * kde_KGlobalSettings_calculateAlternateBackgroundColor( qt_QColor * base);
qt_QFont * kde_KGlobalSettings_generalFont( );
qt_QFont * kde_KGlobalSettings_fixedFont( );
qt_QFont * kde_KGlobalSettings_toolBarFont( );
qt_QFont * kde_KGlobalSettings_menuFont( );
qt_QFont * kde_KGlobalSettings_windowTitleFont( );
qt_QFont * kde_KGlobalSettings_taskbarFont( );

#endif
