/***************************************************************************
                            kde_KKeyChooser.h -  description
                             -------------------
    begin                : Tue Mar 19 20:11:49 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Tue Mar 19 20:11:49 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KKEYCHOOSER
#define KDE_KKEYCHOOSER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Configure dictionaries of key/action associations for KAccel and
 KGlobalAccel.

 The class takes care of all aspects of configuration, including
 handling key conflicts internally. Connect to the @ref allDefault()
 slot if you want to set all configurable shortcuts to their
 default values.

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: kde_KKeyChooser.h,v 1.4 2002/03/19 22:28:04 rdale Exp $

 @short Widget for configuration of @ref KAccel and @ref KGlobalAccel.

*/
#define KKEYCHOOSER_Application	0
#define KKEYCHOOSER_ApplicationGlobal	1
#define KKEYCHOOSER_Standard	2
#define KKEYCHOOSER_Global	3

/** 
 Constructor.

*/
kde_KKeyChooser * kde_new_KKeyChooser(qt_QWidget * parent, int type, int bAllowLetterShortcuts);
kde_KKeyChooser * kde_new_KKeyChooser1(kde_KActionCollection* coll, qt_QWidget * parent, int bAllowLetterShortcuts);
kde_KKeyChooser * kde_new_KKeyChooser2(kde_KAccel* actions, qt_QWidget * parent, int bAllowLetterShortcuts);
kde_KKeyChooser * kde_new_KKeyChooser3(kde_KGlobalAccel* actions, qt_QWidget * parent);
//kde_KKeyChooser * kde_new_KKeyChooser4(KShortcutList* arg1, qt_QWidget * parent, int type, int bAllowLetterShortcuts);
void kde_del_KKeyChooser( kde_KKeyChooser* p );

/** 
 Insert an action collection, i.e. add all its actions to the ones
 already associated with the KKeyChooser object.
	 
*/
int kde_KKeyChooser_insert(kde_KKeyChooser* instPointer,kde_KActionCollection* arg1);
void kde_KKeyChooser_syncToConfig(kde_KKeyChooser* instPointer,qt_QString * sConfigGroup, kde_KConfigBase* pConfig, int bClearUnset);

/** 
 This function writes any shortcut changes back to the original
 action set(s).
	 
*/
void kde_KKeyChooser_commitChanges(kde_KKeyChooser* instPointer);

/** 
 This commits and then saves the actions to disk.
 Any KActionCollection objects with the xmlFile() value set
 will be written to an xml file.  All other will be written
 to the application's rc file.
	 
*/
void kde_KKeyChooser_save(kde_KKeyChooser* instPointer);

/** 
 @obsolete
	 
*/
kde_KKeyChooser * kde_new_KKeyChooser5(kde_KAccel* actions, qt_QWidget * parent, int bCheckAgainstStdKeys, int bAllowLetterShortcuts, int bAllowWinKey);

/** 
 @obsolete
	 
*/
kde_KKeyChooser * kde_new_KKeyChooser6(kde_KGlobalAccel* actions, qt_QWidget * parent, int bCheckAgainstStdKeys, int bAllowLetterShortcuts, int bAllowWinKey);

/** 
 Set all keys to their default values (bindings).

*/
void kde_KKeyChooser_allDefault(kde_KKeyChooser* instPointer);

/** 
 Specifies whether to use the 3 or 4 modifier key scheme.
 This determines which default is used when the 'Default' button is
 clicked.
	 
*/
void kde_KKeyChooser_setPreferFourModifierKeys(kde_KKeyChooser* instPointer,int preferFourModifierKeys);

/** 
 Rebuild list entries based on underlying map.
 Use this if you changed the underlying map.
	 
*/
void kde_KKeyChooser_listSync(kde_KKeyChooser* instPointer);
#define KKEYCHOOSER_NoKey	1
#define KKEYCHOOSER_DefaultKey	0
#define KKEYCHOOSER_CustomKey	1
void kde_KKeyChooser_initGUI(kde_KKeyChooser* instPointer,int type, int bAllowLetterShortcuts);
int kde_KKeyChooser_insert1(kde_KKeyChooser* instPointer,kde_KAccel* arg1);
int kde_KKeyChooser_insert2(kde_KKeyChooser* instPointer,kde_KGlobalAccel* arg1);
//int kde_KKeyChooser_insert3(kde_KKeyChooser* instPointer,KShortcutList* arg1);
void kde_KKeyChooser_buildListView(kde_KKeyChooser* instPointer,unsigned int iList);
void kde_KKeyChooser_readGlobalKeys(kde_KKeyChooser* instPointer);
void kde_KKeyChooser_updateButtons(kde_KKeyChooser* instPointer);
void kde_KKeyChooser_fontChange(kde_KKeyChooser* instPointer,qt_QFont * _font);
void kde_KKeyChooser_setShortcut(kde_KKeyChooser* instPointer,kde_KShortcut* cut);
int kde_KKeyChooser_isKeyPresent(kde_KKeyChooser* instPointer,kde_KShortcut* cut, int warnuser);
void kde_KKeyChooser__warning(kde_KKeyChooser* instPointer,kde_KKeySequence* seq, qt_QString * sAction, qt_QString * sTitle);
void kde_KKeyChooser_virtual_hook(kde_KKeyChooser* instPointer,int identifier, void* data);
void kde_KKeyChooser_slotNoKey(kde_KKeyChooser* instPointer);
void kde_KKeyChooser_slotDefaultKey(kde_KKeyChooser* instPointer);
void kde_KKeyChooser_slotCustomKey(kde_KKeyChooser* instPointer);
void kde_KKeyChooser_slotListItemSelected(kde_KKeyChooser* instPointer,qt_QListViewItem * item);
void kde_KKeyChooser_capturedShortcut(kde_KKeyChooser* instPointer,kde_KShortcut* cut);

#endif
