/***************************************************************************
                            KApplication.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Controls and provides information to all KDE applications.

 Only one object of this class can be instantiated in a single app.
 This instance is always accessible via the {@link #kApplication} method.

 This class provides the following services to all KDE applications.

 See {@link KApplicationSignals} for signals emitted by KApplication.

 See {@link KApplicationEventHandling} for event handlers to override in subclasses of KApplication.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KApplication.java,v 1.8 2002/01/31 04:48:55 rdale Exp $

 @short Controls and provides information to all KDE applications.

*/
public class KApplication extends QApplication implements  KInstanceInterface {
	protected KApplication(Class dummy){super((Class) null);}

	private native void newKApplication( boolean allowStyles, boolean GUIenabled);

/** 
 This constructor takes aboutData and command line
  arguments from {@link KCmdLineArgs}.

*/
	public KApplication( boolean allowStyles, boolean GUIenabled) {
		super((Class) null);
		newKApplication( allowStyles, GUIenabled);
	}
	private native void newKApplication();
	public KApplication() {
		super((Class) null);
		newKApplication();
	}
//	private native void newKApplication( Display* display, int argc, String argv, String rAppName, boolean allowStyles, boolean GUIenabled);

/** 
 Constructor. Parses command-line arguments. Use this constructor to use KApplication
 in a Motif or Xt program.

*/
//	public KApplication( Display* display, int argc, String argv, String rAppName, boolean allowStyles, boolean GUIenabled) {
//		super((Class) null);
//		newKApplication( display, argc, argv, rAppName, allowStyles, GUIenabled);
//	}
//	private native void newKApplication( Display* display, int argc, String argv, String rAppName);
//	public KApplication( Display* display, int argc, String argv, String rAppName) {
//		super((Class) null);
//		newKApplication( display, argc, argv, rAppName);
//	}
	private native void newKApplication( int argc, String argv, String rAppName, boolean allowStyles, boolean GUIenabled);

/** 

 Constructor. Parses command-line arguments.

*/
	private native void newKApplication( String[] args, String rAppName, boolean allowStyles, boolean GUIenabled);
	public KApplication( String[] args, String rAppName, boolean allowStyles, boolean GUIenabled) {
		super((Class) null);
		newKApplication( args, rAppName, allowStyles, GUIenabled);
	}
	public KApplication( String[] args, String rAppName, boolean allowStyles) {
		this( args, rAppName, allowStyles, true);
	}
	private native void newKApplication( String[] args, String rAppName);
	public KApplication( String[] args, String rAppName) {
		super((Class) null);
		newKApplication( args, rAppName);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the application session config object.

*/
	public native KConfig sessionConfig();

/** 
 Is the application restored from the session manager?

*/
	public native boolean isRestored();

/** 
 Disables session management for this application.

 Useful in case  your application is started by the
 initial "startkde" script.
   
*/
	public native void disableSessionManagement();

/** 
 Asks the session manager to shut the session down.

 Using confirm == ShutdownConfirmYes or sdtype != ShutdownTypeDefault or
 sdmode != ShutdownModeDefault causes the use of ksmserver's DCOP
 interface. The remaining two combinations use the standard XSMP and
 will work with any session manager compliant with it.

 Returns TRUE on sucess, FALSE if the session manager could not be
 contacted.
   
*/
	public native boolean requestShutDown( int confirm, int sdtype, int sdmode);
	public native boolean requestShutDown();

/** 
 Propagates the network address of the session manager in the
 SESSION_MANAGER environment variable so that child processes can
 pick it up.

 If SESSION_MANAGER isn't defined yet, the address is searched in
 $HOME/.KSMserver.

 This function is called by clients that are started outside the
 session ( i.e. before ksmserver is started), but want to launch
 other processes that should participate in the session.  Examples
 are kdesktop or kicker.
   
*/
	public native void propagateSessionManager();
	public native void commitData( QSessionManager sm);
	public native void saveState( QSessionManager sm);

/** 
 Returns a {@link QPixmap} with the application icon.
   
*/
	public native QPixmap icon();

/** 
 Returns the name of the application icon.
   
*/
	public native String iconName();

/** 
 Returns the mini-icon for the application as a {@link QPixmap}.
   
*/
	public native QPixmap miniIcon();

/** 
 Returns the name of the mini-icon for the application.
   
*/
	public native String miniIconName();

/** 
   Sets the top widget of the application.

  This means basically applying the right window caption and
  icon. An application may have several top widgets. You don't
  need to call this function manually when using {@link KMainWindow}.

*/
	public native void setTopWidget( QWidget topWidget);

/** 
 Invokes the KHelpCenter HTML help viewer from docbook sources.

*/
	public native void invokeHelp( String anchor, String appname);
	public native void invokeHelp();

/** 

 Invoke the khelpcenter HTML help viewer from HTML sources.
 Please use invokeHelp() instead.

*/
	public native void invokeHTMLHelp( String aFilename, String aTopic);
	public native void invokeHTMLHelp( String aFilename);

/** 
 Convenience method; invokes the standard email application.

*/
	public native void invokeMailer( String address, String subject);

/** 
 Invokes the standard email application.

*/
	public native void invokeMailer( KURL mailtoURL);

/** 
 Convenience method; invokes the standard email application.

 All parameters are optional.

*/
	public native void invokeMailer( String to, String cc, String bcc, String subject, String body, String messageFile, String[] attachURLs);
	public native void invokeMailer( String to, String cc, String bcc, String subject, String body);

/** 
 Invokes the standard browser.

*/
	public native void invokeBrowser( String url);

/** 
 Returns a text for the window caption.

 This may be set by
 "-caption", otherwise it will be equivalent to the name of the
 executable.
   
*/
	public native String caption();

/** 

   
*/
//	public native KStyle kstyle();

/** 
 Builds a caption that contains the application name along with the
 {@link #userCaption} using a standard layout.

 To make a compliant caption
 for your window, simply do: <code>setCaption</code>(kapp.makeStdCaption(yourCaption));

*/
	public native String makeStdCaption( String userCaption, boolean withAppName, boolean modified);
	public native String makeStdCaption( String userCaption);

/** 
 Get a file name in order to make a temporary copy of your document.

*/
	public native String tempSaveName( String pFilename);

/** 
 Check whether  an auto-save file exists for the document you want to
 open.

*/
	public native String checkRecoverFile( String pFilename, boolean bRecover);

/** 
 Get the X11 display
   
*/
//	public native Display* getDisplay();

/** 
 Enables style plugins.

 This is useful only to applications that normally
 do not display a GUI and create the KApplication with
 allowStyles set to false.
   
*/
	public native void enableStyles();

/** 
 Disables style plugins.

 Current style plugins do not get unloaded.

 This is only useful when used in combination with {@link enableStyles}.
   
*/
	public native void disableStyles();

/** 
  Installs widget filter as global X11 event filter.

 The widget
  filter receives XEvents in its standard {@link QWidget#x11Event} function.

  Warning: Only do this when absolutely necessary. An installed X11 filter
  can slow things down.

*/
	public native void installX11EventFilter( QWidget filter);

/** 
 Adds a message type to the KIPC event mask. You can only add "system
 messages" to the event mask. These are the messages with id < 32.
 Messages with id >= 32 are user messages.

*/
	public native void addKipcEventMask( int identifier);

/** 
 Removes a message type from the KIPC event mask. This message will not
 be handled anymore.

*/
	public native void removeKipcEventMask( int identifier);

/** 
 Returns the app startup notification identifier for this running application.
   
*/
	public native String startupId();

/** 
 Sets a new value for the application startup notification window property for newly
 created toplevel windows.
   
*/
	public native void setStartupId( String startup_id);

/** 
 Returns the argument to --geometry if any, so the geometry can be set
 wherever necessary
    
*/
	public native String geometryArgument();

/** 
 Install a Qt SQL property map with entries for all KDE widgets
 Call this in any application using KDE widgets in QSqlForm or QDataView.
   
*/
	public native void installKDEPropertyMap();

/** 

   
*/
	public native boolean notify( QObject receiver, QEvent event);

/** 

    
*/
	public native int xioErrhandler();

/** 

   
*/
//	public native void iceIOErrorHandler( _IceConn* conn);

/** 
 Tells KApplication about one more operation that should be finished
 before the application exits. The standard behavior is to exit on the
 "last window closed" event, but some events should outlive the last window closed
 (e.g. a file copy for a file manager, or 'compacting folders on exit' for a mail client).
   
*/
	public native void ref();

/** 
 Tells KApplication that one operation such as those described in {@link ref} just finished.
 The application exits if the counter is back to 0.
   
*/
	public native void deref();

/** 
 Add Qt and KDE command line options to KCmdLineArgs.
    
*/
	public static native void addCmdLineOptions();

/** 
 Returns the current application object.

 This is similar to the global {@link QApplication} pointer qApp. It
 allows access to the single global KApplication object, since
 more than one cannot be created in the same application. It
 saves you the trouble of having to pass the pointer explicitly
 to every function that may require it.
   
*/
	public static native KApplication kApplication();

/** 
 Returns a pointer to a {@link DCOPClient} for the application.
 If a client does not exist yet, it is created when this
 function is called.
   
*/
	public static native DCOPClient dcopClient();

/** 
 Disable automatic dcop registration
 Must be called before creating a KApplication instance to have an effect.
   
*/
	public static native void disableAutoDcopRegistration();

/** 
 Returns the DCOP name of the service launcher. This will be something like
 klaucher_$host_$uid.
   
*/
	public static native String launcher();

/** 
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
	public static native int startServiceByName( String _name, String URL, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByName( String _name, String URL);
	public static native int startServiceByName( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByName( String _name);

/** 
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
	public static native int startServiceByDesktopPath( String _name, String URL, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByDesktopPath( String _name, String URL);
	public static native int startServiceByDesktopPath( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByDesktopPath( String _name);

/** 
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
	public static native int startServiceByDesktopName( String _name, String URL, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByDesktopName( String _name, String URL);
	public static native int startServiceByDesktopName( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id, boolean noWait);
	public static native int startServiceByDesktopName( String _name);

/** 
 Starts a program via kdeinit.
 There will be no application startup notification, so you should
 use it only for starting internal processes.

 program name and arguments are converted to according to the
 local encoding and passed as is to kdeinit.

*/
	public static native int kdeinitExec( String name, String[] args, String error, int[] pid);
	public static native int kdeinitExec( String name);

/** 
 Starts a program via kdeinit and wait for it to finish.

 Like kdeinitExec but it waits till the program is finished.
 As such it behaves similar to the system(...) function.
   
*/
	public static native int kdeinitExecWait( String name, String[] args, String error, int[] pid);
	public static native int kdeinitExecWait( String name);

/** 
 Generates a uniform random number.

*/
	public static native int random();

/** 
 Generates a random string.  It operates in the range [A-Za-z0-9]

*/
	public static native String randomString( int length);

/** 

   
*/
	public static native void startKdeinit();
	private native void newKApplication( boolean allowStyles, boolean GUIenabled, KInstanceInterface _instance);

/** 

   
*/
	public KApplication( boolean allowStyles, boolean GUIenabled, KInstanceInterface _instance) {
		super((Class) null);
		newKApplication( allowStyles, GUIenabled, _instance);
	}

/** 
 Used to catch X11 events
   
*/
//	protected native boolean x11EventFilter( XEvent* arg1);
	public static final int CaptionAppLast = 1;
	public static final int CaptionAppFirst = 0;
	public static final int CaptionNoApp = 1;
	public static final int /***Obeytheuser'sconfirmationsetting.*/ShutdownConfirmDefault = -1;
	public static final int /***Don'tconfirm = 0;
	public static final int shutdownwithoutasking.*/ShutdownConfirmNo = 0;
	public static final int /***Alwaysconfirm = 1;
	public static final int askeveniftheuserturneditoff.*/ShutdownConfirmYes = 1;
	public static final int /***Selectpreviousactionorthedefaultifit'sthefirsttime.*/ShutdownTypeDefault = -1;
	public static final int /***Onlylogout.*/ShutdownTypeNone = 0;
	public static final int /***Logoutandrebootthemachine.*/ShutdownTypeReboot = 1;
	public static final int /***Logoutandhaltthemachine.*/ShutdownTypeHalt = 2;
	public static final int /***Selectpreviousmodeorthedefaultifit'sthefirsttime.*/ShutdownModeDefault = -1;
	public static final int /***Scheduleashutdown(haltorreboot)forthetimeallactivesessions*haveexited.*/ShutdownModeSchedule = 0;
	public static final int /***Shutdown = 0;
	public static final int ifnosessionsareactive.Otherwisedonothing.*/ShutdownModeTryNow = 1;
	public static final int /***Forceshutdown.Killanypossiblyactivesessions.*/ShutdownModeForceNow = 2;
	public static final int SETTINGS_MOUSE = 0;
	public static final int SETTINGS_COMPLETION = 1;
	public static final int SETTINGS_PATHS = 2;
	public static final int SETTINGS_POPUPMENU = 3;
	public static final int SETTINGS_QT = 4;
	public static final int SETTINGS_SHORTCUTS = 5;

	// From KIntstanceInterface
	
/**
  Returns the application standard dirs object.

*/
	public native KStandardDirs dirs();

/**
  Returns the general config object.

*/
	public native KConfig config();

/**
  Returns an iconloader object.

*/
	public native KIconLoader iconLoader();

/**
 Re-allocate the global iconloader.

*/
	public native void newIconLoader();
	public native KCharsets charsets();

/**
  Returns the about data of this instance
  Warning, can be null

*/
	public native KAboutData aboutData();

/**

*/
	public native String instanceName();

	/**
		Used internally by the KDE Java bindings runtime
	*/
	public static native void setJavaSlotFactory();
}
