/***************************************************************************
                            KCombiView.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This view is designed to combine two KFileViews into one widget, to show
 directories on the left side and files on the right side.

 Methods like selectedItems() to query status _only_ work on the right side,
 i.e. on the files.

 After creating the KCombiView, you need to supply the view shown in the
 right, (see {@link #setRight}). Available KFileView implementations are
 {@link KFileIconView} and {@link KFileDetailView}.

 Most of the below methods are just implementations of the baseclass
 {@link KFileView}, so look there for documentation.

 See {@link KCombiViewSignals} for signals emitted by KCombiView.

 See {@link KCombiViewEventHandling} for event handlers to override in subclasses of KCombiView.

 @short 
 This view is designed to combine two KFileViews into one widget, to show
 directories on the left side and files on the right side.
*/
public class KCombiView extends QSplitter implements  KFileViewInterface {
	protected KCombiView(Class dummy){super((Class) null);}

	private native void newKCombiView( QWidget parent, String name);
	public KCombiView( QWidget parent, String name) {
		super((Class) null);
		newKCombiView( parent, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native QWidget widget();
	public native void clearView();
	public native void updateView( boolean arg1);
	public native void updateView( KFileItem arg1);
	public native void removeItem( KFileItem arg1);
	public native void listingCompleted();

/** 
 Sets the view to be shown in the right. You need to call this before
 doing anything else with this widget.
     
*/
	public native void setRight( KFileViewInterface view);
	public native void setSelectionMode( int sm);
	public native void setSelected( KFileItem arg1, boolean arg2);
	public native boolean isSelected( KFileItem arg1);
	public native void clearSelection();
	public native void selectAll();
	public native void invertSelection();
	public native void setCurrentItem( KFileItem arg1);
	public native KFileItem currentFileItem();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem( KFileItem arg1);
	public native KFileItem prevItem( KFileItem arg1);
	public native void insertItem( KFileItem i);
	public native void clear();
	public native void setSorting( int sort);
	public native void ensureItemVisible( KFileItem arg1);
	protected native void slotSortingChanged( int arg1);
	
	// From KFileViewInterface
	
/**
 ### As const-method, to be fixed in 3.0

*/
//	public native QWidget widget();

/**
 Sets <code>filename</code> the current item in the view, if available.

*/
	public native void setCurrentItem( String filename);

	public native void updateView();

/**
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();

/**
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).

*/
	public native boolean isReversed();
	public native void sortReversed();

/**

*/
	public native int count();

/**

*/
	public native int numFiles();

/**

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/**

*/
	public native String viewName();

/**
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".

*/
	public native void setViewName( String name);
	public native void setParentView( KFileViewInterface parent);

/**

*/
	public native ArrayList selectedItems();

/**

*/
	public native ArrayList items();

/**
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.

*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/**

*/
	public native boolean onlyDoubleClickSelectsFiles();

/**
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileItem i);

/**

*/
	public native KActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void writeConfig( KConfig arg1, String group);
	public native void writeConfig( KConfig arg1);
	public static native String sortingKey( String value, boolean isDir, int sortSpec);
	public static native String sortingKey( int value, boolean isDir, int sortSpec);

}
