/***************************************************************************
                            KFileMetaInfo.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is the base class for objects that hold meta information about a file.
 The information is kept in form of a system of key/value pairs. See also
 {@link KFileMetaInfoItem}.
 This information is retrieved from the file through a plugin system, and
 this class is the main interface to it.
 If you want to write your own plugin, have a look at {@link KFilePlugin}.
 There are basically two different kinds of meta information: Fixed ones
 that the plugin knows about (e.g. an mp3 id3v1 tag has a well defined
 fixed list of fields), and variable keys that exist in mimetypes that
 support their own key/value system (comments in png files are of this type).
 
 @short 
 This is the base class for objects that hold meta information about a file.
*/
public class  KFileMetaInfo implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KFileMetaInfo(Class dummy){}

	private native void newKFileMetaInfo( String path, String mimeType);

/** 
 The constructor. 

 creating a KFileMetaInfo item through this will autoload the plugin
 belonging to the mimetype and try to get meta information about
 the specified file.

 If no info is available, you'll get an empty (not invalid) object.

     
*/
	public KFileMetaInfo( String path, String mimeType) {
		newKFileMetaInfo( path, mimeType);
	}
	private native void newKFileMetaInfo( String path);
	public KFileMetaInfo( String path) {
		newKFileMetaInfo( path);
	}
	private native void newKFileMetaInfo();

/** 
 Default constructor. This will create an invalid object (see 
 {@link #isValid}.
     
*/
	public KFileMetaInfo() {
		newKFileMetaInfo();
	}
//	private native void newKFileMetaInfo( KFileMetaInfo* original);

/** 
 Copy constructor
     
*/
//	public KFileMetaInfo( KFileMetaInfo* original) {
//		newKFileMetaInfo( original);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

*/
//	public native KFileMetaInfoItem& item( String key);

/** 
 Convenience function. Returns the value of the specified key.
 you can also use item(key).value()
     
*/
	public native QVariant value( String key);

/** 

*/
	public native boolean contains( String key);

/** 

*/
	public native ArrayList supportedKeys();

/** 

*/
	public native ArrayList preferredKeys();

/** 

*/
	public native boolean supportsVariableKeys();

/** 

*/
//	public native KFileMetaInfoItem& addItem( String key, QVariant value);

/** 
 This method writes all pending changes to the meta info back to the file.
 If any items are marked as removed, they are really removed from the 
 list now

*/
	public native boolean applyChanges();

/** 
 Creates a validator for this item. Make sure to supply a proper parent
 argument or delete the validator yourself.
     
*/
	public native QValidator createValidator( String key, QObject parent, String name);
	public native QValidator createValidator( String key, QObject parent);

/** 

*/
	public native boolean isValid();

/** 

*/
//	protected native KFilePlugin plugin();
}
