/***************************************************************************
                            KIO.java -  description
                             -------------------
    begin                : Thu Mar 21 21:39:59 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 21:39:59 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KIO implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIO(Class dummy){}


/** 
 Creates a single directory.

*/
	public static native SimpleJob mkdir( KURL url, int permissions);
	public static native SimpleJob mkdir( KURL url);

/** 
 Removes a single directory.

 The directory is assumed to be empty.

*/
	public static native SimpleJob rmdir( KURL url);

/** 
 Changes permissions on a file or directory.
 See the other {@link chmod} below for changing many files
 or directories.

*/
	public static native SimpleJob chmod( KURL url, int permissions);

/** 
 Rename a file or directory.
 Warning: this operation fails if a direct renaming is not
 possible (like with files or dirs on separate partitions)
 Use move or file_move in this case.

*/
	public static native SimpleJob rename( KURL src, KURL dest, boolean overwrite);

/** 
 Create or move a symlink.
 This is the lowlevel operation, similar to file_copy and file_move.
 It doesn't do any check (other than those the slave does)
 and it doesn't show rename and skip dialogs - use KIO.link for that.

*/
	public static native SimpleJob symlink( String target, KURL dest, boolean overwrite, boolean showProgressInfo);
	public static native SimpleJob symlink( String target, KURL dest, boolean overwrite);

/** 
 Execute any command that is specific to one slave (protocol).

 Examples are : HTTP POST, mount and unmount (kio_file)

*/
	public static native SimpleJob special( KURL url, byte[] data, boolean showProgressInfo);
	public static native SimpleJob special( KURL url, byte[] data);

/** 
 Mount filesystem.

 Special job for <code>kio_file.</code>

*/
	public static native SimpleJob mount( boolean ro, String fstype, String dev, String point, boolean showProgressInfo);
	public static native SimpleJob mount( boolean ro, String fstype, String dev, String point);

/** 
 Unmount filesystem.

 Special job for <code>kio_file.</code>

*/
	public static native SimpleJob unmount( String point, boolean showProgressInfo);
	public static native SimpleJob unmount( String point);

/** 
 HTTP cache update

*/
	public static native SimpleJob http_update_cache( KURL url, boolean no_cache, long expireDate);

/** 

*/
//	public static native CacheInfo getCacheInfo( KURL url);

/** 
 Find all details for one file or directory.
     
*/
	public static native StatJob stat( KURL url, boolean showProgressInfo);
	public static native StatJob stat( KURL url);

/** 
 Find all details for one file or directory.
 This version of the call includes two additional booleans, <code>sideIsSource</code> and <code>details.</code>

*/
	public static native StatJob stat( KURL url, boolean sideIsSource, short details, boolean showProgressInfo);
	public static native StatJob stat( KURL url, boolean sideIsSource, short details);

/** 
 Get (a.k.a. read).

 The slave emits the data through {@link #data}.
     
*/
	public static native TransferJob get( KURL url, boolean reload, boolean showProgressInfo);
	public static TransferJob get( KURL url, boolean reload) {
		return get(url, reload, true);
	}
	public static native TransferJob get( KURL url);

/** 
 Put (a.k.a. write)

*/
	public static native TransferJob put( KURL url, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static native TransferJob put( KURL url, int permissions, boolean overwrite, boolean resume);

/** 
 HTTP POST (for form data).

 Example:
 <pre>
    job = KIO.http_post( url, postData, false );
    job.addMetaData("content-type", contentType );
    job.addMetaData("referrer", referrerURL);
 </pre>

 You MUST specify content-type!

 Often <code>contentType</code> is "application/x-www-form-urlencoded" and
 the <code>postData</code> is then an ASCII string (without null-termination!)
 with characters like space, linefeed and percent escaped like %20,
 %0A and %25.
     
*/
	public static native TransferJob http_post( KURL url, byte[] postData, boolean showProgressInfo);
	public static native TransferJob http_post( KURL url, byte[] postData);
//	public static native MultiGetJob multi_get( long identifier, KURL url, MetaData metaData);

/** 
 Find mimetype for one file or directory.
     
*/
	public static native MimetypeJob mimetype( KURL url, boolean showProgressInfo);
	public static native MimetypeJob mimetype( KURL url);

/** 
 Copy a single file.

 Uses either {@link SlaveBase#copy} if the slave supports that
 or {@link #get} and {@link #put} otherwise.

*/
	public static native FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume) {
		return file_copy(src, dest, permissions, overwrite, resume, true);
	}
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions, boolean overwrite) {
		return file_copy(src, dest, permissions, overwrite, false, true);
	}
	public static FileCopyJob file_copy( KURL src, KURL dest, int permissions) {
		return file_copy(src, dest, permissions, false, false, true);
	}
	public static native FileCopyJob file_copy( KURL src, KURL dest);

/** 
 Move a single file.

 Use either {@link SlaveBase#rename} if the slave supports that,
 or {@link #copy} and {@link #del} otherwise, or eventually get() & put() & del()

*/
	public static native FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite, boolean resume) {
		return file_move(src, dest, permissions, overwrite, resume, true);
	}
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions, boolean overwrite) {
		return file_move(src, dest, permissions, overwrite, false, true);
	}
	public static FileCopyJob file_move( KURL src, KURL dest, int permissions) {
		return file_move(src, dest, permissions, false, false, true);
	}
	public static native FileCopyJob file_move( KURL src, KURL dest);

/** 
 Delete a single file.

*/
	public static native SimpleJob file_delete( KURL src, boolean showProgressInfo);
	public static native SimpleJob file_delete( KURL src);

/** 
 List the contents of <code>url</code>, which is assumed to be a directory.

 "." and ".." are returned, filter them out if you don't want them.

 pass includeHidden = false to cull out UNIX hidden files/dirs
 (whose names start with .)
     
*/
	public static native ListJob listDir( KURL url, boolean showProgressInfo, boolean includeHidden);
	public static ListJob listDir( KURL url, boolean showProgressInfo) {
		return listDir(url, showProgressInfo, true);
	}
	public static native ListJob listDir( KURL url);

/** 
 The same as the previous method, but recurses subdirectories.

 "." and ".." are returned but only for the toplevel directory.
 Filter them out if you don't want them.

 pass includeHidden = false to cull out UNIX hidden files/dirs
 (whose names start with .)
     
*/
	public static native ListJob listRecursive( KURL url, boolean showProgressInfo, boolean includeHidden);
	public static ListJob listRecursive( KURL url, boolean showProgressInfo) {
		return listRecursive(url, showProgressInfo, true);
	}
	public static native ListJob listRecursive( KURL url);

/** 
 Copy a file or directory <code>src</code> into the destination @dest,
 which can be a file (including the final filename) or a directory
 (into which <code>src</code> will be copied).

 This emulates the <code>cp</code> command completely.
     
*/
	public static native CopyJob copy( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy( KURL src, KURL dest);

/** 
 Copy a file or directory <code>src</code> into the destination @dest,
 which is the destination name in any case, even for a directory.

 As opposed to {@link copy}, this doesn't emulate <code>cp</code>, but is the only
 way to copy a directory, giving it a new name and getting an error
 box if a directory already exists with the same name.
     
*/
	public static native CopyJob copyAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copyAs( KURL src, KURL dest);

/** 
 Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>
     
*/
	public static native CopyJob copy( ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy( ArrayList src, KURL dest);

/** 

*/
	public static native CopyJob move( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move( KURL src, KURL dest);

/** 

*/
	public static native CopyJob moveAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob moveAs( KURL src, KURL dest);

/** 

*/
	public static native CopyJob move( ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move( ArrayList src, KURL dest);

/** 
 Create a link.

*/
	public static native CopyJob link( KURL src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link( KURL src, KURL destDir);

/** 

*/
	public static native CopyJob link( ArrayList src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link( ArrayList src, KURL destDir);

/** 

*/
	public static native CopyJob linkAs( KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob linkAs( KURL src, KURL dest);

/** 
 Delete a file or directory.

*/
	public static native DeleteJob del( KURL src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del( KURL src);
	public static native DeleteJob del( ArrayList src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del( ArrayList src);
}
