/***************************************************************************
                            KLocale.java -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 KLocale provides support for country specific stuff like
 the national language.

 KLocale supports translating, as well as specifying the format
 for numbers, currency, time, and date.

 @author Stephan Kulow <coolo@kde.org>, Preston Brown <pbrown@kde.org>, Hans Petter Bieker <bieker@kde.org>

 @short class for supporting locale settings and national language.
*/
public class  KLocale implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KLocale(Class dummy){}

	private native void newKLocale( String catalogue, KConfig config);

/** 
 Constructs a KLocale with the given catalogue name.
 The constructor looks for an entry Locale/Language in the
 configuration file.
 If no config file is specified, it will also look for languages
 using the environment variables (KDE_LANG, LC_MESSAGES, LC_ALL, LANG),
 as well as the global configuration fie. If we were not able to use
 non of the specified languages, the default language (en_US) will be
 used.

 If you specify a configuration file, it has to be valid until
 the KLocale object is destroyed.

*/
	public KLocale( String catalogue, KConfig config) {
		newKLocale( catalogue, config);
	}
	private native void newKLocale( String catalogue);
	public KLocale( String catalogue) {
		newKLocale( catalogue);
	}
	private native void newKLocale( KLocale rhs);

/** 
 Copy constructor.
   
*/
	public KLocale( KLocale rhs) {
		newKLocale( rhs);
	}

/** 
 Destructor.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Translates the string into the corresponding string in
 the national language, if available. If not, returns
 the string itself.
 There is a KDE wide message file that contains the most
 often used phrases, so we can avoid duplicating the
 translation of these phrases. If a phrase is not found
 in the catalogue given to the constructor, it will search
 in the system catalog. This makes it possible to override
 some phrases for your needs.

  The argument must be an UTF-8 encoded string (If you only use
  characters that are in US-ASCII you're on the safe side. But
  for e.g. german umlauts or french accents should be recoded to
  UTF-8)

*/
	public native String translate( String index);

/** 
 Translates the string into the corresponding string in the
 national language, if available.

 The real contents of the string is in the argument fallback,
 but the meaning of it is coded into the argument index.
 In some cases you'll need this function, when english is
 too ambiguous to express it.

 Most of the times the translators will tell you if it can't
 be translated as it, but think of cases as "New", where the
 translations differs depending on what is New.
 Or simple cases as "Open", that can be used to express something
 is open or it can be used to express that you want something to
 open... There are tons of such examples.

 If translate("Open") is not enough to translate it well, use
 translate("To Open", "Open") or translate("Is Open", "Open").
 The english user will see "Open" in both cases, but the translated
 version may vary. Of course you can also use i18n()

*/
	public native String translate( String index, String fallback);
	public native String translate( String singular, String plural, long n);

/** 

*/
	public native boolean setCharset( String charset);

/** 
 Changes the current encoding.

*/
	public native boolean setEncoding( int mibEnum);

/** 
 Changes the current language. The current language will be left
 unchanged if failed. It will force a reload of the country specific
 configuration as well.

*/
	public native boolean setLanguage( String language);

/** 
 Changes the list of prefed languages for the locale. The first valid
 language in the list will be used, or the default (en_US) language
 will be used if non of the specified languages were available.

*/
	public native boolean setLanguage( String[] languages);

/** 
 Changes the current country. The current country will be left
 unchanged if failed. It will force a reload of the country specific
 configuration.

*/
	public native boolean setCountry( String country);

/** 
 Returns what a decimal point should look like ("." or "," etc.)
 according to the current locale or user settings.

*/
	public native String decimalSymbol();

/** 
 Returns what the thousands separator should look
 like ("," or "." etc.)
 according to the current locale or user settings.

*/
	public native String thousandsSeparator();

/** 
 Returns what the symbol denoting currency in the current locale
 as as defined by user settings should look like.

*/
	public native String currencySymbol();

/** 
 Returns what a decimal point should look like ("." or "," etc.)
 for monetary values, according to the current locale or user
 settings.

*/
	public native String monetaryDecimalSymbol();

/** 
 Returns what a thousands separator for monetary values should
 look like ("," or " " etc.) according to the current locale or
 user settings.

*/
	public native String monetaryThousandsSeparator();

/** 
 Returns what a positive sign should look like ("+", " ", etc.)
 according to the current locale or user settings.

*/
	public native String positiveSign();

/** 
 Returns what a negative sign should look like ("-", etc.)
 according to the current locale or user settings.

*/
	public native String negativeSign();

/** 
 The number of fractional digits to include in numeric/monetary
 values (usually 2).

*/
	public native int fracDigits();

/** 
 If and only if the currency symbol precedes a positive value,
 this will be true.

*/
	public native boolean positivePrefixCurrencySymbol();

/** 
 If and only if the currency symbol precedes a negative value,
 this will be true.

*/
	public native boolean negativePrefixCurrencySymbol();

/** 
 Returns the position of a positive sign in relation to a
 monetary value.

*/
	public native int positiveMonetarySignPosition();

/** 
 Denotes where to place a negative sign in relation to a
 monetary value.

*/
	public native int negativeMonetarySignPosition();

/** 
 Given a double, converts that to a numeric string containing
 the localized monetary equivalent.

 e.g. given 123456, return "$ 123,456.00".

*/
	public native String formatMoney( double num, String currency, int digits);
	public native String formatMoney( double num);

/** 

 a String as the argument for convenience.

*/
	public native String formatMoney( String numStr);

/** 
 Given a double, converts that to a numeric string containing
 the localized numeric equivalent.

 e.g. given 123456.78, return "123,456.78" (for some European country).
 If precision isn't specified, 2 is used.

*/
	public native String formatNumber( double num, int precision);
	public native String formatNumber( double num);

/** 

 a String as the argument for convenience.

*/
	public native String formatNumber( String numStr);

/** 
 Returns a string formatted to the current locale's conventions
 regarding dates.

*/
	public native String formatDate( Calendar pDate, boolean shortFormat);
	public native String formatDate( Calendar pDate);

/** 
 Returns a string formatted to the current locale's conventions
 regarding times.

*/
	public native String formatTime( Date pTime, boolean includeSecs);
	public native String formatTime( Date pTime);

/** 
 Use this to determine if the user wants a 12 hour clock.

*/
	public native boolean use12Clock();

/** 
 Use this to determine if the user wants the week to start on Monday.

*/
	public native boolean weekStartsMonday();

/** 
 Returns a string containing the name of the month name.

*/
	public native String monthName( int i, boolean shortName);
	public native String monthName( int i);

/** 
 Returns a string containing the name of the week day.

*/
	public native String weekDayName( int i, boolean shortName);
	public native String weekDayName( int i);

/** 
 Returns a string formated to the current locale's conventions
 regarding both date and time.

*/
	public native String formatDateTime( Calendar pDateTime, boolean shortFormat, boolean includeSecs);
	public native String formatDateTime( Calendar pDateTime);

/** 
 Converts a localized monetary string to a double.

*/
	public native double readMoney( String numStr, boolean[] ok);
	public native double readMoney( String numStr);

/** 
 Converts a localized numeric string to a double.

*/
	public native double readNumber( String numStr, boolean[] ok);
	public native double readNumber( String numStr);

/** 
 Converts a localized date string to a QDate.
 The boolean pointed by ok will be invalid if the date entered was not valid.

*/
	public native Calendar readDate( String str, boolean[] ok);

/** 
 Converts a localized date string to a QDate, using the specified format.
 You will usually not want to use this method.
   
*/
	public native Calendar readDate( String intstr, String fmt, boolean[] ok);

/** 
 Converts a localized time string to a QTime.
 The boolean pointed by ok will be false if the time entered was not valid.

*/
	public native Date readTime( String str, boolean[] ok);

/** 
 Returns the language used by this object. The domain AND the
 library translation must be available in this language.
 "en_US" is default, if no other available.

*/
	public native String language();

/** 
 Returns the country code of the country where the user lives.
 "C" is default, if no other available

*/
	public native String country();

/** 

*/
	public native String languages();

/** 
 Returns the preferred languages as ISO 639-1 codes. This means
 that information about country is removed. If the internal language
 code might be represented by more than one 639-1 code, they will all be
 listed (but only once).

 If the selected languages are "nn, nb, pt_BR", you will get:
 "nn, no, nb, pt".

*/
	public native ArrayList languagesTwoAlpha();

/** 
 Returns the languages selected by user. The codes returned here is the
 internal language codes.

*/
	public native ArrayList languageList();

/** 

 This will be the charset defined in the config file.
 NOTE: This is no longer the same as encoding.
 "iso-8859-1" is default

*/
	public native String charset();

/** 
 Returns the user's preferred encoding.

*/
	public native String encoding();

/** 
 Returns the user's preferred encoding.

*/
	public native int encodingMib();

/** 
 Returns the user's preferred encoding. Should never be NULL.

*/
	public native QTextCodec codecForEncoding();

/** 
 Changes the current date format.

*/
	public native void setDateFormat( String format);

/** 
 Changes the current short date format.

*/
	public native void setDateFormatShort( String format);

/** 
 Changes the current time format.

*/
	public native void setTimeFormat( String format);

/** 
 Changes how KLocale defines the first day in week.

*/
	public native void setWeekStartsMonday( boolean start);

/** 
 Returns the currently selected date format.

*/
	public native String dateFormat();

/** 
 Returns the currently selected short date format.

*/
	public native String dateFormatShort();

/** 
 Returns the currently selected time format.

*/
	public native String timeFormat();

/** 
 Changes the symbol used to identify the decimal pointer.

*/
	public native void setDecimalSymbol( String symbol);

/** 
 Changes the separator used to group digits when formating numbers.

*/
	public native void setThousandsSeparator( String separator);

/** 
 Changes the sign used to identify a positive number. Normally this is
 left blank.

*/
	public native void setPositiveSign( String sign);

/** 
 Changes the sign used to identify a negative number.

*/
	public native void setNegativeSign( String sign);

/** 
 Changes the sign position used for positive monetary values.

*/
	public native void setPositiveMonetarySignPosition( int signpos);

/** 
 Changes the sign position used for negative monetary values.

*/
	public native void setNegativeMonetarySignPosition( int signpos);

/** 
 Changes the position where the currency symbol should be printed for
 positive monetary values.

*/
	public native void setPositivePrefixCurrencySymbol( boolean prefix);

/** 
 Changes the position where the currency symbol should be printed for
 negative monetary values.

*/
	public native void setNegativePrefixCurrencySymbol( boolean prefix);

/** 
 Changes the number of digits used when formating numbers.

*/
	public native void setFracDigits( int digits);

/** 
 Changes the separator used to group digits when formating monetary values.

*/
	public native void setMonetaryThousandsSeparator( String separator);

/** 
 Changes the symbol used to identify the decimal pointer for monetary
 values.

*/
	public native void setMonetaryDecimalSymbol( String symbol);

/** 
 Changes the current currency symbol.

*/
	public native void setCurrencySymbol( String symbol);

/** 
 Returns the preferred page size for printing.

*/
	public native int pageSize();

/** 
 Changes the preferred page size when printing.

*/
	public native void setPageSize( int paperFormat);

/** 
 Returns which measuring system we use.

*/
	public native int measureSystem();

/** 
 Changes the preferred measuring system.

*/
	public native void setMeasureSystem( int value);

/** 
 Adds another catalogue to search for translation lookup.
 This function is useful for extern libraries and/or code,
 that provides its own messages.

 If the catalogue does not exist for the chosen language,
 it will be ignored and en_US will be used.

*/
	public native void insertCatalogue( String catalogue);
	public native void removeCatalogue( String catalogue);
	public native void setActiveCatalogue( String catalogue);

/** 
 Translates a message as a QTranslator is supposed to.
 The parameters are similar to i18n(), but the result
 value has other semantics (it can be String.null)

*/
	public native String translateQt( String context, String sourceText, String message);

/** 
 Returns the parts of the parameter str understood as language setting
 the format is language_COUNTRY.charset

*/
	public static native void splitLocale( String str, String language, String country, String charset);

/** 
 Use this to as main catalogue for all KLocales, if not the appname
 will be used.

*/
	public static native void setMainCatalogue( String catalogue);

/** 
 Finds localized resource in resourceDir( rtype ) + <lang> + fname.

*/
	public static native String langLookup( String fname, String rtype);
	public static native String langLookup( String fname);

/** 
 Returns the name of the internal language.

*/
	public static native String defaultLanguage();

/** 
 Returns the name of the default country.

*/
	public static native String defaultCountry();

/** 

 pointer.
   
*/
	protected static native void initInstance();
	public static final int ParensAround = 0;
	public static final int BeforeQuantityMoney = 1;
	public static final int AfterQuantityMoney = 2;
	public static final int BeforeMoney = 3;
	public static final int AfterMoney = 4;
	public static final int Metric = 0;
	public static final int Imperial = 1;
}
