/***************************************************************************
                            KProcIO.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 See {@link KProcIOSignals} for signals emitted by KProcIO.

 See {@link KProcIOEventHandling} for event handlers to override in subclasses of KProcIO.

*/
public class KProcIO extends KProcess  {
	protected KProcIO(Class dummy){super((Class) null);}

	private native void newKProcIO( QTextCodec codec);
	public KProcIO( QTextCodec codec) {
		super((Class) null);
		newKProcIO( codec);
	}
	private native void newKProcIO();
	public KProcIO() {
		super((Class) null);
		newKProcIO();
	}

/** 
  Starts the process.

  The following problems could cause this function to
    return false:

*/
	public native boolean start( int runmode, boolean includeStderr);
	public native boolean start();

/** 
 The buffer is zero terminated.
 A deep copy is made of the buffer, so you don't
 need to bother with that.  A newline ( '\n' ) is appended 
 unless you specify FALSE as the second parameter.
 FALSE is returned on an error, or else TRUE is.

*/
	public native boolean writeStdin( String line, boolean AppendNewLine);
	public native boolean writeStdin( String line);
	public native boolean fputs( String line, boolean AppendNewLine);
	public native boolean fputs( String line);

/** 
 reads a line of text (up to and including '\n')

 Use readln() in response to a readReady() signal.
 You may use it multiple times if more than one line of data is
  available.
 Be sure to use ackRead() when you have finished processing the
  readReady() signal.  This informs KProcIO that you are ready for
  another readReady() signal.

 readln() never blocks.

 autoAck==TRUE makes these functions call ackRead() for you.

*/
	public native int readln( String line, boolean autoAck, int[] partial);
	public native int readln( String line);
	public native int fgets( String line, boolean autoAck);
	public native int fgets( String line);

/** 
 Reset the class.  Doesn't kill the process.

*/
	public native void resetAll();

/** 
 Call this after you have finished processing a readReady()
 signal.  This call need not be made in the slot that was signalled
 by readReady().  You won't receive any more readReady() signals
 until you acknowledge with ackRead().  This prevents your slot
 from being reentered while you are still processing the current
 data.  If this doesn't matter, then call ackRead() right away in
 your readReady()-processing slot.

*/
	public native void ackRead();

/** 
  Turns readReady() signals on and off.
   You can turn this off at will and not worry about losing any data.
   (as long as you turn it back on at some point...)
   
*/
	public native void enableReadSignals( boolean enable);
	protected native void controlledEmission();
	protected native void received( KProcess proc, String buffer, int buflen);
	protected native void sent( KProcess arg1);
}
