/***************************************************************************
                            SimpleJob.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A simple job (one url and one command).
 This is the base class for all jobs that are scheduled.
 Other jobs are high-level jobs (CopyJob, DeleteJob, FileCopyJob...)
 that manage subjobs but aren't scheduled directly.
     
 See {@link SimpleJobSignals} for signals emitted by SimpleJob.

 See {@link SimpleJobEventHandling} for event handlers to override in subclasses of SimpleJob.

 @short 
 A simple job (one url and one command).
*/
public class SimpleJob extends Job  {
	protected SimpleJob(Class dummy){super((Class) null);}

	private native void newSimpleJob( KURL url, int command, byte[] packedArgs, boolean showProgressInfo);
	public SimpleJob( KURL url, int command, byte[] packedArgs, boolean showProgressInfo) {
		super((Class) null);
		newSimpleJob( url, command, packedArgs, showProgressInfo);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native KURL url();

/** 
 Abort job.
 This kills all subjobs and deletes the job.

*/
	public native void kill( boolean quietly);
	public native void kill();

/** 
 Abort job.
 Suspends slave to be reused by another job for the same request.
         
*/
	public native void putOnHold();

/** 

 Called by the scheduler when a slave gets to
 work on this job.

*/
	public native void start( Slave slave);

/** 

 Called to detach a slave from a job.

*/
	public native void slaveDone();

/** 

 Slave in use by this job.
         
*/
	public native Slave slave();

/** 

         
*/
	public native int command();

/** 

 Called on a slave's error.
 Made public for the scheduler.
         
*/
	public native void slotError( int arg1, String arg2);

/** 
 Discard suspended slave.
         
*/
	public static native void removeOnHold();

/** 
 Called when the slave marks the job
 as finished.
         
*/
	protected native void slotFinished();

/** 

 Called on a slave's warning.
         
*/
	protected native void slotWarning( String arg1);

/** 
 Called on a slave's info message.
         
*/
	protected native void slotInfoMessage( String arg1);

/** 
 Called on a slave's connected signal.
         
*/
	protected native void slotConnected();

/** 
 Forward signal from the slave
         
*/
	protected native void slotTotalSize( int data_size);

/** 
 Forward signal from the slave
         
*/
	protected native void slotProcessedSize( int data_size);

/** 
 Forward signal from the slave
         
*/
	protected native void slotSpeed( long bytes_per_second);

/** 
 MetaData from the slave is received.
         
*/
//	protected native void slotMetaData( MetaData _metaData);

/** 

         
*/
	protected native void slotNeedProgressId();
}
