#include "ai.h"
#include "ai.moc"

#include <klocale.h>

#include "board.h"


FEAI::FEAI(uint thinkTime, uint orderTime)
: AI(thinkTime, orderTime)
{
    addElement(new AIElement("occupied lines",
                             I18N_NOOP("Number of occupied lines"),
                             -2, -100, 0, 0, 0, 0, nbOccupiedLines));
    addElement(new AIElement("peak-to-peak",I18N_NOOP("Peak-to-peak distance"),
                             0, -100, 0, 0, 0, 0, peakToPeak));
    addElement(new AIElement("spaces",
                            I18N_NOOP("Number of spaces\n(under mean height)"),
                             0, -100, 0, 0, 0, 0, nbSpaces));
    addElement(new AIElement("mean height",I18N_NOOP("Mean height"),
                             0, -100, 0, 0, 0, 0, mean));
    addElement(new AIElement("removed eggs",
                             I18N_NOOP("Number of removed eggs"),
                             20, 0, 100, 0, 0, 0, nbRemoved));
    addElement(new AIElement("nb puyos", I18N_NOOP("Number of puyos"),
                             50, 0, 100, 0, 0, 10, nbPuyos));
    addElement(new AIElement("nb chained",I18N_NOOP("Number of chained puyos"),
                             80, 0, 100, 0, 0, 10, nbChained));
}

int FEAI::nbPuyos(const Board &main, const Board &current)
{
    return static_cast<const FEBoard &>(current).nbPuyos()
        - static_cast<const FEBoard &>(main).nbPuyos();
}

int FEAI::nbChained(const Board &, const Board &current)
{
    return static_cast<const FEBoard &>(current).chained();
}
