/* This file is part of the KDE Project
 *
 * Copyright (C) 2001 Kurt Granroth <granroth@kde.org>
 *
 * This file is distributed under the BSD license. See the file "BSD"
 * in the subdirectory "licenses" of the package for the full license
 * text which has to be applied for this file.
 */
#include <kxmlrpcd.h>
#include <xmlrpcconfig.h>

#include <kaboutdata.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>

#include <qcheckbox.h>
#include <qlayout.h>
#include <qspinbox.h>
#include <qwhatsthis.h>

KXmlRpcModule::KXmlRpcModule(QWidget *parent, const char *name)
  : KCModule(parent, name)
{
  // create our GUI widget
  ui = new XmlRpcConfig(this);

  QVBoxLayout *layout = new QVBoxLayout(this);
  layout->addWidget(ui);

  QString hint = i18n("The daemon is not started by default.\n"
                      "If you check this box, then the next time KDE starts, "
                      "so will the XML RPC daemon.");
  QWhatsThis::add(ui->checkStartDaemon, hint);
  hint = i18n("By default, the daemon uses port 18300 (or higher) to listen "
              "to incoming requests. You may override this here.\n"
              "You may not choose a \"protected\" value (below 1024).");
  QWhatsThis::add(ui->checkSpecifyPort, hint);
  QWhatsThis::add(ui->spinPortNumber, hint);

  connect(ui->checkStartDaemon, SIGNAL(clicked()),
          this,                 SLOT(configChanged()));
  connect(ui->checkSpecifyPort, SIGNAL(clicked()),
          this,                 SLOT(configChanged()));
  connect(ui->spinPortNumber, SIGNAL(valueChanged(int)),
          this,               SLOT(configChanged()));

  load();
}

void KXmlRpcModule::configChanged()
{
  emit changed(true);
}

void KXmlRpcModule::load()
{
  KConfig config("kxmlrpcdrc", true, false);
  KConfigGroupSaver saver(&config, "General");
  ui->checkStartDaemon->setChecked(config.readBoolEntry("StartServer", false));
  ui->spinPortNumber->setValue(config.readNumEntry("Port", 18300));

  ui->checkSpecifyPort->setEnabled(ui->checkStartDaemon->isChecked());
  ui->checkSpecifyPort->setChecked(config.readNumEntry("SpecifyPort", false));
  ui->spinPortNumber->setEnabled(ui->checkSpecifyPort->isEnabled() &&
                                 ui->checkSpecifyPort->isChecked());
  ui->spinPortNumber->setValue(config.readNumEntry("Port", 18300));

  emit changed(false);
}

void KXmlRpcModule::save()
{
  KConfig config("kxmlrpcdrc", false, false);
  KConfigGroupSaver saver(&config, "General");
  config.writeEntry("StartServer", ui->checkStartDaemon->isChecked());
  config.writeEntry("SpecifyPort", ui->checkSpecifyPort->isChecked());
  config.writeEntry("Port", ui->spinPortNumber->value());

  emit changed(false);
}

void KXmlRpcModule::defaults()
{
  if (!ui)
    return;

  ui->checkStartDaemon->setChecked(false);
  ui->checkStartDaemon->setEnabled(true);

  ui->checkSpecifyPort->setChecked(false);
  ui->checkSpecifyPort->setEnabled(false);

  ui->spinPortNumber->setValue(18300);
  ui->spinPortNumber->setEnabled(false);

  emit changed(true);
}

QString KXmlRpcModule::quickHelp() const
{
  return i18n("<h1>XML RPC Daemon</h1> You can configure "
              "the XML RPC daemon here.");
}

const KAboutData* KXmlRpcModule::aboutData() const
{
  KAboutData *about =
    new KAboutData(I18N_NOOP("kcmkxmlrpcd"),
                   I18N_NOOP("KDE XML-RPC Daemon Control Module"),
                   0, 0, KAboutData::License_BSD,
                   I18N_NOOP("(c) 2000 - 2001 Kurt Granroth"));

  about->addAuthor("Kurt Granroth", 0, "granroth@kde.org");

  return about;
}

extern "C" {
  KCModule *create_kcmkxmlrpcd(QWidget *parent, const char *name)
  {
    return new KXmlRpcModule(parent, "kcmkxmlrpcd");
  }
}

#include "kxmlrpcd.moc"
