#include "kab3_part.h"

#include <kinstance.h>
#include <kaction.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kfiledialog.h>
#include <kparts/genericfactory.h>

#include <qfile.h>
#include <qtextstream.h>
#include <klistview.h>
#include <kabc/vcardformat.h>
#include <kabc/stdaddressbook.h>
#include <kabc/resource.h>
#include <kabc/resourcefile.h>
#include "kab3global.h"
#include "kab3mainwidget.h"

using namespace KABC;


typedef KParts::GenericFactory<kab3Part> kab3PartFactory;
K_EXPORT_COMPONENT_FACTORY( libkab3part, kab3PartFactory );

kab3Part::kab3Part( QWidget *parentWidget, const char *widgetName,
                    QObject *parent, const char *name,
                    const QStringList & /*args*/ )
    : KParts::ReadWritePart(parent, name),
      m_widget(0),
      m_ab(0)
{
    KConfig *config;
    setInstance( kab3PartFactory::instance() );
    config=instance()->config();
    m_ab=new KABC::AddressBook();
    m_widget = new Kab3MainWidget(m_ab, parentWidget, widgetName );
    connect(m_ab, SIGNAL(addressBookChanged(AddressBook*)),
            m_widget, SLOT(slotAddressBookChanged(AddressBook*)));
    connect(m_widget, SIGNAL(databaseModified()),
            SLOT(setModified()));
    setWidget(m_widget);
    KStdAction::open(this, SLOT(fileOpen()), actionCollection());
    KStdAction::saveAs(this, SLOT(fileSaveAs()), actionCollection());
    KStdAction::save(this, SLOT(save()), actionCollection());
    actionOpenStdAddressBook=new KAction(
        i18n("Open Standard Address Book"),
        "stdaddressbook",
        0, this, SLOT(openStdAddressbook()),
        actionCollection(), "stdaddressbook");
    setXMLFile("kab3_part.rc");
    setReadWrite(true);
    setModified(false);
    initConfiguration(config);
}

kab3Part::~kab3Part()
{
}

void kab3Part::setReadWrite(bool rw)
{
    m_widget->setReadOnly(!rw);
    ReadWritePart::setReadWrite(rw);
}

void kab3Part::setModified(bool modified)
{
    // get a handle on our Save action and make sure it is valid
    KAction *save = actionCollection()->action
                    (KStdAction::stdName(KStdAction::Save));
    if(!save)
    {
        return;

    }
    // if so, we either enable or disable it based on the current
    // state
    if (modified)
        save->setEnabled(true);
    else
        save->setEnabled(false);

    // in any event, we want our parent to do it's thing
    ReadWritePart::setModified(modified);
}

KAboutData *kab3Part::createAboutData()
{
    // the non-i18n name here must be the same as the directory in
    // which the part's rc file is installed ('partrcdir' in the
    // Makefile)
    KAboutData *aboutData =
        new KAboutData("kab3part", I18N_NOOP("kab3Part"), "3.0");
    aboutData->addAuthor("Mirko Boehm", 0, "mirko@kde.org");
    return aboutData;
}

bool kab3Part::openFile()
{
    m_resource=new KABC::ResourceFile(m_ab, m_file, new KABC::VCardFormat);
    if(m_ab->addResource(m_resource))
    {
        if(m_ab->load())
        {
            emit setStatusBarText(m_url.prettyURL());
            m_widget->slotAddressBookChanged(m_ab);
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

bool kab3Part::saveFile()
{
    if(!isReadWrite())
    {
        return false;
    }

    m_widget->commit();

    KABC::Ticket *t=m_ab->requestSaveTicket(m_resource);
    if(t)
    {
        m_ab->save(t);
        return true;
    } else {
        return false;
    }
}

void kab3Part::fileOpen()
{
    QString file_name = KFileDialog::getOpenFileName();

    if(!file_name.isEmpty())
    {
        openURL(file_name);
    }
}

void kab3Part::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
    QString file_name = KFileDialog::getSaveFileName(QString::null, "*.vcf");
    if (file_name.isEmpty() == false)
        saveAs(file_name);
}

void kab3Part::slotModified()
{
    setModified(true);
}

void kab3Part::initConfiguration(KConfig *config)
{
    m_widget->init(config);
}

void kab3Part::openStdAddressbook()
{
    if(m_ab!=0)
    {
        m_widget->commit();
        saveFile();
    }

    m_ab=StdAddressBook::self();
    m_widget->slotAddressBookChanged(m_ab);
}


#include "kab3_part.moc"
