.TH sane-coolscan2 5 "03/05/2002"
.IX sane-coolscan2
.SH NAME
sane-coolscan2 - SANE backend for Nikon Coolscan film scanners
.SH DESCRIPTION
The
.sane-coolscan2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Epson flatbed scanners.  Some functions of this 
backend should be considered
.B beta-quality
software. Most functions have been stable for a long time, but of 
course new development can not and will not function properly from
the very first day. Please report any strange behavior to the 
maintainer of the backend.

.PP
At present, the following scanners are known to work with this backend:
.PP
.RS
Model:                       Connection Type
.br
---------------------------  -------------------
.br
LS-30 (Coolscan III)         SCSI
.br
LS-40 ED (Coolscan IV)       USB
.RE

.PP
The following scanners should work with this backend, but are unconfirmed:
.PP
.RS
Model:                       Connection Type
.br
---------------------------  -------------------
.br
LS-4000 ED                   IEEE 1394
.br
LS-8000 ED                   IEEE 1394
.RE

Please send mail to the backend author (andras@users.sourceforge.net) to
report successes or failures.

.SH OPTIONS
The options the backend supports can either be selected through command line
options to programs like scanimage or through GUI elements in xscanimage or xsane.

Valid command line options and their syntax can be listed by using 
.RS
scanimage --help -d coolscan2:<interface>:<device>
.RE
where <interface> and <device> specify the device in question, as in the
configuration file (see next section). The "-d" parameter and its argument
can be omitted to obtain information on the first scanner identified. Use
the command
.RS
scanimage -L
.RE
to list all devices recognized by your SANE installation.

The options should be fully described by the description or tooltips given by
frontend. Here is a description of some of the most important options, in the
syntax with which they must be supplied to scanimage:
.TP
.I --frame <n>
This option specifies which frame to operate on, if a motorized film strip
feeder or APS adapter are used. The frame number
.I <n>
ranges from 1 to the number of frames available, which is sensed each time
the backend is initialized (usually each time you start the frontend).
.TP
.I --infrared=yes/no
If set to "yes", the scanner will read the infrared channel, thus allowing
defect removal in software. The infrared image is read during a second scan,
with no options altered. The backend must not be restarted between the scans. 
It will not therefore not work with scanimage, only
with graphical frontends.
.TP
.I --depth <n>
Here <n> can either be 8 or the maximum number of bits supported by the
scanner (10, 12, or 14). It specifies whether or not the scanner reduces
the scanned data to 8 bits before sending it to the backend. If 8 bits are
used, some information and thus image quality is lost, but the amount of data
is smaller compared to higher depths. Also, many imaging programs and image
formats cannot handle depths greater than 8 bits.
.TP
.I --autofocus
Perform autofocus operation. Unless otherwise specified by the other options (
.I --focus-on-centre
and friends), focusing is performed on the centre of the selected scan area.
.TP
.I --ae-wb
.TP
.I --ae
Perform a pre-scan to calculate exposure values automatically.
.I --ae-wb
will maintain the white balance, while
.I --ae
will adjust each channel separately.
.TP
.I --eject
Eject the film strip.
.TP
.I --reset
Reset scanner. The scanner will perform the same action as when power is
turned on: it will eject the film strip and calibrate itself. Use this
whenever the scanner refuses to load a film strip properly, as a result of
which
.I --eject
does not work.

.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/coolscan2.conf specifies the device(s)
that the backend will use. Owing to the nature of the supported connection
types SCSI, USB, and IEEE 1394, the default configuration file supplied with
the SANE distribution should work without being edited.

Each line in the configuration file is either of the following, where all
entries are case-sensitive:
.TP
.I blank or starting with a '#' character
These lines are ignored, thus '#' can be used to include comments.
.TP
.I containing only the word """auto"""
This instructs the backend to probe for a scanner by scanning the buses for
devices with know identifiers. This is the action taken when no
configuration file is present.
.TP
.I a line of the form <interface>:<device>
Here <interface> can be one of "scsi" or "usb", and <device> is the device
file of the scanner. Note that IEEE 1394 devices are handled by the SBP-2
module in the kernel and appear to SANE as SCSI devices.

.SH FILES
.TP
.I @LIBDIR@/libsane-coolscan2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-coolscan2.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I @CONFIGDIR@/coolscan2.conf
Configuration file for this backend, read each time the backend is
initialized.

.SH ENVIRONMENT
.TP
.B SANE_DEBUG_COOLSCAN2
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH "SEE ALSO"
sane\-scsi(5), sane\-usb(5), scanimage(1), xscanimage(1), xsane(1)

.SH BUGS
Currently, the SANE protocol does not allow automatically updating options
whenever the hardware changes. Thus the number of choices for the
.B --frame
option will be fixed when the backend is initialized (usually when the user
runs the frontend). In particular, if there is no film strip in the
automatic film strip feeder when the backend is initialized, the frame option
will not appear at all. Also, restarting the frontend after swapping film
adapters is strongly recommended.

No real bugs currently known, please report any to the backend maintainer
or the SANE developers' email list.

.SH AUTHORS
The backend is written and maintained by Andrs Major
(andras@users.sourceforge.net).
